// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $


// Rosetta Headers
#include "jumping_diagnostics.h"
#include "fullatom.h"
#include "files_paths.h"
#include "make_pdb.h"
#include "pose.h"

// ObjexxFCL Headers
#include <ObjexxFCL/string.functions.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>
#include <string>


//Utility Headers
#include <utility/basic_sys_util.hh>

////////////////////////////////////////////////////////////////////////////////
void
jumping_abort()
{
	//using namespace jumping;
	std::cout << "jumping abort!!" << std::endl;
	utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
}



void
dump_phil_pdb()
{
	static int counter(0);

	++counter;
	std::string filename;
	if ( files_paths::query_defined ) {
		filename = files_paths::code + files_paths::protein_name +
		 "_dump" + lead_zero_string_of( counter, 5 ) + ".pdb";
	} else {
		filename = "dump" + lead_zero_string_of( counter, 5 ) + ".pdb";
	}

	if ( get_fullatom_flag() ) {
		dump_fullatom_pdb( filename );
	} else {
		dump_pdb( filename );
	}
}
