// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $


// Rosetta Headers
#include "jumping_minimize.h"
#include "aaproperties_pack.h"
#include "after_opts.h"
#include "all_atom.h"
#include "all_atom_type.h"
#include "atom_tree_minimize.h"
#include "cenlist.h" // cendist_cutoff2
#include "constraints.h"
#include "count_pair.h"
#include "docking_ns.h"
#include "fullatom.h"
#include "fullatom_energies.h"
#include "fullatom_energy.h" // PBHACK
#include "gb_elec.h"
#include "gl_graphics.h"
#include "hbonds.h"
#include "hbonds_ns.h"
#include "interface.h"
#include "jmp_directions.h"
#include "jmp_maps.h"
#include "jumping_diagnostics.h"
#include "jumping_ns.h"
#include "jumping_refold.h"
#include "jumping_util.h"
#include "loops.h"
#include "maps.h"
#include "minimize.h"
#include "minimize_chi.h"
#include "minimize_ns.h"
#include "min_debug_ns.h"
#include "misc.h"
#include "nblist.h"
#include "nblist_ns.h"
#include "pack.h"
#include "param.h"
#include "param_aa.h"
#include "param_pack.h"
#include "param_torsion.h"
#include "pose.h"
#include "pose_constraints.h"
#include "pose_docking.h"
#include "pose_vdw.h"
#include "ramachandran.h"
#include "refold.h"
#include "rotamer_trials.h"
#include "runlevel.h"
#include "score.h"
#include "score_ns.h"
#include "symmetric_design.h"
#include "template_pack.h"
#include "tether.h"
#include "tether_ns.h"
#include "timer.h"
#include "util_basic.h"
#include "util_vector.h"
#include "vdw.h"
#include "wobble.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzVector.hh>
#include <numeric/xyz.functions.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>


// Namespaces
namespace wacm {
	bool we_are_currently_minimizing( false );
}

// Using

// DANGER DANGER DANGER:
using namespace pose_ns;

void
pose_minimize(
	pose_ns::Pose & pose,
	std::string const & min_type,
	std::string const & move_type,
	Scoring_Function score_fxn, // passed in to ensure correct setup of scorefxn
	bool & gfrag
)
{
	using namespace minimize_ns;
	//using namespace misc;
	using namespace param;
	using namespace param_torsion;
	using namespace runlevel_ns;

	//GRAPHICS_LOG( "pose_minimize" );

	// special routine for atom_tree minimization
	if ( pose.atom_tree() ) {
		gfrag = true;
		atom_tree_minimize( pose, min_type, move_type, score_fxn );
		return;
	}

	//car parameters
	//float const ediff_cutoff = { 15.0 }; // energy cutoff for minimization
	float const warning_cutoff = { 1.0 }; // energy cutoff for warnings

	int const nres( pose.total_residue() );

	//car local
	FArray1D_float phipsi( nres * jmp_total_torsion );
	int nangles;
	FArray1D_float dE_dphipsi( nres * jmp_total_torsion );
	float fret;
	int iter;

	//car debug
	float start_func,end_func,end_score;
	float total_score;


	gfrag = true; // initialize
	// ensure misc arrays are synced with pose
	assert( misc_in_sync( pose ) );

	// PB -- not done in resetphipsi/set_fullatom_flag in pose mode
	setup_allatom_list();
	jmp_setup_torsion_maps( pose.fold_tree(), pose.res(), pose.res_variant(),
													pose.fullatom() );


	// score with rotamer trials if try_rotamer==true
	//fullatom_energy_debug::debug = true;
	pose.score( score_fxn );
	if ( runlevel > standard ) {
		std::cout << "STARTMIN_" << pose.show_scores() << "\n";
	}

	debug_rotamer_trials( pose, score_fxn );
	fullatom_energy_debug::debug = false;

	if ( score_get_try_rotamers() && pose.symmetric() ) {
		pose.new_score_pose();
		pose.score( score_fxn );
	}

	float const start_score( pose.get_0D_score( SCORE ) );

	//Pose save_pose;
	//save_pose = pose;

	score_enable_rotamer_trials( false );

	// dont want coords to get screwed up by multiple copy operations
	pose.fold_from_here();

	//car put angles to minimize into phipsi array
	jmp_pack_phipsi( pose, phipsi,nangles);

	if ( runlevel > standard ) {
		std::cout << "minimize:: nangles= " << nangles << "\n";
	}

	if ( nangles == 0 ) {
		std::cout << "minimize:: no angles to minimize" << "\n";
		minimize_uninit_exclude_list(); // reset for next move
		set_currently_minimizing( false );
		pose.fold_from_current();
		return;
	}

	// setup the nblist:
	jmp_unpack_phipsi(pose,phipsi,gfrag); // sets new_*_refold,
	if ( !gfrag ) {
		std::cout << "gfrag failed" << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	//pose.refold(); // sets new_*_score ===> jmp_domain_map
	assert( get_currently_minimizing() );
	if ( !get_use_nblist() ) {
		if ( runlevel > standard ) {
			std::cout << "WARNING:: minimizing w/o the nblist will be slow"
								<< "\n";
		}
		min_debug::nblist_score_delta_before = 0.0;
		min_debug::nblist_score_delta_after = 0.0;
	} else {
		jmp_update_nblist( pose ); // uses jmp_domain_map
		pose.score( score_fxn );
		float const score_delta( pose.get_0D_score( pose_ns::SCORE ) -
														 start_score );
		if ( runlevel > standard ) {
			std::cout << "score-delta after turning on nblist: " <<
				score_delta << "\n";
		}
		min_debug::nblist_score_delta_before = score_delta;
		if ( std::abs( score_delta ) > 1.0 ) {
#ifndef BOINC
			std::cout <<
				"======================================================\n" <<
				"======================================================\n" <<
				"DANGER!!!! DANGER!!!! DANGER!!!! DANGER!!!! DANGER!!!!\n" <<
				"======================================================\n" <<
				"======================================================\n" <<
				"pose_minimize:: Big score_delta when turning on the" <<
				"nblist: " << score_delta << '\n' <<
				"======================================================\n" <<
				"======================================================\n" <<
				"DANGER!!!! DANGER!!!! DANGER!!!! DANGER!!!! DANGER!!!!\n" <<
				"======================================================\n" <<
				"======================================================" <<
				"\n";
#endif

#ifdef CRAZY_DEBUG
			fullatom_energy_debug::debug = true;
			save_pose.dump_scored_pdb( "before_"+string_of(score_delta)+".pdb",
																 Score_weight_map( score12 ) );

			save_pose.new_score_pose();

			save_pose.dump_scored_pdb( "before2_"+string_of(score_delta)+".pdb",
																 Score_weight_map( score12 ) );

			pose.dump_scored_pdb( "after_"+string_of(score_delta)+".pdb",
														Score_weight_map( score12 ) );
			pose.new_score_pose();
			pose.dump_scored_pdb( "after2_"+string_of(score_delta)+".pdb",
														Score_weight_map( score12 ) );

			fullatom_energy_debug::debug = false;
#endif

		}
	}


	// not using subset_energy with poses; ensure it's off
	score_set_use_subset_energy(false);
	score_enable_rotamer_trials(false);
	minimize_set_func(2);

	//car starting function value for debugging...
	start_func = func(gfrag,phipsi);

	if ( pose_ediff_check( pose ) ) {
		goto L300; // skip the minimize
	}

	//car MINIMIZE
	start_timer("minimize");
	if ( min_type == "linmin" ) {
		for ( int j = 1; j <= 1; ++j ) {
			dfunc(phipsi,dE_dphipsi,nangles);
			linmin(phipsi,dE_dphipsi,nangles,fret,gfrag);
			if ( !gfrag ) goto L300;
		}
	} else if ( min_type == "dfpmin" ) {
		dfpmin(phipsi,nangles,minimize_tolerance,iter,fret,
		 gfrag);
	} else if ( min_type == "dfpmin_atol" ) { /* absolute tolerence */
		dfpmin_atol(phipsi,nangles,minimize_tolerance,iter,fret,gfrag);
	} else if ( min_type == "frpmin" ) {
		frprmn(phipsi,nangles,minimize_tolerance,iter,fret,gfrag);
	} else if ( min_type == "frpmin_atol" ) { /* absolute tolerance */
		frprmn_atol(phipsi,nangles,minimize_tolerance,iter,fret,gfrag);
	} else {
		std::cout << "min_type not defined in function minimize (debump.cc)"
							<< "\n" << "min_type: " << min_type << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
L300:

	if ( !gfrag ) {
		//hijack_best_pose_release();
		score_enable_rotamer_trials(true);
		score_set_use_subset_energy(false);
		set_currently_minimizing(false); // was set to true in pack_phipsi
		minimize_uninit_exclude_list(); // reset for next move
		pose.fold_from_current();
		pose.fold_in_rb_deltas();
		return;
	}

	end_func = func(gfrag,phipsi);

	if ( get_use_nblist() ) {
		// have to re-score the pose with nblist off to ensure correct score
		// since nblist could be out-of-date by now if structure moved a lot
		//
		// we could just call new_score_pose, but we really only need to
		// re-evaluate pairs that have been changing during minimization
		//
		// by calling unpack_phipsi we fill the new_*_refold arrays
		// then refolding fills the new_*_score arrays
		float const tmp_score( pose.get_0D_score( pose_ns::SCORE ) );

		pose_set_use_nblist( false );
		jmp_unpack_phipsi( pose, phipsi, gfrag ); // sets new_*_refold
		//pose.refold(); // private method now
		pose.score( score_fxn );
		float const score_delta( pose.get_0D_score( pose_ns::SCORE ) -
														 tmp_score );
		if ( runlevel > standard ) {
			std::cout << "rescore with nblist off: score-delta= " <<
				score_delta << "\n";
		}
		min_debug::nblist_score_delta_after = score_delta;
		if ( std::abs( score_delta ) > 1.0 ) {
#ifndef BOINC
			std::cout <<
				"======================================================\n" <<
				"======================================================\n" <<
				"DANGER!!!! DANGER!!!! DANGER!!!! DANGER!!!! DANGER!!!!\n" <<
				"======================================================\n" <<
				"======================================================\n" <<
				"pose_minimize:: Big score_delta when turning off the " <<
				"nblist: " << score_delta << '\n' <<
				"This probably means the structure moved too far during\n" <<
				"minimization. If you are minimizing rigid-body translations you\n" <<
				"may need to damp the repulsive initially or change the step-size\n" <<
				"======================================================\n" <<
				"======================================================\n" <<
				"DANGER!!!! DANGER!!!! DANGER!!!! DANGER!!!! DANGER!!!!\n" <<
				"======================================================\n" <<
				"======================================================" <<
				"\n";
#endif
		}
		pose_set_use_nblist( true );
	}

	//car restore default conditions
	score_set_use_subset_energy(false);
	score_enable_rotamer_trials(false);
	set_currently_minimizing(false); // set to true in unpack_phipsi
	pose.fold_from_current();

	pose.fold_in_rb_deltas(); // zero out the deltas!!

	end_score = pose.score( score_fxn );

	if ( runlevel > standard ) {
		std::cout << "ENDMIN_" << pose.show_scores() << "\n";

		if (!benchmark) std::cout << "minimize:: time= " << get_timer("minimize");
		std::cout <<
			" start_score= " << start_score << " end_score= " << end_score <<
			" start_func= " << start_func << " end_func= " << end_func << "\n";
	}

	if ( runlevel > quiet ) {
		if ( end_score - start_score > warning_cutoff ) {
			pose.new_score_pose();
			total_score = pose.score( score_fxn );
			std::cout << "WARNING!! " << move_type << " score increase:" <<
			 SS( start_score ) << SS( end_score ) << SS( start_func ) <<
			 SS( end_func ) << SS( total_score ) << "\n";
		}
	}

	score_enable_rotamer_trials(true);
	minimize_uninit_exclude_list(); // reset for next move
}

////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_dfunc_vdw
///
/// @brief
///
/// @detailed
///car note that this calculates the deriv for all torsion angles even
///car those that are fixed. Because of the way that the derivative is
///car calculated, I don't believe this is a significant slow down (ie
///car have to run over all the atom pairs twice, regardless of the number
///car of torsion angles)
///
///car multiple neighborlists:
///car cendist       centroid distances in current structure, cutoff for vdw
///car dis2_tether   centroid distances in tether structure, cutoff for tether
///
///db computes the derivative of E  with respect to each
///db of the torsion angles.  Using the chain rule, we have
///db
///db dE/d phi = dE/dr *  dr/dphi
///db
///db dr/dphi  = Eab x (V-Vb) . (V' - V)/|V-V'|
///db
///db (the first cross product is the displacement of V upon a rotation dphi
///db around the unit vector Eab, Vb is the coordinates of the second atom in
///db the bond)
///db
///car dE/dR = 2r  (for vdw at least)
///db since | V-V'| = r,
///db
///db dE/ dphi = 2 Eab x (V-Vb) . (V' - V)
///db
///db  note that Eab and Vb are different for each torsion angle, but V'
///db and V are the same.  rearranging:
///db
///db = -  2 Eab X Vb . (V' - V) - 2 Eab . (V' x V).
///db
///db now we need the averages over all Vi of the difference and the
///db crossproduct of V and V'.
///
///car below, Eab x Vb is 'vec'
///car        Eab      is 'unit'
///car        (V'-V)   is 'f2'
///car        'F2tot' = f2*dE_dR (cumulative)
///car        (V' X V) is 'f1' ('F1_xxxE' is cumulative for potential xxx)
///car        eval_dE_dR actually returns dE_dR/r
///
///car if two atoms are fixed relatively in cartesian space, then dr/dphi = 0
///car and there is no contribution to the derivative
///
/// @param  phipsi - [in/out]? -
/// @param  dE_dphipsi - [in/out]? -
/// @param  nangles - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_dfunc_vdw(
	pose_ns::Pose & pose,
	FArray1DB_float & phipsi,
	FArray1DB_float & dE_dphipsi,
	int const nangles
)
{
	using namespace jmp_directions;
	//using namespace jumping;
	using namespace minimize_ns;
	using namespace minimize_ns::deriv_precalc;
	//using namespace misc; // we do use some misc vars but only as misc::
	using namespace param;
	using namespace param_pack;
	using namespace param_torsion;
	using namespace runlevel_ns;
	using namespace scorefxns;   // scorefxn weights
	using namespace tether;
	using numeric::conversions::radians;

	// new routines for poses with atom_trees
	if ( pose.atom_tree() ) {
		atom_tree_dfunc_vdw( pose, phipsi, dE_dphipsi );
		return;
	}

	//PB: 10/29
	//phipsi.dimension( nangles );
	//dE_dphipsi.dimension( nangles );

//car recursive derivative calculation
//car see Braun and Go, JMB 1985 186:611-26
//car     Guntert,Braun & Wuthrich JMB 1991 217:517-53

//car local
	int i; // residue of current torsion angle
	int torsion; // angle type of current torsion angle
	int end_res,end_atom; // N-term atoms in torsion bond
	int dir,sign_factor;

	// body region
//	FArray1D_float ixyz(3), jxyz(3); // coordinates of ires,iat and jres,jat
	float deriv,deriv1,deriv2,loop_deriv;
	float rama_deriv,fa_prob_deriv;
	float fa_pair_factor;
//	float dis2;
	FArray1D_float unit( 3 );
	FArray1D_float vect( 3 );
	FArray1D_float F1_allE( 3 );
	FArray1D_float F2_allE( 3 );
	FArray3D_float F1_atompairE( 3, jmp_total_torsion, MAX_RES()() );
	FArray3D_float F2_atompairE( 3, jmp_total_torsion, MAX_RES()() );
	FArray3D_float F1_dock_elecE( 3, jmp_total_torsion, MAX_RES()() );
	FArray3D_float F2_dock_elecE( 3, jmp_total_torsion, MAX_RES()() );
	FArray3D_float F1_respairE( 3, jmp_total_torsion, MAX_RES()() );
	FArray3D_float F2_respairE( 3, jmp_total_torsion, MAX_RES()() );

	FArray3D_float F1_hbondE( 3, jmp_total_torsion, MAX_RES()() );
	FArray3D_float F2_hbondE( 3, jmp_total_torsion, MAX_RES()() );
	FArray1D_float end_pos( 3 );

	//int first_res,last_res;
	//int first_res_sc, last_res_sc;

	FArray2D_float dunbrack_deriv( total_torsion, MAX_RES()() );
	FArray2D_float torsion_tether_deriv( total_bb_torsion, MAX_RES()() );
	float tmp1,tmp2;
	float sr_hbenergy,lr_hbenergy;

//tsa local copy of rotarray and chiarray to evaluate dunbrack deriv
	FArray2D_int rotarray( MAX_CHI, MAX_RES()() );
	FArray2D_float chiarray( MAX_CHI, MAX_RES()() );

	float fa_dun_factor, fa_prob_factor;

//car variables for numerical derivative check
	FArray1D_float phipsi_ori( MAX_RES()() * jmp_total_torsion );
	float f11,f00,f22,deriv_dev;
	bool gfrag;
	float ratio;
	float increment;

//car precalculate constants (weights and constants in derivatives)
//car constants from form of derivatives
//car  except 0.8 for vdw which is weight applied inside vdw_compute
	tether_factor = 0.0;
	if ( tether_norm != 0.0 ) tether_factor = -4.0*tether_weight/tether_norm;
	vdw_factor = -4.*0.8*vdw_weight;

	fa_pair_factor = pack_wts.Wpair()*fa_pair_weight;
	fa_dun_factor = pack_wts.Wdun()*fa_dun_weight;
	fa_prob_factor = pack_wts.Wone()*fa_prob1b_weight;

//car retrieve flag to pass to functions

	/////////////////
	// POSE interface
	bool const fullatom ( pose.fullatom() );
	FArray2D_int const & jump_point
		( pose.fold_tree().get_jump_point() );

	// puts the torsions from phipsi into pose
	jmp_unpack_phipsi( pose, phipsi, gfrag );

	if ( ! gfrag ) return; // set deriv to 0?

	// copy data to misc::
	pose.copy_to_misc();

	if ( get_dfunc_dump() ) {
		dump_phil_pdb();
	}

	if ( jumping::jverbose ) {
		std::cout << "dfunc refold" << "\n";
	}

	if ( fullatom && ( param_pack::gen_born || fa_pair_weight != 0.0 ) ) {
		// fill in the template_pack neighbors arrays
		// pair term and gb deriv assume these are up to date
		make_neighbor_info( misc::res, pose.total_residue_for_scoring(),
												misc::full_coord, template_pack::neighborlist,
												template_pack::neighbors );
	}

//car if not fullatom mode, put position array+centroids in full_coord array
	//pose.update_fullcoord();
	// stick with the old scheme, currently.
	// we are using "misc" as our coordinate scratch-pad
	minimize_update_fullcoord();


	// new-chi refolding is now handled by pose.refold()
	//first_res_sc = total_residue+1;
	//last_res_sc = 0;
	//if ( minimize_vary_chi ) {
		// update the minimized chi angles on full_coord after
		//   backbone refold is complete
	//refold_new_chi( first_res_sc, last_res_sc );
	//}

//car update nblist
	// this adds constraints/disulfs not already on the list
	drv_update_nblist();

// Compute the H-bond energy and derivatives

	// BIG-TIME access to misc coords here; also it rebuild
	// full_coord HN and HA if !fullatom
	misc::total_residue = pose.total_residue_for_scoring();
	evaluate_hbenergy(hbonds::hbderiv_ABE_GO,sr_hbenergy,lr_hbenergy); //JSS just fills arrays; ignores return
	misc::total_residue = pose.total_residue();

pack_wts.set_lock(); // jss tmp
jmp_hbond_compute_deriv( pose,
													 pack_wts.Whb_srbb()*pack_wts.Whbond_bb(),
													 pack_wts.Whb_lrbb()*pack_wts.Whbond_bb(),
													 pack_wts.Whb_sc()*pack_wts.Whbond_bb_sc(),
													 pack_wts.Whb_sc()*pack_wts.Whbond_sc(),
													 F1_hbondE, F2_hbondE );
pack_wts.release_lock(); // jss tmp

	// ctsa update chi and rotamer maps for dunbrack derivative
	//   and pre-calculate dunbrack deriv in first-last res range
	//
	if ( fullatom && fa_dun_factor != 0. ) {
		// AGAIN: we are currently assuming that our call to pose.refold()
		// has stashed the updated coords in the "misc" arrays
		// so all scoring becomes a lot simpler
		get_chi_and_rot_from_coords( misc::total_residue, misc::res, misc::res_variant,
		 misc::full_coord, chiarray, rotarray );
		// prob dont need 1,total_residue
		eval_total_dunbrack_deriv( 1, misc::total_residue, chiarray, rotarray, dunbrack_deriv );
	}

	// evaluate bb torsion tether deriv
	if ( phipsi_weight != 0.0 )
	 calculate_phipsi_torsion_tether_score(tmp1, torsion_tether_deriv);
	if ( omega_weight != 0.0 )
		calculate_omega_torsion_tether_score(tmp2, torsion_tether_deriv);

	// ctsa    calc pair energy derivative
	//
	if ( fullatom && fa_pair_factor != 0.0 ) {
		jmp_get_total_pair_deriv( pose, F1_respairE, F2_respairE );
	}

	//  get derivative of all atom pair potentials
	//  this includes the chain break derivatives!!

	jmp_get_atompairE_deriv( pose, F1_atompairE, F2_atompairE, fullatom );


	// get docking warhsel electrostatic derivatives
	bool dock_elec_deriv_exist =
		jmp_get_dock_warshel_elec_deriv( pose, F1_dock_elecE, F2_dock_elecE, fullatom );

//car for each torsion angle in the angle map:
// 1) combine all distance derivs and complete conversion to angular deriv
// 2) calc other anglular derivs and sum in
//

// OTHER ORDER NOW !!!!!!!!!!!!!!
//pb	for ( int imap = map_length; imap >= 1; --imap ) { // iterate from one end of tree to other
	for ( int imap = 1; imap <= map_length; ++imap ) {
		i       = angle_map(imap);
		torsion = angle_type(imap);
		dir     = angle_direction(imap);

		if ( jumping::jverbose ) std::cout << "dfunc" <<
		 SS( i ) << SS( torsion ) << SS( dir ) << "\n";

		deriv = 0.0;

//pb  I think the second check represents a bug (?) in the old calculation!
//car these should never get into the map
//pb		if ( i == 1 && torsion == phi_torsion ) goto L110;
//pb		if ( i == total_residue && torsion == psi_torsion ) goto L110;
//pb		if ( i == total_residue && torsion == omega_torsion ) goto L110;

		// sum F1,F2 from different energy components
		// atomic pair potentials and residue pair score
		//
		for ( int j = 1; j <= 3; ++j ) {
			F1_allE(j) = F1_atompairE(j,torsion,i);
			F2_allE(j) = F2_atompairE(j,torsion,i);
		}

//car  pre-computed h-bond contribution
		for ( int j = 1; j <= 3; ++j ) {
			F1_allE(j) += F1_hbondE(j,torsion,i);
			F2_allE(j) += F2_hbondE(j,torsion,i);
		}

//tsa  add F1,F2 from the pair energy derivative to the total F1,F2
		if ( fullatom && fa_pair_factor > 0.0 ) {
			for ( int j = 1; j <= 3; ++j ) {
				F1_allE(j) += fa_pair_factor* F1_respairE(j,torsion,i);
				F2_allE(j) += fa_pair_factor* F2_respairE(j,torsion,i);
			}
		}

		//chu docking_warshel_electrostatics
		if ( dock_elec_deriv_exist ) {
			for ( int j = 1; j <= 3; ++j ) {
				F1_allE(j) += F1_dock_elecE(j,torsion,i);
				F2_allE(j) += F2_dock_elecE(j,torsion,i);
			}
		}

		// convert combined F1,F2 to an angular derivative
		//  using Abe Go trick
		//

		if ( torsion_type_is_bb(torsion) || torsion_type_is_chi(torsion) ) {
		 // old situation: bb or chi ---------------
			make_unit_vector(i,torsion,unit,end_atom,end_res);
			cros(unit,misc::full_coord(1,end_atom,end_res),vect);
			if ( dir == n2c && torsion_type_is_bb(torsion) ) {
				sign_factor = -1; // non-classical direction
			} else {
				sign_factor = 1;
			}
			deriv -= sign_factor * radians( dotprod(unit,F1_allE) + dotprod(vect,F2_allE) );
		} else if ( torsion_type_is_rb(torsion) ) { // rigid-body ------------
			// dir is the direction we are moving across the jump
			// dir is by definition from upstream to downstream
			// see jmp_(un)pack_phipsi and jmp_link_torsion_vectors
			int const downstream_pos
				( dir == n2c ? jump_point(2,i) : jump_point(1,i) );
			int const upstream_pos // the residue being moved
				( dir == n2c ? jump_point(1,i) : jump_point(2,i) );
			//std::cout << "jmp_dfunc_vdw:: rb-torsion: i= " << i <<
			//	" dir= " << dir << " torsion= " << torsion <<
			//	" upstream_pos= " << upstream_pos <<
			//	" downstream_pos= " << downstream_pos << "\n";
			const Jump & jump ( pose.get_jump(i) );
			make_rb_unit_vector_end_pos( dir, jump,
			 misc::Eposition(1,1,downstream_pos),
			 misc::Eposition(1,1,upstream_pos),
			 torsion,unit, end_pos);
			//std::cout << "unit: " << unit(1) << ' ' << unit(2) << ' ' << unit(3)
			//					<< "\n";
			if ( torsion_type_is_rb_angle(torsion) ) {
				// rigid-body angle ------
				cros(unit,end_pos,vect);
				deriv = deriv - radians( dotprod(unit,F1_allE) + dotprod(vect,F2_allE) );
			} else if ( torsion_type_is_rb_translation(torsion) ) {
				// rigid-body translation ------
				// F2_allE is a sum of dE_dR* (1/|r|) * r
				// where r is vector from fixed_posn to moving_posn
				deriv += dotprod(unit,F2_allE);
			}
		}

		/////////////////////////////////////////////////////////////////
		// pose torsion tethering: bb or chi, using Pose's Cst_set object
		if ( pose.constraints_exist() ) {
			float const weight
				( ( torsion==phi_torsion || torsion==psi_torsion ) ? phipsi_cst_weight:
					( ( torsion == omega_torsion ) ? omega_cst_weight :
						( ( torsion_type_is_chi( torsion ) ) ? chi_cst_weight : 0.0 )));
			if ( weight != 0.0 ) {
				deriv += weight * pose.constraints().rosetta_torsion_deriv( i, torsion,
									 pose.get_torsion_by_number( i, torsion ) );
			}
		}


		if ( torsion_type_is_bb(torsion) || torsion_type_is_chi(torsion) ) {
		 // dunbrack: bb or chi
			if ( fullatom && fa_dun_factor != 0. ) {
				deriv += dunbrack_deriv(torsion,i) * fa_dun_factor;
			}
		}

		if ( torsion_type_is_bb(torsion) ) { // bb only
			eval_loop_deriv(i,torsion,unit,loop_deriv); // loop
			deriv += loop_deriv;

			if ( ramachandran_weight != 0. ) { // rama
				rama_deriv = get_rama_score_residue_deriv(misc::res(i),misc::phi(i),misc::psi(i),
				 misc::secstruct(i),torsion);
				deriv += rama_deriv * ramachandran_weight;
			}

			if ( fa_prob_factor != 0.0 ) {
				fa_prob_deriv = get_Paa_pp_deriv(misc::res(i), misc::phi(i), misc::psi(i), torsion);
				deriv += fa_prob_deriv * fa_prob_factor;
			}

			// old-style torsion tethering
			if ( phipsi_weight != 0.0 ) { // torsion tethers
				if ( torsion == phi_torsion || torsion == psi_torsion ) {
					deriv += phipsi_weight * torsion_tether_deriv(torsion,i);
				}
			}
			if ( omega_weight != 0.0 ) { // torsion tethers
				if ( torsion == omega_torsion ) {
					deriv += omega_weight * torsion_tether_deriv(torsion,i);
				}
			}


		}

		if ( torsion_type_is_rb_translation( torsion ) ) {
			// re-scale if torsion is rb-translation
			deriv /= minimize_ns::rb_translation_scale_factor;
		}

//L110:; // skip torsion

		if ( pose.symmetric() ) {
			deriv *= pose.symmetry_info().deriv_scale_factor( i, torsion );
		}

		dE_dphipsi(imap) = deriv;
	}                     // loop over map

	//if ( pose.symm() ) symmetrize_phipsi( pose, dE_dphipsi, true );

	if ( ! minimize_get_deriv_check() ) return;

//  	if ( ! jumping::jdebug ) return;
//	if ( runlevel <= gush ) return;

	/////////////////////////////////////////////////////////////////////////////
	// NUMERICAL DERIVATIVE CHECK
	/////////////////////////////////////////////////////////////////////////////
	// how to analyze this:
	//
	// in gnuplot, look at numerical vs analytical derivs:
	// plot '< grep ratio a3.log ' u 6:7,x
	//
	// also sort by deriv_dev lines:
	//
	// by magnitude of deviation
	// grep deriv_dev a3.log | sort -g +8
	//
	// or by ratio of deviation to actual
	//
	// grep deriv_dev a3.log | sort -g +9

	increment = 0.0005; // PB -- 3/02
//  	increment = 0.001;
	int const n_increment = 5;
	FArray2D_float dE_dphipsi_numeric( nangles, n_increment );

	// setup for saving diagnostics
	min_debug::nangles = nangles;
	if ( nangles > int( min_debug::abs_deriv_dev.size1() ) ) {
		min_debug::abs_deriv_dev.dimension( nangles );
		min_debug::rel_deriv_dev.dimension( nangles );
	}

	gfrag = true;
	for ( int i = 1; i <= nangles; ++i ) {
		phipsi_ori(i) = phipsi(i);
	}

	f00 = func(gfrag,phipsi);
	for ( int i = 1; i <= nangles; ++i ) {
		if ( i%10==0 )
			std::cout << "checking derivatives: angle= " << i << " nangles= " <<
				nangles << "\n";

		deriv_dev = 10000.0;
		for ( int j = 1,factor=1; j <= n_increment; ++j ) {
			factor*=2;
			phipsi_ori(i) = phipsi(i) + factor * increment;
			if ( ! torsion_type_is_rb_translation(angle_type(i)) )
			 angle_in_range(phipsi_ori(i));
			f11 = func(gfrag,phipsi_ori);
			phipsi_ori(i) = phipsi(i) - factor * increment;
			if ( ! torsion_type_is_rb_translation(angle_type(i)) )
			 angle_in_range(phipsi_ori(i));
			f22 = func(gfrag,phipsi_ori);

			deriv = ( f11 - f22 ) / ( factor * 2 * increment );
			deriv1 = ( f11 - f00 )/ ( factor * increment );
			deriv2 = ( f00 - f22 )/ ( factor * increment );
			dE_dphipsi_numeric( i, j ) = deriv;

			deriv_dev = std::min( deriv_dev, std::abs( deriv  - dE_dphipsi(i) ) );
			deriv_dev = std::min( deriv_dev, std::abs( deriv1 - dE_dphipsi(i) ) );
			deriv_dev = std::min( deriv_dev, std::abs( deriv2 - dE_dphipsi(i) ) );

			phipsi_ori(i) = phipsi(i);

			if ( std::abs( dE_dphipsi(i) ) > 0.001 ) {
				ratio = deriv / dE_dphipsi(i);
			} else {
				ratio = 0.0;
			}
			if ( runlevel > standard &&
					 ( std::abs(dE_dphipsi(i)) > 0.001 || std::abs(deriv) > 0.01 ) ) {
				// if you change this output, please also change the comments
				// at the beginning of this section
				std::cout << "ratio" << I( 4, i ) << I( 4, j ) <<
					I( 4, angle_map(i) ) << I( 4, angle_type(i) ) <<
					F( 10, 4, deriv ) <<
					F( 10, 4, dE_dphipsi(i) ) <<
					F( 10, 4, ratio ) <<
					F( 10, 4, deriv1 ) <<
					F( 10, 4, deriv2 ) <<
					F( 10, 4, f11 ) <<
					F( 10, 4, f00 ) <<
					F( 10, 4, f22 ) <<
					F( 10, 4, phipsi(i) ) << "\n";
			}
		}
		if ( true ) {
//  		if ( deriv_dev > 0.1 ) {
			if ( std::abs( dE_dphipsi(i) ) > 0.001 ) {
				ratio = deriv_dev / std::abs( dE_dphipsi(i) );
			} else {
				ratio = 0.0;
			}

			min_debug::rel_deriv_dev( i ) = ratio;
			min_debug::abs_deriv_dev( i ) = deriv_dev;


			if ( runlevel > standard ) {
				// if you change this output, please also change the comments
				// at the beginning of this section
				std::cout << "deriv_dev:" << SS(i) << SS(nangles) << SS(f00) <<
					SS( angle_map(i) ) << SS( angle_type(i) ) << SS( angle_direction(i) ) <<
					SS( dE_dphipsi(i) ) << SS( deriv_dev ) << SS(ratio) << "\n";
			}
		}
	}

	// calculate magnitudes, dot products of gradient vectors
	FArray1D_float norm_numeric(n_increment,0.0), dot(n_increment,0.0);
	float norm(0.0);
	for ( int i=1; i<= nangles; ++i ) {
		norm += dE_dphipsi(i) * dE_dphipsi(i);
		for ( int j=1; j<= n_increment; ++j ) {
			dot(j) += dE_dphipsi(i) * dE_dphipsi_numeric(i,j);
			norm_numeric(j) += dE_dphipsi_numeric(i,j) * dE_dphipsi_numeric(i,j);
		}
	}
	norm = std::sqrt( norm );

	min_debug::best_cos_theta = 0.0;
	min_debug::best_abs_log_norm_ratio = 200.0;
	min_debug::best_norm_analytic = 999.9;
	min_debug::best_norm_numeric  = 999.9;

	for ( int j=1; j<= n_increment; ++j ) {
		norm_numeric(j) = std::sqrt( norm_numeric(j) );

		// handle strange cases
		float log_norm_ratio;
		if ( norm < 0.001 && norm_numeric(j) < 0.001 ) {
				log_norm_ratio = 1.0;
		} else if ( norm < 0.001 ) {
			log_norm_ratio = 100.0;
		} else if ( norm_numeric(j) < 0.001 ) {
			log_norm_ratio = -100.0;
		} else {
			log_norm_ratio = std::log( norm_numeric(j) / norm );
		}

		float const cos_theta( dot(j) / ( norm * norm_numeric(j)) );

		std::cout <<
			" norm: " << j << ' ' << norm <<
			" norm_numeric: " << norm_numeric(j) <<
			" cos_theta: " << cos_theta <<
			" log_norm_ratio: " << log_norm_ratio << "\n";

		min_debug::best_cos_theta = std::max( min_debug::best_cos_theta,
																					cos_theta );
		if ( std::abs( log_norm_ratio ) < min_debug::best_abs_log_norm_ratio ) {
			min_debug::best_abs_log_norm_ratio = std::abs( log_norm_ratio );
			min_debug::best_norm_analytic = norm;
			min_debug::best_norm_numeric = norm_numeric(j);
		}
	}
}


//////////////////////////////////////////////////////////////////////////////
void
minimize_get_deriv_check_stats(
	int & nangles,
	int & nangles1,
	int & nangles2,
	float & cos_theta,
	float & abs_log_norm_ratio,
	float & norm_analytic,
	float & norm_numeric,
	float & score_delta1,
	float & score_delta2,
	float const abs_tol,
	float const rel_tol
)
{
	nangles = min_debug::nangles;
	cos_theta = min_debug::best_cos_theta;
	abs_log_norm_ratio = min_debug::best_abs_log_norm_ratio;
	norm_analytic = min_debug::best_norm_analytic;
	norm_numeric = min_debug::best_norm_numeric;
	score_delta1 = min_debug::nblist_score_delta_before;
	score_delta2 = min_debug::nblist_score_delta_after;

	nangles1 = 0;
	nangles2 = 0;

	for ( int i=1; i<= nangles; ++i ) {
		if ( min_debug::abs_deriv_dev( i ) > abs_tol ) {
			++nangles1;
			if ( min_debug::rel_deriv_dev( i ) > rel_tol ) {
				++nangles2;
			}
		}
	}


}


//////////////////////////////////////////////////////////////////////////////
void
minimize_show_deriv_check_stats(
	std::ostream & log
)
{
	// #angles
	// #angles w/ absolute deviation > abs_tol
	// #angles w/ relative deviation > rel_tol and abs dev > abs_tol
	// best cos-theta, best norm-ratio over the different increments
	//
	float const abs_tol( 0.1 ), rel_tol( 0.1 );
	int nangles, nangles1, nangles2;
	float cos_theta, norm_ratio, norm_analytic, norm_numeric,
		score_delta1, score_delta2;

	minimize_get_deriv_check_stats( nangles, nangles1, nangles2, cos_theta,
		norm_ratio, norm_analytic, norm_numeric, score_delta1, score_delta2,
		abs_tol, rel_tol );

	log << "deriv_check: " << I(4,nangles) << I(4,nangles1) << I(4,nangles2) <<
		' ' << F(9,6,1.0-cos_theta) << ' ' << F(9,6,norm_ratio) << ' ' <<
		F(9,3,norm_analytic) << ' ' << F(9,3,norm_numeric) << ' ' <<
		F(9,3,score_delta1) << ' ' << F(9,3,score_delta2) << " tols: " <<
		abs_tol << ' ' << rel_tol;


}
//////////////////////////////////////////////////////////////////////////////
bool
minimize_get_deriv_check()
{
	using namespace min_debug;

	if ( ! deriv_check_init ) {
		deriv_check_init = true;
		deriv_check = truefalseoption("deriv_check");
	}
	return deriv_check;
}

//////////////////////////////////////////////////////////////////////////////
void
minimize_set_deriv_check(
	bool const setting
)
{
	min_debug::deriv_check = setting;
	min_debug::deriv_check_init = true;
}

//////////////////////////////////////////////////////////////////////////////
bool
get_dfunc_dump()
{
	static bool init(false),dfunc_dump(false);

	if ( ! init ) {
		init = true;
		dfunc_dump = truefalseoption("dfunc_dump");
	}
	return dfunc_dump;
}


//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_get_atompairE_deriv
///
/// @brief
///
/// @detailed
///
/// @param  first_res - [in/out]? -
/// @param  last_res - [in/out]? -
/// @param  F1_atompairE - [in/out]? -
/// @param  F2_atompairE - [in/out]? -
/// @param  fullatom - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_get_atompairE_deriv(
	pose_ns::Pose & pose,
	FArray3DB_float & F1_atompairE,
	FArray3DB_float & F2_atompairE,
	bool const fullatom
)
{
	using namespace aaproperties_pack;
	//using namespace cenlist_ns;
	using namespace jmp_maps;
	//using namespace jumping;
	using namespace minimize_ns;
	using namespace minimize_ns::deriv_precalc;
	//using namespace misc;
	using namespace nblist;
	using namespace param;
	using namespace param_pack;
	using namespace param_torsion;
	//using namespace scorefxns; // PB-- make explicit with ::
	using namespace tether;

	//F1_atompairE.dimension( 3, jmp_total_torsion, MAX_RES() );
	//F2_atompairE.dimension( 3, jmp_total_torsion, MAX_RES() );

	// POSE interface //
	// under current hack-scheme, we are assuming that pose.refold()
	// copied the updated positions into misc (our coordinate scratch-pad)
	FArray1D_int const & jmp_domain_map ( pose.get_domain_map() );//
	FArray4D_float const & jmp_overlap_Eposition
		( pose.get_overlap_Eposition( jumping::jmp_chainbreak_overlap ) );

	Fold_tree const & fold_tree ( pose.fold_tree() );
	FArray1D_bool const & is_cutpoint ( fold_tree.get_is_cutpoint() );
	int num_fold_tree_cutpoint;
	FArray1D_int const & fold_tree_cutpoint
		( fold_tree.get_fold_tree_cutpoint( num_fold_tree_cutpoint ) );

// locals
	int aa,aav,imap,jmap;
	int n_tor_atom;
	int ii,ires,iat,jres,jat,jallat,jjend;
	float dE_dR;
	FArray1D_float f1( 3 );
	FArray1D_float f2( 3 );
	bool constraints_exist;
	float pc_score; // local only
	bool use_nblist;

// tmp torsion order hack
//	FArray1D_int torsion_order_map( total_torsion );
//	int tor;

//------------------------------------------------------------------------------
//car precalculate constants (weights and constants in derivatives)
//car constants from form of derivatives
//car  except 0.8 for vdw which is weight applied inside vdw_compute
	use_nblist = get_use_nblist();

	//use_nblist = false;

	if ( use_nblist ) {
		drv_update_nblist();
	}

	tether_factor = 0.0;
	if ( tether_norm != 0.0 ) tether_factor = -4.0*scorefxns::tether_weight/tether_norm;
	vdw_factor = -4.*0.8*scorefxns::vdw_weight;
	fa_rep_factor = pack_wts.Wrep()*scorefxns::fa_rep_weight;
	fa_atr_factor = pack_wts.Watr()*scorefxns::fa_atr_weight;
	fa_solv_factor = pack_wts.Wsol()*scorefxns::fa_solv_weight;

	//car determine if constraints need to be minimized; can't skip some pairs
	//car if constraints included
	classical_constraints::BOUNDARY::eval_pairConstraint(0,pc_score); // update distances,distances**2
	classical_constraints::BOUNDARY::precalc_cst_deriv(); // precalc factor for deriv
	constraints_exist = classical_constraints::BOUNDARY::get_constraints_exist();

	// pose constraints
	//const cst_set_ns::Cst_set * pose_constraints ( pose.constraints() );
	//bool const symmetric_pose( pose.symm() > 1 );

	//car obtain cendist to determine which atoms can be skipped
	if ( !use_nblist ) {
		pose_update_cendist( pose );
	}
	Score_state cendist_state;
	FArray2D_float const & cendist ( pose.get_2D_score( CENDIST, cendist_state ));

	// car  initialize  joint atom-pair derivatives
	//
	for ( int seqpos = 1; seqpos <= misc::total_residue; ++seqpos ) {
		for ( int torsion = 1; torsion <= jmp_total_torsion; ++torsion ) {
			for ( int k = 1; k <= 3; ++k ) {
				F1_atompairE(k,torsion,seqpos) = 0.0;
				F2_atompairE(k,torsion,seqpos) = 0.0;
			}
		}
	}

	for ( int jmp_tor = 1; jmp_tor <= jmp_torsion_map_length; ++jmp_tor ) {
		// I am assuming that by traversing the map, we build the entire protein.
		// not everyone in the map will move some atoms: of the rigid body
		// degrees of freedom, only the last one of the translations actually
		// determines the position of an atom (the downstream c-alpha);
		// of the rigid-body rotations, only the last one determines the positions
		// of atoms (cb (+sidechain if fa and not varying chi),
		//           n, carbonyl-C, h-alpha)
		//
		// 1. if we have any jumps, these are in the map
		// 2. if we are in full-atom mode, the chi angles may or may not be in the
		//        map. If they aren't in the map, then phi or psi (depending on the
		//        direction) should move all the sidechain atoms, or at upstream
		//        jump-points the final rigid body rotation will move the sc-atoms.
		// 3. not everything in the map has to be varying. This is handled by
		//        jmp_pack and unpack_phipsi
		// 4. note that jmp_atomlist_length will be 0 for torsions that
		//        arent individually fixing any atoms.

		int const seqpos  = jmp_torsion_map(1,jmp_tor);
		int const torsion = jmp_torsion_map(2,jmp_tor);
		int const jmp_dir = jmp_torsion_map(3,jmp_tor);

		// NOTE: if torsion is a jump torsion, seqpos is the jump_number

		//////////////////////
		// chainbreaks, part I
		// add derivative for the last torsion before a chainbreak
		if ( torsion_fixes_overlap( seqpos, torsion, jmp_dir, misc::total_residue,
																is_cutpoint ) &&
				 scorefxns::jmp_chainbreak_weight != 0.0 ) {
			add_chainbreak_overlap_deriv(pose,seqpos,torsion,jmp_dir,
			 F1_atompairE(1,torsion,seqpos),
			 F2_atompairE(1,torsion,seqpos));
		}


		aa = misc::res(seqpos);
		aav = misc::res_variant(seqpos);

		n_tor_atom = jmp_atomlist_length(torsion,seqpos);

		for ( int tor_atom = 1; tor_atom <= n_tor_atom; ++tor_atom ) {
			ii = jmp_atomlist(tor_atom, torsion, seqpos);

			ires = global_atm_num2res_num_map(ii);
			iat = global_atm_num2res_atm_num_map(ii);
			imap = jmp_domain_map(ires);

			if ( pose.pseudo(ires) ) continue;

			/////////////////////////////////
			// calc chainbreak deriv, part II
			// if this is a bb-atom within chainbreak_overlap of a cutpoint::
			add_chainbreak_derivative( ires, misc::res(ires), iat,
			 F1_atompairE(1,torsion,seqpos),
			 F2_atompairE(1,torsion,seqpos), num_fold_tree_cutpoint,
			 fold_tree_cutpoint, jmp_overlap_Eposition );

			////////////////////////////
			// new constraint derivative: atompair derivatives and coordinate tether
			//
			if ( pose.constraints_exist() ) {
				numeric::xyzVector_float f1_v(0.0), f2_v(0.0);
				fill_atom_cst_F1_F2( pose, scorefxns::kin_3D_cst_weight,
														 scorefxns::atompair_cst_weight,
														 scorefxns::coord_cst_weight,
														 scorefxns::chainbreak_cst_weight,
														 ires, iat, f1_v, f2_v );
				for ( int k=1; k<= 3; ++k ) {
					F1_atompairE(k,torsion,seqpos) += f1_v(k);
					F2_atompairE(k,torsion,seqpos) += f2_v(k);
				}
			}
			jjend = drv_nb_len(ii);


			///////////
			// gb deriv
			if ( param_pack::gen_born && scorefxns::fa_gb_elec_weight != 0.0 ) {
				eval_gb_deriv( iat, ires, pose, template_pack::neighborlist,
											 param_pack::pack_wts.Wgb_elec() * scorefxns::fa_gb_elec_weight,
											 F1_atompairE(1,torsion,seqpos),
											 F2_atompairE(1,torsion,seqpos) );
			}

			// PB -- double-check that deriv_update_nblist is working correctly
			// will fail for constraints
			//
			// it's a pain that we have to add non-neighbor things to the neighborlist
			// I can see the efficiency argument... then everything can happen inside
			// eval_de_dr
			//
			// but it's kind of confusing and I think more error-prone
			//
			// right now the non-nb things are:
			// old-style constraints and disulfides: see drv_update_nblist
			//
			// nicer if de_dr were just atr+rep+sol (FULLATOM) or vdw (CENTROID)
			//
			// then we'd have outside calls to add in the other derivs...
			// that crazy early return in drv_update_nblist will trigger this assert-failure
			if ( use_nblist ) {
				assert( jjend >= nb_len(ii) );
			} else {
				jjend = total_atoms;
			}
			for ( int jj = 1; jj <= jjend; ++jj ) {
				if ( use_nblist ) {
					jallat = nb(jj,ii);
				} else {
					jallat = jj;
				}

				if ( jallat == ii ) goto L100; // no self-interactions(?)

				jat = global_atm_num2res_atm_num_map(jallat);
				jres = global_atm_num2res_num_map(jallat);
				jmap = jmp_domain_map(jres);

				if ( jmap == imap && jmap != 0 ) goto L100;

				if ( pose.pseudo( jres ) ) continue;

				if ( use_nblist ) goto L200;

				// car these checks only have benefit if not using the nblist
				// note that cendist might not even be properly updated
				// if use_nblist is true ( see POSE interface above )

				if ( fullatom ) {
					// PB: I dont like this...
					//std::cout << "jmp_get_atompairE_deriv:: using a cendist" <<
					//	" cutoff in fullatom mode\n";
				}

				if ( cendist(ires,jres) > cenlist_ns::cen_dist_cutoff2 ) {
					// skip unless constraints or tether must be checked
					if ( constraints_exist ) goto L200;
					if ( scorefxns::tether_weight != 0.0 ) {
						if ( dis2_tether(ires,cutoff_atm,jres,cutoff_atm) <=
						 cenlist_ns::cen_dist_cutoff2 ) goto L200;
					}
					goto L100;
				}

L200:

				eval_dE_dR(ires,iat,jres,jat,
				 misc::res(ires),misc::res(jres),
				 misc::res_variant(ires),misc::res_variant(jres),
				 fullatom,dE_dR,f1,f2);

 				if ( false && std::abs(dE_dR) > 0.00001 ) {
 					std::cout << "seqpos,torsion,ires,iat,jres,jat" << SS( seqpos ) <<
 						SS( torsion ) << SS( ires ) << SS( iat ) <<
 						SS( jres ) << SS( jat ) << SS( dE_dR ) << SS( torsion ) <<
						"\n";
					std::cout << "f1f2: " << f1(1) << ' ' << f1(2) << ' ' << f1(3) <<
						' ' << f2(1) << ' ' << f2(2) << ' ' << f2(3) << "\n";
 				}

				// sum F1,F2 over all atom pairs
				//
				if ( dE_dR == 0.0 ) goto L100;
				for ( int k = 1; k <= 3; ++k ) {
					F1_atompairE(k,torsion,seqpos) += dE_dR*f1(k);
					F2_atompairE(k,torsion,seqpos) += dE_dR*f2(k);
				}
L100:; // skip pair

			}               // jj list
		}                  // ii list (tor_atom loop)

		// link F1,F2 to all immediately preceding torsions
		//
		jmp_link_torsion_vectors( pose.fold_tree(), seqpos, torsion,
															F1_atompairE, F2_atompairE, jmp_dir);


	}                     // torsion list
}

/////////////////////////////////////////////////////////////////////////////
void
eval_gb_deriv(
	int const atom1,
	int const seqpos1,
	pose_ns::Pose const & pose,
	FArray2D_bool const & neighborlist,
	float const weight,
	FArray1Da_float F1,
	FArray1Da_float F2
)
{
	using aaproperties_pack::natoms;
	F1.dimension(3);
	F2.dimension(3);

	FArray1D_int const & domain_map( pose.get_domain_map() );
	int const map1( domain_map( seqpos1 ) );
	FArray3D_float const & xyz( pose.full_coord() );

	//float const & xyz_1( xyz(1,atom1,seqpos1) );

	int const aa1 ( pose.res        (seqpos1) );
	int const aav1( pose.res_variant(seqpos1) );
	int const nres( pose.total_residue_for_scoring() );


	FArray1D_float f1(3), f2(3);

	for ( int seqpos2=1; seqpos2<= nres; ++seqpos2 ) {
		if ( domain_map( seqpos2 ) == map1 && map1 != 0 ) continue;
		if ( !neighborlist(seqpos1,seqpos2) ) continue;
		int const aa2 ( pose.res        (seqpos2) );
		int const aav2( pose.res_variant(seqpos2) );

		for ( int atom2=1; atom2<= natoms( aa2, aav2 ); ++atom2 ) {
			float const dE_dR_over_r
				( gb_simple_elec_eval_dE_dR_over_r(
						seqpos1, atom1, aa1, aav1, xyz(1,atom1,seqpos1),/*xyz_1,*/
						seqpos2, atom2, aa2, aav2, xyz(1,atom2,seqpos2),
						true /* fill f1 and f2 */, f1, f2 ) );
			for ( int k=1; k<= 3; ++k ) {
				F1(k) += dE_dR_over_r * weight * f1(k);
				F2(k) += dE_dR_over_r * weight * f2(k);
			}
		}
	}

}



/////////////////////////////////////////////////////////////////////////////
bool
jmp_get_dock_warshel_elec_deriv(
												//	int const first_res,
												//	int const last_res,
	const pose_ns::Pose & pose,
	FArray3DB_float & F1_dock_elecE,
	FArray3DB_float & F2_dock_elecE,
	bool const fullatom
)
{
	using namespace aaproperties_pack;
	using namespace cenlist_ns;
	using namespace docking;
	using namespace interface;
	using namespace jmp_maps;
	//using namespace jumping;
	using namespace minimize_ns;
	using namespace misc;
	using namespace nblist;
	using namespace param;
	using namespace param_pack;
	using namespace param_torsion;
	//using namespace scorefxns; // PB-- make explicit with ::

	if ( ! fullatom ) return false; // need in fullatom mode to calculate
	if ( ! scorefxns::dock_scorefxn ) return false; // need in dock mode
	if ( scorefxns::docking_warshel_elec_weight == 0.0 ) return false; //weight

	static int const full_coord_size1 = full_coord.size1();

//------------------------------------------------------------------------------
	// car  initialize  joint atom-pair derivatives
	//
	for ( int seqpos = 1; seqpos <= total_residue; ++seqpos ) {
		for ( int torsion = 1; torsion <= jmp_total_torsion; ++torsion ) {
			for ( int k = 1; k <= 3; ++k ) {
				F1_dock_elecE(k,torsion,seqpos) = 0.0;
				F2_dock_elecE(k,torsion,seqpos) = 0.0;
			}
		}
	}

	for ( int jmp_tor = 1; jmp_tor <= jmp_torsion_map_length; ++jmp_tor ) {

		int const seqpos  = jmp_torsion_map(1,jmp_tor);
		int const torsion = jmp_torsion_map(2,jmp_tor);
		int const jmp_dir = jmp_torsion_map(3,jmp_tor);

		// NOTE: if torsion is a jump torsion, seqpos is the jump_number

		const int n_tor_atom = jmp_atomlist_length(torsion,seqpos);

		for ( int tor_atom = 1; tor_atom <= n_tor_atom; ++tor_atom ) {
			const int ii = jmp_atomlist(tor_atom, torsion, seqpos);
			const int ires = global_atm_num2res_num_map(ii);

			if( ! int_res8(ires) ) continue;  // skip atom ii

			const int iaa = res(ires);
			const int iaav = res_variant(ires);
			const int iatom = global_atm_num2res_atm_num_map(ii);
			const float iacharge = atomic_charge(iatom,iaa,iaav);
			FArray1D_float iacoord( 3 );
			int l = full_coord.index(1,iatom,ires);
			iacoord(1) = full_coord[   l ];
			iacoord(2) = full_coord[ ++l ];
			iacoord(3) = full_coord[ ++l ];

			int jpartner = 0;
			if( ires >= part_begin(1) && ires <= part_end(1) ) {
				jpartner = 2;
			} else if( ires >= part_begin(2) && ires <= part_end(2)) {
				jpartner = 1;
			} else {
				std::cout << "ERROR--jmp_get_dock_warshel_elec_deriv: "
									<< "ires out of range" << "\n";
				std::cout << "ires: " << ires << " part 1 begin/end: " << part_begin(1)
									<< "/" << part_end(1) << " part 2 begin/end: "
									<< part_begin(2) << "/" << part_end(2) << "\n";
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			}


			for ( int j = 1; j <= int(int_res_list8(jpartner).size()); ++j) {
				const int jres = int_res_list8(jpartner)[j];
				if ( cendist(ires,jres) >= cen_dist_cutoff2 ) continue; // skip jres
				const int jaa = res(jres);
				const int jaav = res_variant(jres);
				const int ljs = atomic_charge.index(1,jaa,jaav);
				const int lfjs = full_coord.index(1,1,jres);
				const int jatome = natoms(jaa,jaav);

				for ( int jatom = 1, lj = ljs, lfj = lfjs; jatom <= jatome;
							++jatom, ++lj, lfj+=full_coord_size1 ) {

					const float jacharge = atomic_charge[ lj ];
					FArray1D_float jacoord( 3 );
					jacoord(1) = full_coord[ lfj ];
					jacoord(2) = full_coord[ lfj+1 ];
					jacoord(3) = full_coord[ lfj+2 ];

					const float d2 = vec_dist2(iacoord,jacoord); // [lfj]==(1,jatom,jres)

					float dE_dR;
					FArray1D_float f1( 3 );
					FArray1D_float f2( 3 );
					eval_dock_elec_dE_dR(iacharge, jacharge, d2, iacoord, jacoord, dE_dR,
															 f1, f2);

					if ( dE_dR == 0.0 ) continue; // skip ii-jj atom pair

					// sum F1,F2 over all atom pairs
					for ( int k = 1; k <= 3; ++k ) {
						F1_dock_elecE(k,torsion,seqpos) += dE_dR*f1(k);
						F2_dock_elecE(k,torsion,seqpos) += dE_dR*f2(k);
					}
				} // jres atom list loop

			} // jpartner interface res list loop

		} // ii atom list loop (tor_atom_list)

		// link F1,F2 to all immediately preceding torsions
		//
		jmp_link_torsion_vectors(pose.fold_tree(),seqpos,torsion,F1_dock_elecE,F2_dock_elecE,jmp_dir);

	}                     // torsion list
	return true;
}
//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_unpack_phipsi
///
/// @brief
///
/// @detailed
///
/// @param  phipsi - [in/out]? -
/// @param  first - [in/out]? -
/// @param  last - [in/out]? -
/// @param  gfrag - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_unpack_phipsi(
	pose_ns::Pose & pose,
	FArray1DB_float const & phipsi,
	bool & gfrag
)
{
	using namespace minimize_ns;
	using namespace param;
	using namespace param_torsion;

	set_currently_minimizing( true );

	int const total_residue( pose.total_residue() );

	// handle symmetry if necessary
// 	static FArray1D_float phipsi_local;
//  	if ( pose.symm() ) {
// 		// symmetrize phipsi
// 		int const size( phipsi_in.size() );
// 		if ( int(phipsi_local.size1()) != size ) {
// 			phipsi_local.dimension( size );
// 		}
// 		phipsi_local = phipsi_in;
//  		symmetrize_phipsi( pose, phipsi_local );
//  	}

// 	FArray1DB_float const & phipsi(
// 		static_cast< FArray1DB_float const & >( phipsi_in ) );

	gfrag = true;

	for ( int i = 1; i <= map_length; ++i ) {
		int const torsion ( angle_type(i) );
		int const seqpos  ( angle_map(i) );
		int const dir     ( angle_direction(i) );

		if ( phipsi(i) != phipsi(i) ) { // NaN detected (works for IEEE floating point)
			gfrag = false;
			std::cout << "POSE MINIMIZER ERROR" << "\n";
			std::cout << "angle_type: " << angle_type(i) << "\n";
			std::cout << "residue:    " << angle_map(i) << "\n";
			std::cout << "value:      " << phipsi(i) << "\n";
			assert(false);
			return;
		}

		float value ( phipsi(i) );
		bool move_allowed ( true );

		// debug
		if ( ( seqpos < 1 || seqpos > total_residue ) ||
		 ( dir != jmp_directions::n2c && dir != jmp_directions::c2n && dir != jmp_directions::dir_chi ) ||
		 ( torsion < 1 || torsion > jmp_total_torsion ) ) {
			std::cout << "bad values in angle_map: " << total_residue <<
				SS(i) << SS(torsion) << SS(seqpos) << SS(dir) << "\n";
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		// can someone who understands, comment this:
		if ( mod(static_cast< int >(value),1) != 0 ) {
			gfrag = false;
			std::cout << "MINIMIZER ERROR" << "\n";
			std::cout << "angle_type: " << SS( angle_type(i) ) << "\n";
			std::cout << "residue:    " << SS( angle_map(i) ) << "\n";
			std::cout << "value:      " << SS( value ) << "\n";
			return;
		}

		if ( torsion_type_is_angle(torsion) && std::abs( value ) > 360.0 )
			angle_in_range(value);

// Put the degree of freedom into the correct slot
		if ( torsion == phi_torsion ) { // phi
			move_allowed = pose.set_phi(seqpos, value);
		} else if ( torsion == psi_torsion ) { // psi
			move_allowed = pose.set_psi(seqpos, value);
			//psi(seqpos) = value;
		} else if ( torsion == omega_torsion ) { // omega
			move_allowed = pose.set_omega(seqpos, value);
			//omega(seqpos) = value;
		} else if ( torsion_type_is_chi( torsion) ) { // chi
			int const chino ( torsion-total_bb_torsion );
			// modify the chi to lie in same range as get_chi_and_rot_from_coords:
			//chu we do not flip symmetric sidechains any more. 2006-10-27
			move_allowed = pose.set_chi( chino, seqpos, periodic_range(value,360.0));
			//update_chi(chino,seqpos) = true;
			//new_chi(chino,seqpos) = periodic_range((value),360.);
		} else if ( torsion_type_is_rb(torsion) ) { // rigid-body
			int const rb_no ( torsion - first_rb_torsion + 1 );
			int const jump_number ( seqpos );
			int const reverse_dir ( -1*dir );
			// why do we reverse the direction??
			// it's because in minimization, linking torsion vectors, traversing
			// the map, we move down the fold_tree backward to the root vertex
			// so the direction is reversed from the "folding" direction
			// which is the standard used in the Jump class
			//
			if ( torsion_type_is_rb_translation( torsion ) ) {
				// re-scale the rb-translations so that comparable(?) steps are
				// taken in angle space as in Angstrom space, since the minimize
				// cant tell the difference
				value /= minimize_ns::rb_translation_scale_factor;
			}
			move_allowed = pose.set_jump_rb_delta( jump_number, rb_no, reverse_dir, value);
			//jump_rigid_body_delta(rb_no, seqpos) = value;
		} else {
			std::cout << "unknown angle type in unpack_phipsi:" <<
			 SS( i ) << SS( torsion ) << SS( angle_map(i) ) << "\n";
			jumping_abort();
		}

		if ( ! move_allowed ) {
			std::cout << "WARNING:: jmp_unpack_phipsi: minimize move not allowed by pose\n";
			std::cout << SS(seqpos) << SS(torsion) << "\n";
		}
	} // loop over map
}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_get_total_pair_deriv
///
/// @brief
///
/// @detailed
///    Gets the F1 and F2 pair energy derivative vectors from the
///  Braun and Go recursive torsion derivative scheme for every
///  torsion angle on the protein backbone [in the range first_res-last_res]
///    These results can be
///  subsequently combined with any subset of torsion angles in imap
///  to get any set of dpairE_dtorsion.
///
///  ...lots of this is copied from code by DB and Bill Wedemeyer
///tsa
///
/// @param first_res - [in/out]? -
/// @param last_res - [in/out]? -
/// @param F1_pair - [in/out]? -
/// @param F2_pair - [in/out]? -
//
//
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_get_total_pair_deriv(
												 //	int const first_res,
												 //	int const last_res,
	pose_ns::Pose const & pose,
	FArray3DB_float & F1_pair,
	FArray3DB_float & F2_pair
)
{
	using namespace jmp_directions;
	using namespace jmp_maps;
	using namespace minimize_ns;
	//using namespace misc;
	using namespace param;
	using namespace param_aa;
	using namespace param_torsion;

	//F1_pair.dimension( 3, jmp_total_torsion, MAX_RES() );
	//F2_pair.dimension( 3, jmp_total_torsion, MAX_RES() );

// locals
	FArray2D_float actcoord( 3, MAX_RES()() );
	//FArray1D_int const & neighbors( template_pack::neighbors );
	FArray2D_bool const & neighborlist( template_pack::neighborlist );
// 	FArray1D_int neighbors( MAX_RES()() );
// 	FArray2D_bool neighborlist( MAX_RES()(), MAX_RES()() );
//	FArray1D_int nbin( MAX_RES()() );

	// highest no. torsion angle that controls wcentroid
	FArray1D_int wcentroid_torsion( MAX_AA()() );


//------------------------------------------------------------------------------

	// ctsa  get residue-residue neighborlist and density bins
	//
	//make_neighbor_info(misc::res,misc::total_residue,misc::full_coord,neighborlist,neighbors);
//	assign_nbin(total_residue,neighbors,nbin);

	// ctsa    ...and determine chemical centers
	//
	for ( int seqpos1 = 1; seqpos1 <= misc::total_residue; ++seqpos1 ) {
		int const aa1 = misc::res(seqpos1);
		put_wcentroid(misc::full_coord(1,1,seqpos1),actcoord(1,seqpos1),aa1);
	}
//$$$	for ( int seqpos1 = 1; seqpos1 <= total_residue; ++seqpos1 ) { // OLD CODE
//$$$		aa1 = res(seqpos1);
//$$$		if (aa1 == aa_gly ) {
//$$$			for ( int j = 1; j <= 3; ++j ) {
//$$$				actcoord(j,seqpos1) = full_coord(j,2,seqpos1); // c-alpha
//$$$			}
//$$$		} else {
//$$$			put_wcentroid(full_coord(1,5,seqpos1),actcoord(1,seqpos1),aa1);
//$$$		}
//$$$	}

	// ctsa- get highest numbered torsion angles that control wcentroid for each aa
	//
	// pb- does this work for glycine??

	for ( int aa1 = 1, aae = MAX_AA(); aa1 <= aae; ++aa1 ) {
		get_wcentroid_closest_chi(wcentroid_torsion(aa1),aa1);
		if ( wcentroid_torsion(aa1) != 0 ) {
			if ( ! chi_in_map ) {
				wcentroid_torsion(aa1) = 0; // essentially means: C-beta
			} else {
				wcentroid_torsion(aa1) += total_bb_torsion;
				wcentroid_torsion(aa1) = std::min( wcentroid_torsion(aa1),
				 total_bb_torsion + total_chi_torsion );
			}
		}
	}

	// init F1,F2
	//
	for ( int seqpos1 = 1; seqpos1 <= misc::total_residue; ++seqpos1 ) {
		for ( int torsion = 1; torsion <= jmp_total_torsion; ++torsion ) {
			for ( int j = 1; j <= 3; ++j ) {
				F1_pair(j,torsion,seqpos1) = 0.0;
				F2_pair(j,torsion,seqpos1) = 0.0;
			}
		}
	}

// I dont think this logic works for glycine.
	for ( int jmp_tor = 1; jmp_tor <= jmp_torsion_map_length; ++jmp_tor ) {
		int const seqpos1 = jmp_torsion_map(1,jmp_tor);
		int const torsion = jmp_torsion_map(2,jmp_tor);
		int const dir =     jmp_torsion_map(3,jmp_tor); // n2c...
		int const aa1 = misc::res(seqpos1);

		if ( pose.pseudo( seqpos1 ) ) goto L313;

		if ( wcentroid_torsion(aa1) == 0 ) { // moved by bb/rb torsion
			if ( torsion_type_is_rb(torsion) ) {
				if ( torsion != last_rb_torsion ) goto L313;
			} else if ( torsion_type_is_bb(torsion) ) {
				if ( ( dir == n2c && torsion != psi_torsion ) ||
				 ( dir == c2n && torsion != phi_torsion ) ) goto L313; // just link
			} else {
				goto L313; // chi-torsion
			}
		} else if ( torsion != wcentroid_torsion(aa1) ) {
			goto L313; // it is moved by a chi angle, not this torsion
		}

		for ( int seqpos2 = 1; seqpos2 <= misc::total_residue; ++seqpos2 ) {
			if ( seqpos1 != seqpos2 && !pose.pseudo( seqpos2 ) ) {
				if ( neighborlist(seqpos1,seqpos2) ) {
					int const aa2 = misc::res(seqpos2);
					calc_and_sum_pair_deriv(aa1,aa2,seqpos1,seqpos2,
					 actcoord(1,seqpos1), actcoord(1,seqpos2),
					 F1_pair(1,torsion,seqpos1), F2_pair(1,torsion,seqpos1));
//$$$					calc_and_sum_pair_deriv(aa1,aa2,actcoord(1,seqpos1),
//$$$					 actcoord(1,seqpos2),nbin(seqpos1),nbin(seqpos2),
//$$$					 F1_pair(1,torsion,seqpos1),F2_pair(1,torsion,seqpos1));
				}
			}
		}

L313:

		jmp_link_torsion_vectors( pose.fold_tree(), seqpos1,torsion,F1_pair,F2_pair,dir);

	} // jmp_tor = 1, jmp_torsion_map_length

}

//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_link_torsion_vectors
///
/// @brief
/// ctsa - for any f1,f2, find the one (or two) c/chi-terminal F1,F2
///   vectors and sum them in to solve for this torsions F1,F2
///
/// @detailed
///   This function assumes that, when called, Fx(x,torsion,seqpos)
///   actually contains the value of fx for the indicated torsion
///   angle. This value is replaced with the value for Fx via the sum:
///   Fx(current_torsion) = fx(current_torsion +
///      sum_over_upstream_torsion_angles( Fx(upstream_torsion_angle) )
///
///   Note that in the process the value of fx stored in
///   Fx(x,torsion,seqpos). is destroyed
///
/// direction is n2c,c2n,dir_chi
///
/// @param  seqpos - [in/out]? -
/// @param  torsion - [in/out]? -
/// @param  F1 - [in/out]? -
/// @param  F2 - [in/out]? -
/// @param  misc - [in/out]? -
/// @param  direction - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
// NOTE: if torsion is rb type, then seqpos is the jump_number
void
jmp_link_torsion_vectors(
	pose_ns::Fold_tree const & fold_tree,
	int const seqpos,
	int const torsion,
	FArray3Da_float F1,
	FArray3Da_float F2,
	int const direction
)
{
	using namespace jmp_directions;
	//using namespace jumping;       // for jump_partner, synced in dfunc_vdw
	//using namespace misc;
	using namespace param;
	using namespace param_torsion;

	F1.dimension( 3, jmp_total_torsion, misc::total_residue );
	F2.dimension( 3, jmp_total_torsion, misc::total_residue );

	//  local
	int next_seqpos = -1;
	int next_torsion = -1;
	//int partner;
	bool moves_sidechain ( false );
	// assume that the sc-moved is the same as seqpos, may be changed below:
	// only relevant if moves_sidechain == true
	int sc_pos ( seqpos );

	// retrieve some jumping stuff: is this going to be TOO SLOW ??
	FArray1D_bool const & is_cutpoint ( fold_tree.get_is_cutpoint() );


// sanity checks
	if ( total_chi_torsion <= 0 ) {
		std::cout << "total_chi_torsion <= 0" << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	} else if ( direction != c2n && direction != n2c && direction != dir_chi ) {
		std::cout << "funny direction:" << SS( direction ) << SS( torsion ) << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
//------------------------------------------------------------------------------

	if ( torsion == phi_torsion ) {
		if ( direction == n2c ) { // doesnt move the sidechain
			next_seqpos = seqpos-1;
			next_torsion = omega_torsion;
			if ( is_cutpoint(seqpos-1) ) return;
		} else if ( direction == c2n ) {  // classical case
			next_seqpos = seqpos;
			next_torsion = psi_torsion;
			moves_sidechain = true;
		}

	} else if ( torsion == psi_torsion ) {
		if ( direction == c2n ) { // doesnt move the sidechain,classical case
			next_seqpos = seqpos;
			next_torsion = omega_torsion;
		} else if ( direction == n2c ) {
			moves_sidechain = true;
			next_seqpos = seqpos;
			next_torsion = phi_torsion;
		}

	} else if ( torsion == omega_torsion ) {
		if ( direction == c2n ) { // classical case
			next_seqpos = seqpos + 1;
			next_torsion = phi_torsion;
			if ( is_cutpoint(seqpos) ) return;
		} else if ( direction == n2c ) {
			next_seqpos = seqpos;
			next_torsion = psi_torsion;
		}

	} else if ( torsion_type_is_chi(torsion) ) {
		next_seqpos = seqpos;
		next_torsion = torsion + 1;
		if ( next_torsion == first_rb_torsion ) return;

	} else if ( torsion_type_is_rb(torsion) ) {
		// direction is the direction we are moving across the jump
		// direction is by definition from upstream to downstream
		FArray2D_int const & jump_point ( fold_tree.get_jump_point() );
		int const jump_number ( seqpos );
		if ( torsion == last_rb_torsion ) {
			int const upstream_pos
				( direction == n2c ? jump_point(1,jump_number) : jump_point(2,jump_number));
			moves_sidechain = true;
			sc_pos = upstream_pos;
			for ( int j = 1; j <= 3; ++j ) { // handle the psi_torsion down below
				F1(j,torsion,seqpos) += F1(j,phi_torsion,upstream_pos);
				F2(j,torsion,seqpos) += F2(j,phi_torsion,upstream_pos);
			}
			next_seqpos = upstream_pos;
			next_torsion = psi_torsion; // handled outside this if-statement
		} else {
			next_seqpos = seqpos; // same jump, next rb_torsion
			next_torsion = torsion+1;
		}
	} else {                      // debug
		std::cout << "ABORT: bad torsion in link_torsion_vectors" << "\n";
		std::cout << "torsion: " << SS( torsion ) << "\n";
		jumping_abort();
	}

	if ( moves_sidechain ) {
		for ( int j = 1; j <= 3; ++j ) { // these may very well all be 0
			F1(j,torsion,seqpos) += F1(j,chi1_torsion,sc_pos);
			F2(j,torsion,seqpos) += F2(j,chi1_torsion,sc_pos);
		}

		// if we move the sidechain of residue sc_pos, we also
		// move any jumps that take off from sc_pos
		// have to link these torsions:
		if ( fold_tree.get_is_jump_point()( sc_pos ) ) {
			for ( Fold_tree::const_iterator it = fold_tree.begin(), it_end = fold_tree.end();
			 it != it_end; ++it ) {
				if ( it->is_jump() && it->start == sc_pos ) {
					int const jump_number ( it->label );
					for ( int j = 1; j <= 3; ++j ) { // link to first rb torsion
						F1(j,torsion,seqpos) += F1(j,first_rb_torsion,jump_number);
						F2(j,torsion,seqpos) += F2(j,first_rb_torsion,jump_number);
					}
				}
			}
		}
	}
	if ( next_seqpos < 0 ) {
		std::cout << "problemo in jmp_link_torsion_vectors" << "\n";
		jumping_abort();
	}

	for ( int j = 1; j <= 3; ++j ) { // link to next torsion
		F1(j,torsion,seqpos) += F1(j,next_torsion,next_seqpos);
		F2(j,torsion,seqpos) += F2(j,next_torsion,next_seqpos);
	}

}

//////////////////////////////////////////////////////////////////////////////
/// @begin make_rb_unit_vector_end_pos
///
/// @brief
///
/// @detailed
/// if torsion is a translation vector, returns the unit vector
///      along the corresponding axis
///
/// if torsion is a rotation, returns the unit vector about which
///      rotation is occurring, with the same handedness convention (I hope!)
///      as bb torsion angles
///
///
/// @param  jump_begin - [in/out]? -
/// @param  jump_end - [in/out]? -
/// @param  torsion - [in/out]? -
/// @param  unit - [in/out]? -
/// @param  end_pos - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
//
// This part is a little tricky -- I just spent two freakin days debugging it
//
// actually, the big bug was in setting up the torsion maps, I even had a
// debugging subroutine to check for the problem but it wasnt running!
// now triggered by assert( ... ) statement
//
// the hard part is getting the axes of rotation:
// in making a jump, the transform we apply is
// T0 = ( M^t Rz Ry Rx R M ) where M is the coord-sys matrix of Epos1
// and Rx Ry Rz are rotations about the three axes built by jmp_?rotation
// by rb(4),rb(5), and rb(6) degrees, respectively
//
// so now suppose we are moving rb(6) by dz
// this means Rz becomes R(z+dz) = Rdz * Rz
//
// the new transform is T = ( M^T Rdz Rz Ry Rx R M )
// what is the eigenvector of this guy? assuming we have already applied
// the current transform T0?
//
// we can write T = M^t Rdz M T0, evector is v with T0 * v = ( M^t e3 )
//
// for a delta in rb(5), just have to pull out more matrices
// M^t Rz Rdy Ry Rx R M = ( M^t Rz Rdy R-z M ) T0 with evector T0 * v= M^t Rz e2
//
// finally, axis of rotation (=e-vector) for delta rb(4) is
// M^t Rz Ry e1
//
// where e1,e2,e3 are the unit basis vectors (1,0,0) (0,1,0) and (0,0,1)

// wtih help from Phil.B, switch this part to use xyzMatrix and xyzVector.
// if you already understand the comments above, skip the comments below.
// --chu 2005.09.30
//
// we have here two coordinate systems: xyz frame and jump frame(M).
// Imagine we make a rotation jump from V1 and result in V2,
// the operation is carried out in jump1 frame, i.e.,
// V2 = Rz * Ry * Rx * R * V1,
// as both V2 and V1 are expressed in jump1 frame
// to rewrite V2 and V1 in xyz frame, M is left multiplied.
// M*V2 = M * Rz * Ry * Rx * R * V1 = M *Rz *Ry *Rx *R *M^T * M*V1,
// which says the rotation operation expressed in xyz frame as
// T0 = M * Rz * Ry * Rx * R * M^T
// if we perturb Z rotation by dz angle,
// the new rotation in xyz frame would become
// T = M * Rdz * Rz * Ry * Rx * R * M^T = M * Rdz * M^T * T0
// we want to find an unit vector in xyz frame around which a single rotation
// corresponds to this additional matrix M * Rdz * M^T.
//
// Fairly obviously, M * Rdz * M^T represents a rotation abound Z-axis in jump1 frame,
// and thus the unit vector we are looking for is the e3 in jumpi frame rewritten in
// xyz frame, which is M * e3 == the third column of M .
//
// Similarly, when Ry is perturbed, we pull out the additinal matrix as
// M * Rz * Rdy * Rz^T * M^T, its corresponding rotation axis is an e2 vector and it
// is expressed in xyz fram as M * Rz * e2 == the second column of matrix M*Rz
// for Rdx, the answer is M * Rz * Ry * e1 == the first column of matrix M*Rz*Ry
//
// note that I reverse M and M^T as compared to Phil's comments above since he was using
// a non-standard matrix convention from CEMS.

void
make_rb_unit_vector_end_pos(
	int const dir,
	Jump const & jump,
	FArray2Da_float Epos1,
	FArray2Da_float Epos2,
	int const torsion,
	FArray1Da_float unit, // output
	FArray1Da_float end_pos // output
)
{
	using namespace param_torsion;
	using namespace pose_ns;
	using namespace numeric;

	// dimension the argument arrays:
	Epos1.dimension(3, param::MAX_POS);
	Epos2.dimension(3, param::MAX_POS);
	unit.dimension( 3 );
	end_pos.dimension( 3 );

	// local: (could be made static arrays)
// 	FArray2D_double p1( 3, 3 );
// 	FArray2D_double p2( 3, 3 );
// 	FArray2D_double m1( 3, 3 );
// 	FArray2D_double m2( 3, 3 );
	xyzMatrix_double p1, p2, m1, m2;
	FArray2D_double Rz( 3, 3 );
	FArray2D_double Rzy( 3, 3 );
	FArray2D_double Ry( 3, 3 );
	FArray2D_double MR( 3, 3 );
	FArray1D_double v( 3 );

	get_ncac(Epos1,p1);
	get_ncac(Epos2,p2);
	get_coordinate_system(p1,m1);
	get_coordinate_system(p2,m2);

	// get rb_delta and rb_center from the jump:
	// have to reverse the direction, because "dir" passed in is the
	// direction from the angle map, in which we are traversing the
	// tree backwards from the folding direction
	int const reverse_dir (-1*dir);
	FArray1Da_double const rb_delta  ( jump.get_rb_delta  ( reverse_dir ) );
	//FArray1Da_double const rb_center ( jump.get_rb_center ( reverse_dir ) );
	xyzVector_double const rb_center ( &jump.get_rb_center(reverse_dir)(1) );
	// constuct the center of rigid-body rotation:
	// end_pos is the rigid_body_center position
	xyzVector_double new_center = p2.col(2) + m2 * rb_center;
	for ( int k=1 ; k <=3; ++k ) end_pos(k) = new_center(k);
// 	for ( int k = 1; k <= 3; ++k ) {
// 		end_pos(k) = p2(k,2) +
// 			rb_center(1) * m2(k,1) +
// 			rb_center(2) * m2(k,2) +
// 			rb_center(3) * m2(k,3);
// 	}

	xyzVector_double tmp_unit;
	if ( torsion >= first_rb_torsion && torsion <= first_rb_torsion + 2 ) {
	 // translation
		int const axis_no = torsion - first_rb_torsion + 1; // 1,2,3
		tmp_unit = m1.col(axis_no);
	// 	for ( int k = 1; k <= 3; ++k ) {
// 			unit(k) = m1(k,axis_no);
// 		}
	} else if ( torsion == first_rb_torsion + 5 ) { // rotation about z-axis
		// = m1^T * e3
		tmp_unit = m1.col(3);
// 		for ( int k = 1; k <= 3; ++k ) {
// 			unit(k) = m1(k,3);
// 		}
	} else if ( torsion == first_rb_torsion + 4 ) { // rotation about y-axis
		double const theta_z = rb_delta(6);
		tmp_unit = ( m1 * Z_rot(theta_z) ).col(2);

		// FArray1D_double e2(3,0.0);
// 		e2(2) = 1.0; // j-hat unit vector
// 		jmp_zrotation(Rz,theta_z);
// 		mat_multiply_transpose3(m1,Rz,MR); // m1^T * Rz
// 		Dvect_multiply(MR,e2,v);
// 		// BUG: old way:
// //  		Dvect_multiply(Rz,m1(1,2),v);
// 		for ( int k = 1; k <= 3; ++k ) {
// 			unit(k) = v(k);
// 		}
	} else if ( torsion == first_rb_torsion + 3 ) { // rotation about x-axis
		double const theta_z = rb_delta(6), theta_y = rb_delta(5);
		tmp_unit = ( m1 * Z_rot(theta_z) * Y_rot(theta_y) ).col(1);

// 		FArray1D_double e1(3,0.0);
// 		e1(1) = 1.0; // i-hat unit vector
// 		double const theta_z = rb_delta(6);
// 		jmp_zrotation(Rz,theta_z);
// 		double const theta_y = rb_delta(5);
// 		jmp_yrotation(Ry,theta_y);
// 		mat_multiply3(Rz,Ry,Rzy);
// 		mat_multiply_transpose3(m1,Rzy,MR); // m1^T * Rzy
// 		Dvect_multiply(MR,e1,v);
// 		// BUG: old way
// //  		Dvect_multiply(Rzy,m1(1,1),v);
// 		for ( int k = 1; k <= 3; ++k ) {
// 			unit(k) = v(k);
// 		}
	} else {                      // debug
		std::cout << "unrecognized torsion in make_rb_unit_vector!" <<
		 SS( torsion ) << "\n";
		jumping_abort();
	}
	for( int i=1; i<=3; ++i) unit(i) = tmp_unit(i);
}

//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_pack_phipsi
///
/// @brief
///
/// @detailed
///
/// @param  phipsi - [in/out]? -
/// @param  nangles - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_pack_phipsi(
	pose_ns::Pose const & pose,
	FArray1DB_float & phipsi,
	int & nangles
)
{
	using namespace aaproperties_pack;
	using namespace jmp_directions;
	using namespace jmp_maps;
	//using namespace jumping;
	using namespace minimize_ns;
	//using namespace misc;
	using namespace param;
	using namespace param_aa;
	using namespace param_torsion;


	// POSE //

//car local
	//FArray2D_int rotarray( MAX_CHI, MAX_RES()() );
	//FArray2D_float chiarray( MAX_CHI, MAX_RES()() );

//pb   this uses the subset of jmp_torsion_map allowed by the exclude list
//pb   rb torsions are attached to their jump_number

//pb   I changed the freakin' order: angle map should be traversed 1...length
//pb   rather than the other way around.


	if ( ! minimize_exclude_list_init ) minimize_reset_exclude_list();

	bool fullatom = false;
	if ( minimize_vary_chi ) fullatom = pose.fullatom();

	if ( minimize_vary_chi && fullatom ) {
		// make sure that the pose chi angles agree with pose.full_coord
		// this should be guaranteed by pose.repack and rotamer_trials
		//assert( pose.debug_torsions() );
	}

	map_length = 0;

	//minimize_reset_moving();

	if ( false ) debug_minimize_allow_torsion(); // looks at misc::secstruct

	if ( runlevel_ns::runlevel > runlevel_ns::standard ) {
		std::cout << "jmp_torsion_map_length: " << jmp_torsion_map_length <<
			"\n";
	}

	for ( int tor = 1; tor <= jmp_torsion_map_length; ++tor ) {

		int const i       = jmp_torsion_map(1,tor);
		int const torsion = jmp_torsion_map(2,tor);
		int const dir     = jmp_torsion_map(3,tor);

		// note: for rb torsions, i is the jump_number, not a residue number
		// so aa,aav below don't make sense. But at least there are always
		// more residues than jumps, so we shouldn't be over-running the arrays

		// PB (11/28/05) I didn't used to exclude phi of 1 or psi of nres
		// since they do move atoms, but this causes problems with the
		// rama score so am reverting to standard rosetta practice
		if ( i == 1 && torsion == phi_torsion ) continue;
		if ( i == misc::total_residue && torsion == psi_torsion ) continue;
		if ( i == misc::total_residue && torsion == omega_torsion ) continue;

		if ( minimize_allow_torsion(torsion,i) ) {

			int const aa  = misc::res(i);
			int const aav = misc::res_variant(i);

			++map_length;
			if ( false ) {
				std::cout << "jmp_pack_phipsi:: in map: " << map_length << ' ' <<
					tor << ' ' << i << ' ' << torsion << ' ' << dir << "\n";
			}
			if ( map_length > MAX_RES()() * total_torsion ) {
				std::cout << "Increase total_torsion in param_torsion.cc" << "\n";
				std::cout << "Likely max_rb_torsion" << "\n";
			}
			angle_map(map_length)       = i;
			angle_type(map_length)      = torsion;
			angle_direction(map_length) = dir;

			if ( false ) std::cout << "add to angle_map:" <<
			 SS( i ) << SS( torsion ) << SS( dir ) << "\n";

// Now access the correct torsion data and put into phipsi(map_length) -------
			if ( torsion == phi_torsion ) { // phi
				phipsi(map_length) = misc::phi(i);
				//set_bb_moving(i);
			} else if ( torsion == psi_torsion ) { // psi
				phipsi(map_length) = misc::psi(i);
				//set_bb_moving(i);
			} else if ( torsion == omega_torsion ) { // omega
				phipsi(map_length) = misc::omega(i);
				//set_bb_moving(i);
			} else if ( torsion_type_is_chi(torsion) ) { // chi
				//set_sc_moving(i);
				int const chino = torsion - total_bb_torsion;
				if ( chino > nchi(aa,aav) ) { // debug
					std::cout << "chi too high!" << SS( chino ) << SS( nchi(aa,aav) ) <<
					 SS( aa ) << SS( aav ) << "\n";
					jumping_abort();
				}
				phipsi(map_length) = pose.chi(chino,i);
			} else if ( torsion_type_is_rb(torsion) ) { // rigid body
				int const rb_no = torsion - first_rb_torsion + 1;
				assert( i <= pose.fold_tree().get_num_jump() );
				// see the comment in jmp_unpack_phipsi about reversing
				// the direction
				int const reverse_dir ( dir == n2c ? c2n : n2c );
				float value( pose.get_jump_rb_delta(i,rb_no,reverse_dir) );
				if ( torsion_type_is_rb_translation( torsion ) ) {
					// re-scale the rb-translations so that comparable(?) steps are
					// taken in angle space as in Angstrom space, since the minimize
					// cant tell the difference
					value *= minimize_ns::rb_translation_scale_factor;
				}
				phipsi(map_length) = value;
			} else {                   // debug
				std::cout << "unrecog torsion!!" << SS( torsion ) << "\n";
				jumping_abort();
			}
		}
	}
	nangles = map_length;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin
///
/// @brief
/// sets jmp_torsion_map(3,maplength)
/// and  jmp_atomlist(atoms,torsion,seqpos)
/// using the fold_tree
///
/// @detailed
/// currently, the fold_tree is reordered to fold beginning with 1.
///
/// some assumptions:
///
/// 1. every residue occurs in at least one peptide segment (ie elabel < 0)
///    if it occurs in
///
/// 2. peptide segments are at least 2 residues long (so direction can be defined)
///
///    it may occur in multiple jumps, but it will be the upstream
///    member of at most 1 (checked by update_jump_partner: each residue has at
///    most one downstream partner).
///
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_setup_torsion_maps(
	pose_ns::Fold_tree const & fold_tree,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	const bool fullatom
)
{
	using namespace jmp_directions;
	//using namespace jumping;
	using namespace minimize_ns;      // minimize_vary_XXX
	using namespace param_torsion;

	//bool const fullatom ( get_fullatom_flag() );

	bool chi_in_map = false;
	if ( fullatom && minimize_vary_chi ) chi_in_map = true;
	set_chi_in_map(chi_in_map);


// this arranges the tree so that we could fold starting at 1 and
// traverse the edges in order, always starting with something already folded.

	int const start_vertex ( fold_tree.begin()->start );

	if ( jumping::jverbose ) {
		std::cout << "jmp_setup_torsion_maps" << "\n";
		std::cout << fold_tree;
	}


	// just sets lengths of lists to 0 also preps for some debugging
	reset_torsion_maps_and_lists();

	for ( Fold_tree::const_iterator it = fold_tree.end(),
					it_end = fold_tree.begin();  it != it_end; ) {
		// reverse the order of traversing the edges
		--it;
		int const estart( it->start);
		int const estop ( it->stop );
		if ( jumping::jverbose ) std::cout << "setup maps: edge:" << *it << "\n"; // debug
		if ( it->is_jump() ) { // edge is a jump
			int const jump_number( it->label );
			jmp_add_chi_torsions( fold_tree, res, res_variant, estop, fullatom);
			jmp_add_torsion( fold_tree, res, res_variant, estop,phi_torsion,n2c,fullatom);
			jmp_add_torsion( fold_tree, res, res_variant, estop,omega_torsion,c2n,fullatom);
			jmp_add_torsion( fold_tree, res, res_variant, estop,psi_torsion,c2n,fullatom);
			// note that this direction is the opposite of the folding
			// direction: we traverse the fold_tree in reverse during
			// minimization, linking torsion vectors
			int const dir ( ( it->start < it->stop ) ? c2n : n2c );
			for ( int torsion = last_rb_torsion; torsion >= first_rb_torsion;
			 --torsion ) {
				jmp_add_torsion( fold_tree, res, res_variant, jump_number,torsion,dir,fullatom);
			}
		} else {                   // edge is a peptide segment
			if ( estart < estop ) {
				int const direction (c2n); // c2n because we traverse the torsion map
				// in the opposite direction from folding
				// ie from estop to estart
				for ( int seqpos = estop, seqpose = estart+1; seqpos >= seqpose; --seqpos ) {
					jmp_add_torsion( fold_tree, res, res_variant,  seqpos, omega_torsion, direction, fullatom);
					jmp_add_torsion( fold_tree, res, res_variant,  seqpos, psi_torsion, direction, fullatom);
					jmp_add_chi_torsions( fold_tree, res, res_variant,  seqpos, fullatom);
					jmp_add_torsion( fold_tree, res, res_variant,  seqpos, phi_torsion, direction, fullatom);
				}
			} else if ( estart > estop ) { // n2c
				int const direction (n2c);
				for ( int seqpos = estop, seqpose = estart-1; seqpos <= seqpose; ++seqpos ) {
					jmp_add_torsion( fold_tree, res, res_variant,  seqpos, phi_torsion, direction, fullatom);
					jmp_add_chi_torsions( fold_tree, res, res_variant,  seqpos, fullatom);
					jmp_add_torsion( fold_tree, res, res_variant,  seqpos, psi_torsion, direction, fullatom);
					jmp_add_torsion( fold_tree, res, res_variant,  seqpos, omega_torsion, direction, fullatom);
				} // seqpos
			}    // direction?
		}       // jump or segment?
	}          // edge_num = num_edges(fold_tree), 1, -1
	//if ( estart != start_vertex ) { // debug
	//	std::cout << "start_vertex problem!" << "\n";
	//	utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	//}

// tree is rooted at C-alpha of start_vertex:
	jmp_add_torsion( fold_tree, res, res_variant, start_vertex,omega_torsion,c2n, fullatom);
	jmp_add_torsion( fold_tree, res, res_variant, start_vertex,psi_torsion,c2n, fullatom);
	jmp_add_chi_torsions( fold_tree, res, res_variant, start_vertex, fullatom);
	jmp_add_torsion( fold_tree, res, res_variant, start_vertex,phi_torsion,n2c, fullatom);

	// debugging
	assert( check_torsion_maps_and_lists( fold_tree.get_nres(),
		fold_tree.get_num_jump(), fullatom,	res, res_variant, start_vertex) );
}

//////////////////////////////////////////////////////////////////////////////
/// @begin set_chi_in_map
///
/// @brief
///
/// @detailed
///
/// @param  setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
set_chi_in_map( bool const setting )
{
	jmp_maps::chi_in_map = setting;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_chi_in_map
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool
get_chi_in_map()
{
	return jmp_maps::chi_in_map;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_add_torsion
///
/// @brief
///
/// @detailed
///
/// @param  seqpos - [in/out]? -
/// @param  torsion - [in/out]? -
/// @param  direction - [in/out]? -
/// @param[in]  fullatom -
///
/// @global_read
///
/// @global_write
///
/// @remarks
/// currently assuming that we are not using constraints
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_add_torsion(
	pose_ns::Fold_tree const & fold_tree,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	int const seqpos,
	int const torsion,
	int const direction,
	bool const fullatom // input
)
{
	using namespace aaproperties_pack;
	using namespace jmp_directions;
	using namespace jmp_maps;
	//using namespace jumping;       // is_cutpoint
	//using namespace misc;
	using namespace param_torsion;

	// interface with the current pose (set by call to minimize() )
	FArray1D_bool const & is_cutpoint( fold_tree.get_is_cutpoint() );

	if ( jumping::jverbose ) std::cout << "jmp_add_torsion" <<
	 SS( seqpos ) << SS( torsion ) << SS( direction ) << "\n";

	if ( torsion_type_is_bb(torsion) && direction != n2c && direction != c2n ) {
		std::cout << "direction problem" << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	++jmp_torsion_map_length;
	jmp_torsion_map(1,jmp_torsion_map_length) = seqpos;
	jmp_torsion_map(2,jmp_torsion_map_length) = torsion;
	jmp_torsion_map(3,jmp_torsion_map_length) = direction;

// for debugging:
	++torsionlist_count(torsion,seqpos);

// now add the relevant atoms to the lists
	int const aa = res(seqpos);
	int const aav = res_variant(seqpos);

	if ( torsion == phi_torsion ) { //-----------------------------------------phi
		if ( direction == n2c ) { // HN(?), CO-1
			if ( fullatom && HNpos(aa,aav) != 0 )
			 jmp_add_atom(seqpos,HNpos(aa,aav),seqpos,torsion); // HN
			if ( ! is_cutpoint(seqpos-1) )
			 jmp_add_atom(seqpos-1,3,seqpos,torsion); // CO-1
		} else {                   // HA(?),CB(ifnotgly),CO,centroid,sc
			jmp_add_atom(seqpos,3,seqpos,torsion); // CO
			jmp_add_sc_atoms(seqpos,aa,aav,seqpos,torsion,fullatom,chi_in_map);
			// handles cb,centroid, sc if nec. depending on fullatom and chi_in_map
		}
	} else if ( torsion == psi_torsion ) { //----------------------------------psi
		if ( direction == n2c ) { // HA(?),CB,N,centroid,sc if nec
			jmp_add_atom(seqpos,1,seqpos,torsion); // N
			jmp_add_sc_atoms(seqpos,aa,aav,seqpos,torsion,fullatom,chi_in_map);
		} else {                   // OC,N+1
			jmp_add_atom(seqpos,4,seqpos,torsion); // OC
			if ( ! is_cutpoint(seqpos) ) jmp_add_atom(seqpos+1,1,seqpos,torsion);
		}
	} else if ( torsion == omega_torsion ) { //------------------------------omega
		if ( direction == n2c ) { // CA,OC
			jmp_add_atom(seqpos,4,seqpos,torsion); // OC
			jmp_add_atom(seqpos,2,seqpos,torsion); // CA
		} else {                   // HN+1,CA+1
			if ( ! is_cutpoint(seqpos) ) {
				if ( fullatom && HNpos( res(seqpos+1),res_variant(seqpos+1) ) != 0 )
				 jmp_add_atom(seqpos+1,HNpos( res(seqpos+1),res_variant(seqpos+1)),
				  seqpos,torsion); // HN+1
				jmp_add_atom(seqpos+1,2,seqpos,torsion); // CA+1
			}
		}
	} else if ( torsion_type_is_chi(torsion) ) { //----------------------------chi
		if ( ! chi_in_map ) {
			std::cout << "whoah not chi_in_map, but chi in map" << "\n";
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		int const chino = torsion - total_bb_torsion;
		for ( int k = 1, ke = nside(aa,aav); k <= ke; ++k ) {
			// PB: I think this is bad for DNA... check current_cvs
			int const atomno = k + 4;
			if ( atomno != HNpos(aa,aav) ) { // not already done
				if ( jmp_maps_closest_chi(chino,atomno,aa,aav) ) {
					jmp_add_atom(seqpos,atomno,seqpos,torsion);
				}
			}
		}
	} else if ( torsion_type_is_rb(torsion) ) { //----------------------rigid body
		// get more fold_tree stuff:
		int const jump_number ( seqpos );
		int const num_jump = fold_tree.get_num_jump();
		FArray2D_int const & jump_point = fold_tree.get_jump_point();
		if ( jump_number > num_jump ) {
			std::cout << "bad seqpos for a jump torsion:" << SS(seqpos) << SS(num_jump) << "\n";
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		int const resno // the upstream residue for this jump
			( ( direction == n2c ) ? jump_point(1,jump_number) : jump_point(2,jump_number) );
		// BUG: we are using direction to represent the direction we traverse this
		// jump during *minimization* not during folding
//  		int const resno // the upstream residue for this jump
//  			( ( direction == n2c ) ? jump_point(2,jump_number) : jump_point(1,jump_number) );
		if ( torsion == last_rb_torsion ) { // N,CB,C,HA(?),centroid,sc if nec
			jmp_add_atom(resno,1,jump_number,torsion);
			jmp_add_atom(resno,3,jump_number,torsion);
			jmp_add_sc_atoms(resno,res(resno),res_variant(resno),jump_number,
											 torsion,fullatom,chi_in_map);
		} else if ( torsion == first_rb_torsion+2 ) { // CA
			jmp_add_atom(resno,2,jump_number,torsion);
		}
	} else {
		std::cout << "unrecognized torsion!!!" << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}                // what kind of torsion

}

//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_add_chi_torsions
///
/// @brief
///
/// @detailed
///
/// @param[in]  seqpos -
/// @param[in]  fullatom -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_add_chi_torsions(
	pose_ns::Fold_tree const & fold_tree,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	int const seqpos, // input
	bool const fullatom // input
)
{
	using namespace aaproperties_pack;
	using namespace jmp_directions; // dir_chi
	//using namespace misc;
	using namespace param_torsion;

	if ( ! get_chi_in_map() ) return;

	int const aa = res(seqpos);
	int const aav = res_variant(seqpos);
	if ( nchi(aa,aav) <= 0 ) return;

	for ( int chino = nchi(aa,aav); chino >= 1; --chino ) {
		jmp_add_torsion( fold_tree, res, res_variant, seqpos,
										 chino+total_bb_torsion,dir_chi,fullatom);
	}
}

//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_add_sc_atoms
///
/// @brief
///
/// @detailed
/// fullatom: adds everything that doesnt depend on chi.
///               if not chi_in_map, adds everything except HN
/// centroid: adds cb(if not gly) and centroid
///
/// stupid: assumes that the seqpos of the torsion is the same as that
/// of the sidechain.
///
/// @param  seqpos  - [in/out]? -
/// @param  torsion - [in/out]? -
/// @param  fullatom - [in/out]? -
/// @param  chi_in_map - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_add_sc_atoms(
	int const seqpos,
	int const aa,
	int const aav,
	int const torsion_pos,
	int const torsion,
	bool const fullatom,
	bool const chi_in_map
)
{
	using namespace aaproperties_pack;
	//using namespace misc;
	using namespace param_aa;

	if ( fullatom ) {
		for ( int k = 1, ke = nside(aa,aav); k <= ke; ++k ) {
			int const atomno = k + 4;
			if ( atomno != HNpos(aa,aav) &&
			 ( ! chi_required(1,atomno,aa,aav) || ! chi_in_map ) )
			 jmp_add_atom(seqpos,atomno,torsion_pos,torsion);
		}
	} else {
		for ( int atomno = 5; atomno <= 6; ++atomno ) {
			if ( aa != aa_gly || atomno != 5 )
			 jmp_add_atom(seqpos,atomno,torsion_pos,torsion);
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
/// @begin reset_torsion_maps_and_lists
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
reset_torsion_maps_and_lists()
{
	using namespace jmp_maps;
	//using namespace jumping;
	//using namespace misc;
	//using namespace param;
	//using namespace param_torsion;

	if ( get_fullatom_flag() ) get_closest_chi(jmp_maps_closest_chi);

// initialize torsion and atom maps and lists
	jmp_torsion_map_length = 0;
	jmp_atomlist_length = 0;

// setup for debugging
// count the number of times each torsion is added to the list
	torsionlist_count = 0;
	atomlist_count = 0;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_add_atom
///
/// @brief
///
/// @detailed
///
/// @param  resno - [in/out]? -
/// @param  atomno - [in/out]? -
/// @param  seqpos - [in/out]? -
/// @param  torsion - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_add_atom(
	int const resno,
	int const atomno,
	int const seqpos,
	int const torsion
)
{
	using namespace jmp_maps;
	//using namespace jumping;
	//using namespace misc;
	using namespace nblist;        // for global atom numbering system

	if ( jumping::jverbose ) std::cout << "jmp_add_atom" << SS( resno ) << SS( atomno ) <<
	 SS( seqpos ) << SS( torsion ) << "\n";

	if ( resno <= 0 || resno > misc::total_residue ) return;

	int const natoms = jmp_atomlist_length(torsion,seqpos) + 1;
	if ( natoms > max_atomlist_length() ) { // debug
		std::cout << "increase max_atomlist_length in jmp_maps.cc" << "\n";
		jumping_abort();
	}

	jmp_atomlist_length(torsion,seqpos) = natoms; // increase length

	int const global_atomno = res_atm_num2global_atm_num_map(atomno,resno);

	jmp_atomlist(natoms,torsion,seqpos) = global_atomno;

// for debugging:
	++atomlist_count(atomno,resno);
}

//////////////////////////////////////////////////////////////////////////////
/// @begin check_torsion_maps_and_lists
///
/// @brief
/// debugging -- have all the necessary atoms/torsions entered the lists??
///
/// @detailed
///
/// @param[in]  start_vertex -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
// returns TRUE if OK, FALSE otherwise, so you can assert() it
bool
check_torsion_maps_and_lists(
	int const total_residue,
	int const num_jump,
	bool const fullatom,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	int const start_vertex
)
{
	using namespace aaproperties_pack;
	using namespace jmp_directions;
	using namespace jmp_maps;
	//using namespace jumping;
	//using namespace misc;
	using namespace param_aa;
	using namespace param_torsion;

	int natom,count;

	bool ok(true);

	if ( jumping::jverbose )
		std::cout << "checking the atom and torsion lists!!" << "\n";

	for ( int i = 1; i <= total_residue; ++i ) {
		int const aa = res(i);
		int const aav = res_variant(i);

// check the atoms:
		if ( fullatom ) {
			natom = 4 + nside(aa,aav);
		} else {
			natom = 6;
		}

		// should add checking for start_vertex atoms but its a little tricky
		//
		if ( i != start_vertex ) {
			for ( int j = 1; j <= natom; ++j ) {
				count = atomlist_count(j,i);
				if ( ( aa != aa_gly && count != 1 ) ||
				 ( aa == aa_gly && fullatom && count != 1 ) ||
				 ( aa == aa_gly && !fullatom && count != 1 && j != 5 ) ||
				 ( aa == aa_gly && !fullatom && count != 0 && j == 5 ) ) {
					std::cout << "WARNING:: bad atomlist_count:" <<
					 SS( i ) << SS( j ) << SS( count ) << "\n";
					ok = false;
				}
			}
		} else {
			for ( int j = 1; j <= natom; ++j ) {
				count = atomlist_count(j,i);
				if ( ( count > 1 ) ||
				 ( aa == aa_gly && !fullatom && count != 0 && j == 5 ) ) {
					std::cout << "WARNING:: bad atomlist_count:" <<
					 SS( i ) << SS( j ) << SS( count ) << "\n";
					ok = false;
				}
			}
		}


// check the torsions:
		for ( int j = 1; j <= jmp_total_torsion; ++j ) {
			count = torsionlist_count(j,i);
			if ( ( torsion_type_is_chi(j) &&
			 ( ! chi_in_map || nchi(aa,aav) < j-total_bb_torsion ) ) ||
			 ( torsion_type_is_rb(j) && i > num_jump ) ) {
			 // the count should be 0
				if ( count != 0 ) {
					std::cout << "WARNING:: bad torsionlist_count:" <<
					 SS( i ) << SS( j ) << SS( count ) << "\n";
					ok = false;
				}
			} else {
				if ( count != 1 ) {
					std::cout << "WARNING:: bad torsionlist_count:" <<
					 SS( i ) << SS( j ) << SS( count ) << "\n";
					ok = false;
				}
			}
		}                  // j=1,jmp_total_torsion
	}                     // i=1,total_residue

	return ok;
}


//////////////////////////////////////////////////////////////////////////////
/// @begin initialize_torsion_logicals
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
initialize_torsion_logicals()
{
	using namespace param_torsion;

	for ( int i = 1; i <= jmp_total_torsion; ++i ) {
		torsion_type_is_angle(i) = true; // see rb-translation below
		if ( i <= total_bb_torsion ) { // bb
			torsion_type_is_bb(i) = true;
		} else {
			torsion_type_is_bb(i) = false;
		}

		if ( i > total_bb_torsion && /* chi */ i < first_rb_torsion ) {
			torsion_type_is_chi(i) = true;
		} else {
			torsion_type_is_chi(i) = false;
		}

		if ( i >= first_rb_torsion && /* rb */ i <= last_rb_torsion ) {
			torsion_type_is_rb(i) = true;
			if ( i < first_rb_torsion+3 ) { // rb-translation
				torsion_type_is_angle(i) = false;
				torsion_type_is_rb_angle(i) = false;
				torsion_type_is_rb_translation(i) = true;
			} else {                // rb-angle
				torsion_type_is_rb_angle(i) = true;
				torsion_type_is_rb_translation(i) = false;
			}
		} else {
			torsion_type_is_rb(i) = false;
			torsion_type_is_rb_angle(i) = false;
			torsion_type_is_rb_translation(i) = false;
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
/// @begin torsion_fixes_overlap
///
/// @brief
///
/// @detailed
///
/// @param  seqpos - [in/out]? -
/// @param  torsion - [in/out]? -
/// @param  dir - [in/out]? -
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool
torsion_fixes_overlap(
	int const seqpos,
	int const torsion,
	int const dir,
	int const total_residue,
	FArray1D_bool const & is_cutpoint
)
{
	using namespace jmp_directions;
	//using namespace jumping;
	//using namespace misc;
	using namespace param_torsion;

	bool torsion_fixes_overlap = false; // Return value

	if ( ( seqpos < total_residue && is_cutpoint(seqpos) &&
				 torsion == omega_torsion && dir == c2n ) ||
			 ( seqpos > 1 && is_cutpoint(seqpos-1) && torsion == phi_torsion &&
				 dir == n2c ) ) torsion_fixes_overlap = true;

	return torsion_fixes_overlap;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin add_chainbreak_overlap_deriv
///
/// @brief
///
/// @detailed
///
/// @param  seqpos - [in/out]? -
/// @param  torsion - [in/out]? -
/// @param  dir - [in/out]? -
/// @param  F1 - [in/out]? -
/// @param  F2 - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
add_chainbreak_overlap_deriv(
	pose_ns::Pose const & pose,
	int const seqpos,
	int const torsion,
	int const dir,
	FArray1Da_float F1,
	FArray1Da_float F2
)
{
	using namespace jmp_directions;
	//using namespace jumping;
	//using namespace misc;
	using namespace param_aa;
	using namespace param_torsion;
	using namespace scorefxns;     // for jmp_chainbreak_weight

	F1.dimension( 3 );
	F2.dimension( 3 );

	FArray1D_float vec( 3 );

	int overlap_begin(0), overlap_end(0), cutpoint(0);

	// POSE //
	Fold_tree const & fold_tree ( pose.fold_tree() );
	FArray4D_float const & jmp_overlap_Eposition
		( pose.get_overlap_Eposition( jumping::jmp_chainbreak_overlap ) );
	FArray1D_bool const & is_cutpoint ( fold_tree.get_is_cutpoint() );
	int num_fold_tree_cutpoint;
	FArray1D_int const & fold_tree_cutpoint
		( fold_tree.get_fold_tree_cutpoint( num_fold_tree_cutpoint ) );


	if ( seqpos < misc::total_residue && is_cutpoint(seqpos) &&
			 torsion == omega_torsion && dir == c2n ) {
		cutpoint = seqpos;
		overlap_begin = 1;
		overlap_end = std::min( jumping::jmp_chainbreak_overlap, misc::total_residue - cutpoint );
	} else if ( seqpos > 1 && is_cutpoint(seqpos-1) && torsion == phi_torsion &&
	 dir == n2c ) {
		cutpoint = seqpos - 1;
		overlap_begin = std::max(1-jumping::jmp_chainbreak_overlap,1-cutpoint);
		overlap_end = 0;
	} else {                      //
		std::cout << "chain break deriv: shouldnt be here!" << "\n";
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	int ncut(0);
	for ( int i=1; i<= num_fold_tree_cutpoint; ++i ) {
		if ( fold_tree_cutpoint(i) == cutpoint) {
			ncut = i;
		}
	}

	if ( ncut <= 0 ) {       // debug
		std::cout << "cutpoint is a cutpoint but the cutpoint_map <= 0" << "\n";
		jumping_abort();
	}

	float const weight_factor = 2.0 * jmp_chainbreak_weight; // derivative of ()**2

	//std::cout << "add_chainbreak_overlap_deriv:: weight= " << jmp_chainbreak_weight <<
	//	" cutpoint= " << cutpoint << " seqpos= " << seqpos << " torsion= " << torsion <<
	//	"\n";


	for ( int i = overlap_begin; i <= overlap_end; ++i ) {
		int const pos = cutpoint + i; // the real position
		for ( int j = 1; j <= 5; ++j ) { // F1 = VxVp
			if ( pose.res(pos) != aa_gly || j != 3 ) { // not GLY c-beta
				cros( jmp_overlap_Eposition(1,j,i,ncut), misc::Eposition(1,j,pos), vec );
				for ( int k = 1; k <= 3; ++k ) {
					F1(k) += weight_factor * vec(k);
					F2(k) += weight_factor * jmp_overlap_Eposition(k,j,i,ncut) -
					 weight_factor * misc::Eposition(k,j,pos);
				}
			}
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
/// @begin fa2cen_initializer
///
/// @brief
///
/// @detailed
///
/// @param  fa2cen - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
fa2cen_initializer( FArray1D_int & fa2cen )
{
	int i = 0;
	fa2cen( ++i ) = 1;
	fa2cen( ++i ) = 2;
	fa2cen( ++i ) = 4;
	fa2cen( ++i ) = 5;
	fa2cen( ++i ) = 3;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin add_chainbreak_derivative
///
/// @brief
///
/// @detailed
///
/// @param  pos - [in/out]? -
/// @param  atom - [in/out]? -
/// @param  F1 - [in/out]? -
/// @param  F2 - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
add_chainbreak_derivative(
	int const pos,
	int const aa,
	int const atom,
	FArray1Da_float F1,
	FArray1Da_float F2,
	int const num_fold_tree_cutpoint,
	FArray1D_int const & fold_tree_cutpoint,
	FArray4D_float const & jmp_overlap_Eposition
)
{
	//using namespace jmp_directions;
	//using namespace jumping;
	//using namespace misc;
	using namespace param_aa;
	using namespace param_torsion;
	//using namespace scorefxns;     // for jmp_chainbreak_weight

	F1.dimension( 3 );
	F2.dimension( 3 );

	static FArray1D_int const fa2cen( 5, fa2cen_initializer ); // N,CA,C,O,CB

	FArray1D_float vec( 3 );

	float const weight_factor
		( 2.0 * scorefxns::jmp_chainbreak_weight); // derivative of ()**2

	if ( weight_factor == 0.0 ) return;//chu: no weight for chainbreak score
	if ( atom >= 1 && ( atom < 5 || ( atom == 5 && aa != aa_gly ) ) ) {
		int const j = fa2cen(atom); // atom in centroid (Eposition) numbering
		for ( int ncut = 1; ncut <= num_fold_tree_cutpoint; ++ncut ) {
			int const cutpoint = fold_tree_cutpoint(ncut);
			int const i = pos - cutpoint;
			if ( i <= jumping::jmp_chainbreak_overlap && i > -jumping::jmp_chainbreak_overlap ) {
				cros( misc::Eposition(1,j,pos), jmp_overlap_Eposition(1,j,i,ncut), vec );
				//std::cout << "add_chainbreak_deriv:: pos= " << pos << " atom= " << atom <<
				//	" cutpoint= " << cutpoint << "\n";
				for ( int k = 1; k <= 3; ++k ) {
					F1(k) += weight_factor * vec(k);
					F2(k) += weight_factor * misc::Eposition(k,j,pos) -
						weight_factor * jmp_overlap_Eposition(k,j,i,ncut);
				}
			}
		}
	}

}

//////////////////////////////////////////////////////////////////////////////
/// @begin set_currently_minimizing
///
/// @brief
///
/// @detailed
///
/// @param[in]  setting
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
// currently -- this should be called by unpack_phipsi
set_currently_minimizing( bool const setting /* input */ )
{
	using namespace wacm;

	we_are_currently_minimizing = setting;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_currently_minimizing
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
bool
get_currently_minimizing()
{
	return wacm::we_are_currently_minimizing;
}



//////////////////////////////////////////////////////////////////////////////
/// @begin jmp_update_nblist
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
jmp_update_nblist(
	pose_ns::Pose & pose
)
{
	using namespace aaproperties_pack;
	//using namespace cenlist_ns;
	//using namespace jumping;
	//using namespace misc;
	using namespace nblist;
	using namespace param;
	using namespace param_aa;
	using namespace param_torsion;
	using namespace runlevel_ns;
	using numeric::xyzVector_float;

	if ( ! get_use_nblist() ) return;

	if ( ! get_currently_minimizing() ) {
		std::cout << "jmp_update_nblist:: nblist only used during minimization in jumping" << "\n";
		jumping_abort();
	}

	bool const fullatom ( pose.fullatom() );

	if ( !fullatom ) pose_update_cendist( pose );

	Score_state cendist_state;
	FArray2D_float const & cendist( pose.get_2D_score( CENDIST,cendist_state ) );
	FArray1D_int const & jmp_domain_map ( pose.get_domain_map() );

	if ( !fullatom ) assert( cendist_state == GOOD );

	int imap,aa1,aa2,type1,type2,aav1,aav2;
	int iiend, jjend;
//	int frag_begin,frag_size;
//	int R_endres,allatom_Rend;
//	int F_beginres,allatom_Fbegin;

	float ca_dis, dist_sq,cutoff;

	FArray2D_bool nbres( MAX_RES()(), MAX_RES()() );
	FArray1D_int nbrs( MAX_RES()() );
//	FArray2D_bool pair_moved( MAX_RES()(), MAX_RES()() );
//	FArray1D_bool res_moved( MAX_RES()() );

	int nb_pair_XX_count,nb_pair_HX_count,nb_pair_HH_count;
	float XX_cutoff;
	float cp_weight; // count_pair extra argument

	if ( false ) std::cout << "jmp_update_nblist:" << "\n";

	minimize_update_fullcoord(); // copy position/centroid to fullcoord
	reset_nblist();

	//update_jmp_domain_map(); // gets info from the moving and moved arrays

//$$$	FArray2DB_bool const & pair_moved( retrieve_pair_moved() );
//$$$	FArray1DB_bool const & res_moved( retrieve_res_moved() );
//$$$
//$$$	i = 1;
//$$$	while ( ! res_moved(i) && i <= total_residue ) { // Fix res_moved array bounds violation!!
//$$$		++i;
//$$$	}
//$$$	R_endres = i-1; // 1 before first changed residue
//$$$	if ( R_endres >= total_residue ) {
//$$$		allatom_Rend = total_atoms;
//$$$	} else {
//$$$		allatom_Rend = res_atm_num2global_atm_num_map(1,R_endres+1) - 1;
//$$$	}
//$$$
//$$$	i = total_residue;
//$$$	while ( ! res_moved(i) && i >= 1 ) { // Fix res_moved array bounds violation!!
//$$$		--i;
//$$$	}
//$$$	F_beginres = i + 1; // 1 after last changed residue
//$$$	allatom_Fbegin = res_atm_num2global_atm_num_map(1,F_beginres);

//	if ( runlevel >= verbose) std::cout << "update nblist" <<
//	 SS( frag_begin ) << SS( frag_size ) << SS( R_endres ) <<
//	 SS( F_beginres ) << "\n";

//Distance checks
// if cen-cen <144 no atoms is residue can bump
// if ca-ca <49 no atom-atom bumps
// if ca-ca>60 no atom-centroid bumps
// maybe should always use paircutoffs?
//bk calculate fullatom residue-residue neighborlist
	if ( fullatom ) {
		make_neighbor_info(misc::res,misc::total_residue,misc::full_coord,nbres,nbrs);
	} else if ( jumping::jdebug ) {      // centroid mode uses cendist
		//jmp_check_cendist();
	}

	nb_pair_XX_count = 0; // for diagnostics only
	nb_pair_HX_count = 0; // for diagnostics only
	nb_pair_HH_count = 0; // for diagnostics only
	XX_cutoff = 0.0; // for diagnostics only

	for ( int i = 1; i <= misc::total_residue; ++i ) {
		aa1 = misc::res(i);
		aav1 = misc::res_variant(i);
		imap = jmp_domain_map(i);
		bool const ifixed ( imap != 0 );
		if ( jumping::jverbose ) std::cout << "update_nblist imap:" <<
		 SS( i ) << SS( imap ) << "\n";
		if ( pose.pseudo(i) ) continue;
//$$$		if ( i <= R_endres ) {
//$$$			copy_neighbors(i,1,allatom_Rend,total_residue);
//$$$			jstart = R_endres+1;
//$$$		} else if ( i >= F_beginres ) {
//$$$			copy_neighbors(i,allatom_Fbegin,total_atoms,total_residue);
//$$$			goto L300; // done, next i
//$$$		} else {
//$$$			jstart = i;
//$$$		}
		for ( int j = 1; j <= misc::total_residue; ++j ) {

			if ( pose.pseudo(j) ) continue;
			if ( imap == jmp_domain_map(j) && ifixed ) {
				goto L100;
			} else if ( fullatom ) {
				if ( ! nbres(i,j) ) goto L100;
			} else {
				if ( cendist(i,j) > cenlist_ns::cen_dist_cutoff2 ) goto L100;
			}

			aa2 = misc::res(j);
			aav2 = misc::res_variant(j);
			ca_dis = distance_squared(
			 xyzVector_float( &misc::Eposition(1,2,i) ), // misc::Eposition(1-3,2,i)
			 xyzVector_float( &misc::Eposition(1,2,j) ) ); // misc::Eposition(1-3,2,j)

			if ( fullatom ) {
				iiend = natoms(aa1,aav1);
			} else {
				iiend = 6;
			}
			for ( int ii = 1; ii <= iiend; ++ii ) {
				if ( ! fullatom && aa1 == aa_gly && ii == 5 ) goto L200;
				{ // Scope
	  			xyzVector_float full_coord_ii_i( &misc::full_coord(1,ii,i) ); // full_coord(1-3,ii,i);

				type1 = all_atom_type(aa1,aav1,ii,fullatom);
				if ( fullatom ) {
					jjend = natoms(aa2,aav2);
				} else {
					jjend = 6;
				}
				for ( int jj = 1; jj <= jjend; ++jj ) {
					if ( i == j && jj < ii ) goto L50;
					if ( ! count_pair(i,ii,aa1,aav1,j,jj,aa2,aav2,fullatom,cp_weight) )
					 goto L50;
//car distance checks
					if ( ! fullatom ) {
						if ( aa2 == aa_gly && jj == 5 ) goto L50; // gly cb
//$$$                     if ( ii == 6 ) {
//$$$c These checks not in vdw_compute, but alluded to
//$$$       if ( jatom != 6 && ca_dis > ca_cen_dist_cutoff2 ) {
//$$$         goto L50;
//$$$       } else if ( jj == 6 ) {
//$$$c        if ( ca_dis > ca_cen_dist_cutoff2 ) goto L50;
//$$$       } else { // neither is a centroid
//$$$c this check in vdw_compute, but not in deriv
//$$$c        if ( ca_dis > ca_dist_cutoff2 ) goto L50;
//$$$       }
					}

					if ( ii == 2 && jj == 2 ) {
						dist_sq = ca_dis;
					} else if ( ! fullatom && ii == 6 && jj == 6 ) {
						dist_sq = cendist(i,j);
					} else {
						dist_sq = distance_squared(
						 full_coord_ii_i, // full_coord(1-3,ii,i)
						 xyzVector_float( &misc::full_coord(1,jj,j) ) ); // full_coord(1-3,jj,j)
					}
					type2 = all_atom_type(aa2,aav2,jj,fullatom);
					cutoff = all_atom_cutoff(type1,type2,fullatom);
					if ( dist_sq < cutoff ) {
						add_to_nblist(i,ii,j,jj,false);
						if ( cutoff == 16.0 ) {
							++nb_pair_HH_count;
						} else if ( cutoff == 25.0 ) {
							++nb_pair_HX_count;
						} else {
							++nb_pair_XX_count;
							XX_cutoff = cutoff;
						}

					}

					if ( false ) {
//                  if ( true ) {
						if ( dist_sq < cutoff )
							std::cout << "nb" << I( 4, i ) << I( 4, ii ) << I( 4, j ) << I( 4, jj )
							 << F( 7, 3, dist_sq ) << F( 7, 3, cutoff ) << "\n";
					}
L50:;
				} // jj

				} // Scope
L200:;
			} // ii
L100:;
		} // j
//L300:;
	} // i

	if ( runlevel >= verbose ) {
		std::cout << "nb_pair_count::" << ' ' << "XX_cutoff:" <<
		 F( 7, 3, XX_cutoff ) <<
		 ' ' << "XX" << ' ' << I( 9, nb_pair_XX_count ) <<
		 ' ' << "HX" << ' ' << I( 9, nb_pair_HX_count ) <<
		 ' ' << "HH" << ' ' << I( 9, nb_pair_HH_count ) << "\n";
	}
	reset_nblist_ends();
	if ( runlevel >= verbose ) write_nblist();

//	update_hblist();

}

//////////////////////////////////////////////////////////////////////////////
/// @begin minimize_set_only_jump
///
/// @brief
///
/// @detailed
///
/// @param[in]  jump
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
minimize_set_only_jump( int const jump_number /* input */ )
{

	minimize_reset_exclude_list(); // so it doesnt get called by pack_phipsi

	for ( int i = 1; i <= misc::total_residue; ++i ) {
		minimize_disallow_residue(i);
	}

	for ( int k = 1; k <= 6; ++k ) {
		minimize_ns::minimize_allow_torsion( param_torsion::first_rb_torsion - 1 + k,
		 jump_number ) = true;
	}
}


/////////////////////////////////////////////////////////////////////////////
namespace junk_ns {
	class Atompair {
	public:
		int i,ii,j,jj;
		Atompair ( int const i0, int const ii0, int const j0, int const jj0 )
		{
			if ( i0<j0 ) {
				i = i0;
				ii = ii0;
				j = j0;
				jj = jj0;
			} else if ( i0>j0 ) {
				j = i0;
				jj = ii0;
				i = j0;
				ii = jj0;
			} else {
				assert( i0==j0 );
				i = i0;
				ii = std::min(ii0,jj0);
				j = i0;
				jj = std::max(ii0,jj0);
			}
		}
	};
	bool operator <( Atompair const & a, Atompair const & b )
	{
		return ( ( a.i  < b.i ) ||
		 ( a.i == b.i && a.ii  < b.ii ) ||
		 ( a.i == b.i && a.ii == b.ii && a.j  < b.j ) ||
		 ( a.i == b.i && a.ii == b.ii && a.j == b.j && a.jj < b.jj ) );
	}
	std::ostream & operator <<( std::ostream & os, const Atompair & a )
	{
		os << "atompair: " << a.i << ' ' << a.ii << ' ' << a.j << ' ' << a.jj;
		return os;
	}
	std::map< Atompair, int > dfunc_pairs;
	std::map< Atompair, int > func_pairs;
	bool init(false);
}


/////////////////////////////////////////////////////////////////////////////
// called by set_currently_minimizing(true) if werent minimizing before
// also by score_set_new_pose
void
add_dfunc_count( int const i, int const ii, int const j, int const jj )
{
	using namespace junk_ns;
	Atompair a(i,ii,j,jj);
	++junk_ns::dfunc_pairs[a]; // 0-initializes
	if ( func_pairs.size() > 0 ) {
		if ( func_pairs.count(a) <= 0 ) {
			std::cout << "dfunc but no func: " << a << "\n";
		} else if ( func_pairs[a] != 1 ) {
			std::cout << "dfunc but func!=1: " << a << ' ' << func_pairs[a] << "\n";
		}
	}
}


void
add_func_count( int const i, int const ii, int const j, int const jj )
{
	using namespace junk_ns;
	using namespace nblist;
	Atompair a(i,ii,j,jj);
	++func_pairs[a]; // 0-initializes
	if ( dfunc_pairs.size() > 0 ) {
		if ( dfunc_pairs.count(a) <= 0 ) {
			std::cout << "func but no dfunc: " << a << "\n";
			std::cout << "nb-list of " << i << ' ' << ii << " :: ";
			int const iatm ( res_atm_num2global_atm_num_map(ii,i) );
			for ( int k = 1; k <= nb_len(iatm); ++k ) {
				int const atomno( nb(k,iatm) );
				std::cout << ' ' << global_atm_num2res_num_map( atomno ) << ',' <<
					global_atm_num2res_atm_num_map( atomno );
			}
			std::cout << "\n";
			std::cout << "nb-list of " << j << ' ' << jj << " :: ";
			int const jatm ( res_atm_num2global_atm_num_map(jj,j) );
			for ( int k = 1; k <= nb_len(jatm); ++k ) {
				int const atomno( nb(k,jatm) );
				std::cout << ' ' << global_atm_num2res_num_map( atomno ) << ',' <<
					global_atm_num2res_atm_num_map( atomno );
			}
			std::cout << "\n";
		} else if ( dfunc_pairs[a] != 2 ) {
			if ( a.i != 1 ) {
				std::cout << "func but dfunc!=2: " << a << ' ' << dfunc_pairs[a] << "\n";
			}
		}
	}
}


void
reset_func_count()
{
	junk_ns::func_pairs.clear();
}


void
reset_dfunc_count()
{
	junk_ns::dfunc_pairs.clear();
}


///////////////////////////////////////////////////////////////////////////////
float
jmp_func_vdw(
	pose_ns::Pose & pose,
	FArray1DB_float & phipsi,
	bool & gfrag
)
{
	if ( pose.atom_tree() ) {
		return atom_tree_func_vdw( pose, phipsi );
	}

	jmp_unpack_phipsi( pose, phipsi, gfrag );
	if ( !gfrag ) return 0.0f;

	return pose.score( scorefxn );

}

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
/// Ediff check -- early escape if energy looks too high compared
/// to reference score.
///
///  Note that the check is triggered by:
///
///     pose.set_extra_score( "EDIFF_SCORE", <float> )
///
/// at some point before calling minimize. Sort of a hack, I don't
/// think the "extra score" stuff was meant for this!
///
bool pose_ediff_check(
  pose_ns::Pose & pose
)
{
	if ( pose.has_extra_score( "EDIFF_SCORE" )) {
		float const ediff = pose.get_0D_score( pose_ns::SCORE ) -
			pose.get_extra_score( "EDIFF_SCORE" );
		pose.unset_extra_score( "EDIFF_SCORE" ); //Don't need that extra score anymore!
		if (ediff > get_ediff_cutoff()) {
			return true; //early return!
		}

	}
	return false;
}
