// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14080 $
//  $Date: 2007-04-09 23:55:07 +0300 (Mon, 09 Apr 2007) $
//  $Author: yab $

#ifndef INCLUDED_jumping_minimize
#define INCLUDED_jumping_minimize


#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// jumping_minimize Function Declarations
typedef  float (*Scoring_Function)();


void
pose_minimize(
	pose_ns::Pose & pose,
	std::string const & min_type,
	std::string const & move_type,
	Scoring_Function score_fxn, // passed in to ensure correct setup of scorefxn
	bool & gfrag
);


void
jmp_dfunc_vdw(
	pose_ns::Pose & pose,
	FArray1DB_float & phipsi,
	FArray1DB_float & dE_dphipsi,
	int const nangles
);


void
jmp_get_atompairE_deriv(
	pose_ns::Pose & pose,
	FArray3DB_float & F1_atompairE,
	FArray3DB_float & F2_atompairE,
	bool const fullatom
);


bool
jmp_get_dock_warshel_elec_deriv(
	const pose_ns::Pose & pose,
	FArray3DB_float & F1_dock_elecE,
	FArray3DB_float & F2_dock_elecE,
	bool const fullatom
	);


void
jmp_unpack_phipsi(
	pose_ns::Pose & pose,
	FArray1DB_float const & phipsi,
	bool & gfrag
);


void
symmetrize_phipsi(
	pose_ns::Pose const & pose,
	FArray1DB_float & phipsi,
	bool const deriv = false
);


void
jmp_get_total_pair_deriv(
	pose_ns::Pose const & pose,
	FArray3DB_float & F1_pair,
	FArray3DB_float & F2_pair
);


void
jmp_link_torsion_vectors(
	pose_ns::Fold_tree const & fold_tree,
	int const seqpos,
	int const torsion,
	FArray3Da_float F1,
	FArray3Da_float F2,
	int const direction
);


void
make_rb_unit_vector_end_pos(
	int const dir,
	pose_ns::Jump const & jump,
	FArray2Da_float Epos1,
	FArray2Da_float Epos2,
	int const torsion,
	FArray1Da_float unit, // output
	FArray1Da_float end_pos // output
);


void
jmp_pack_phipsi(
	pose_ns::Pose const & pose,
	FArray1DB_float & phipsi,
	int & nangles
);


void
jmp_setup_torsion_maps(
	pose_ns::Fold_tree const & fold_tree,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	const bool fullatom
);


void
set_chi_in_map( bool const setting );


bool
get_chi_in_map();


void
jmp_add_torsion(
	pose_ns::Fold_tree const & fold_tree,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	int const seqpos,
	int const torsion,
	int const direction,
	bool const fullatom // input
);


void
jmp_add_chi_torsions(
	pose_ns::Fold_tree const & fold_tree,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	int const seqpos, // input
	bool const fullatom // input
);


void
jmp_add_sc_atoms(
	int const seqpos,
	int const aa,
	int const aav,
	int const torsion_pos,
	int const torsion,
	bool const fullatom,
	bool const chi_in_map
);


void
reset_torsion_maps_and_lists();


void
jmp_add_atom(
	int const resno,
	int const atomno,
	int const seqpos,
	int const torsion
);


bool
check_torsion_maps_and_lists(
	int const total_residue,
	int const num_jump,
	bool const fullatom,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	int const start_vertex
);

void
initialize_torsion_logicals();


bool
torsion_fixes_overlap(
	int const seqpos,
	int const torsion,
	int const dir,
	int const total_residue,
	FArray1D_bool const & is_cutpoint
);


void
add_chainbreak_overlap_deriv(
	pose_ns::Pose const & pose,
	int const seqpos,
	int const torsion,
	int const dir,
	FArray1Da_float F1,
	FArray1Da_float F2
);


void
add_chainbreak_derivative(
	int const pos,
	int const aa,
	int const atom,
	FArray1Da_float F1,
	FArray1Da_float F2,
	int const num_fold_tree_cutpoint,
	FArray1D_int const & fold_tree_cutpoint,
	FArray4D_float const & jmp_overlap_Eposition
);


void
set_currently_minimizing( bool const setting /* input */ );


bool
get_currently_minimizing();


bool
jmp_nblist_ok( bool const setting /* in */ );


void
jmp_update_nblist(
	pose_ns::Pose & pose
);


void
minimize_set_only_jump( int const jump /* input */ );


// debugging crap:
void
minimize_show_deriv_check_stats(
	std::ostream & log
);

void
minimize_get_deriv_check_stats(
	int & nangles,
	int & nangles1,
	int & nangles2,
	float & cos_theta,
	float & abs_log_norm_ratio,
	float & score_delta1,
	float & score_delta2,
	float const abs_tol,
	float const rel_tol
);


bool
minimize_get_deriv_check();


void
minimize_set_deriv_check(
	bool const setting
);


bool
get_dfunc_dump();


void
add_dfunc_count( int const i, int const ii, int const j, int const jj );


void
add_func_count( int const i, int const ii, int const j, int const jj );


void
reset_func_count();


void
reset_dfunc_count();
//int
//get_dfunc_count( int const i, int const ii, int const j, int const jj );


float
jmp_func_vdw(
	pose_ns::Pose & pose,
	FArray1DB_float & phipsi,
	bool & gfrag
);


void
eval_gb_deriv(
	int const atom1,
	int const seqpos1,
	pose_ns::Pose const & pose,
	FArray2D_bool const & neighborlist,
	float const weight,
	FArray1Da_float F1,
	FArray1Da_float F2
);


bool pose_ediff_check(
  pose_ns::Pose & pose
	);

#endif
