// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15424 $
//  $Date: 2007-06-12 21:26:56 +0300 (Tue, 12 Jun 2007) $
//  $Author: bcorreia $

#ifndef INCLUDED_jumping_pairings
#define INCLUDED_jumping_pairings


// Rosetta Headers
#include "pose_fwd.h"
#include "jumping_pairings_ns.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <list>
#include <map>

// forward class declaration
class Pairing;

// jumping_pairings Function Declarations


const pairing_ns::Pairing_list &
read_pairing_list();


void
setup_jump_templates();


pose_ns::Jump
get_random_beta_sheet_jump(
	int const orientation,
	int const pleating
);


void
choose_random_pairings(
	pairing_ns::Pairing_list & decoy_pairings
);


void
pose_from_random_pairings(
	pose_ns::Pose & pose
);


bool
pairing_intersect(
	FArray1Da_int p1,
	FArray1Da_int p2
);

bool
pairing_intersect_bothstrands(
	FArray1Da_int p1,
	FArray1Da_int p2
);


bool
check_two_pairings(
	FArray1Da_int pairing1,
	FArray1Da_int pairing2,
	int & common_strands
);


bool
check_sheet_pairings(
	FArray2Da_int pairing_list,
	const int last_pairing, // input
	const bool force_single_sheet
);


void
setup_same_strand( const bool force_reset = false );


void
reverse_pairing(
	int & pstart,
	int & pstop,
	int & orientation,
	int & pleating
);


void
get_strand_predictions( FArray1Da_float output_strand_sum /* output */ );


FArray1D_float
calc_frag_E();


void
get_loop_predictions( FArray1Da_float output_loop_sum /* output */ );


FArray1D_float const &
get_loop_fraction (
	int const nres
);


void
get_beta_pairing_jumps();



void
initialize_query_pose(
	pose_ns::Pose & pose
);

void
pose_ai( bool const jumping = true);


void
setup_homolog_native(
	pose_ns::Pose const & pose,
	bool & native_exists,
	pose_ns::Pose & native_pose,
	FArray1D_int & mapping
);

float
get_close_chainbreaks_cycle_ratio();

bool
close_chainbreaks(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & eval_weight_map,
	const int max_loop_size,
	const int min_good_loops,
	const float vdw_delta // was hard-coded at 0.5 in rebuild_loops
);


void
main_close_chainbreaks();

int
get_allowed_pairings_from_barcode(
	 pairing_ns::Pairing_list & protein_pairings
	 );

bool close_chainbreaks_after_jumping(	pose_ns::Pose & pose );

bool apply_filters_after_jumping(	pose_ns::Pose & pose );

void relax_and_output_after_jumping( pose_ns::Pose & pose );

void pose_relax_after_jumping( pose_ns::Pose & pose );

#endif
