// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.2 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

// Rosetta Headers
#include "kin_atom.h"
#include "jumping_util.h"
#include "kin_util.h"
#include "pose.h"
#include "aaproperties_pack.h"
#include "atom_tree_minimize.h" // update_nblist! should just make method?

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
//#include <ObjexxFCL/FArray4D.h>
//#include <ObjexxFCL/formatted.io.h>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/constants.hh>
#include <numeric/conversions.hh>
#include <numeric/xyz.functions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/io/orstream.hh>

// C++ Headers
#include <cstdlib>
#include <cstdio>


namespace kin {

	/////////////////////////////////////////////////////////////////////////////
	numeric::xyzVector_float
	Atom::xyz(
		Coords const & coords
	) const
	{
		return coords.get_xyz( atom_id );
	}


	/////////////////////////////////////////////////////////////////////////////
	void
	Atom::update_torsions(
		Coords const & coords,
		bool const recursive
	)
	{
		Stub stub( get_input_stub( coords ) );
		update_torsions( stub, coords, recursive );
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Atom::update_coords(
		Coords & coords
	) const
	{
		Stub stub( get_input_stub( coords ) );
		update_coords( stub, coords );
	}


	/////////////////////////////////////////////////////////////////////////////
	void
	Atom::update_atom_pointer(
		FArray2D< Atom* > & atom_pointer
	)
	{
		atom_pointer( atom_id.atomno(), atom_id.rsd() ) = this;
	}

} // namespace kin
