// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_atom
#define INCLUDED_kin_atom


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "kin_id.h"
#include "kin_min.h"
#include "kin_coords.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>

namespace kin {

	class Atom {
	public:


		///////////////////////////////////////////////////////////////////////////
		// go back and forth between torsions and coords
		virtual
		void
		update_coords(
			Stub & stub,
			Coords & coords // could be a simple wrapper for FArray
		) const = 0;


		//virtual // assumes coords for our input stub are good
		void
		update_coords(
			Coords & coords // could be a simple wrapper for FArray
		) const; // defined in .cc file


		virtual
		void
		update_torsions(
			Stub & stub,
			Coords const & coords,
			bool const recursive = true
		) = 0;


		//virtual
		void
		update_torsions(
			Coords const & coords,
			bool const recursive
		); // defined in .cc file


		///////////////////////////////////////////////////////////////////////////
		// get the position of this atom
		numeric::xyzVector_float
		xyz( Coords const & coords ) const;


		///////////////////////////////////////////////////////////////////////////
		// copy torsions, torsion_moved, allow_move
		virtual
		void
		copy_torsions( Atom const & src ) = 0;

		///////////////////////////////////////////////////////////////////////////
		// access torsions
		virtual
		void
		set_torsion(
			Kin_torsion_type const type,
			float const value
		) = 0;


		virtual
		float
		get_torsion(
			Kin_torsion_type const type
		) const = 0;


		virtual
		pose_ns::Jump const &
		jump() const = 0;


		virtual
		pose_ns::Jump &
		jump() = 0;


		// copy:
		virtual
		Atom*
		copy( Atom* parent_in ) const = 0;


		///////////////////////////////////////////////////////////////////////////
		// for minimizing
		virtual
		void
		setup_min_map(
			Torsion_id & last_torsion,
			Minimizer_map & min_map
		) const = 0;


		virtual
		void
		get_torsion_axis_and_end_pos(
			Coords const & coords,
			numeric::xyzVector_float & axis,
			numeric::xyzVector_float & end_pos,
			Kin_torsion_type const type
		) const = 0;


		///////////////////////////////////////////////////////////////////////////
		// miscellaneous inspection
		virtual
		bool
		is_jump() const = 0;


		virtual
		bool
		torsions_fixed() const = 0;


		// for torsions which must be kept fixed due to topology of tree
		// eg, phi of stub_atoms for jump_atoms
		virtual
		bool
		keep_torsion_fixed(
											 Kin_torsion_type const  //type
		) const { return false; }


		virtual
		void
		show() const = 0;


		virtual
		void
		show_allow_move() const = 0;


		virtual
		bool
		get_torsion_moved() const = 0;


		virtual
		bool
		get_allow_move(
			Kin_torsion_type const type
		) const = 0;


		///////////////////////////////////////////////////////////////////////////
		// setting miscellaneous stuff
		virtual
		void
		set_torsion_moved(
			bool const setting,
			bool const include_fixed_torsions,
			bool const recursive
		) = 0;


		virtual
		void
		set_allow_move(
			Kin_torsion_type const type,
			bool const setting
		) = 0;


		///////////////////////////////////////////////////////////////////////////
		// update domain map
		virtual
		void
		update_domain_map(
			int & current_color,
			int & biggest_color,
			FArray1D_int & domain_map
		) const = 0;


		///////////////////////////////////////////////////////////////////////////
		// destructor -- does not clear pointers, use erase
		virtual
		~Atom(){}


		///////////////////////////////////////////////////////////////////////////
		// for optimizing the tree
		virtual
		Atom*
		trim_fixed_atoms(
			Atom* & parent_in,
			bool & good_stub_in
		) = 0;


		///////////////////////////////////////////////////////////////////////////
		// manage atom_list
		virtual
		void
		add_atom( Atom* ) = 0;


		virtual
		void
		delete_atom( Atom* ) = 0;


		virtual
		void
		insert_atom( Atom* ) = 0;


		virtual
		void
		erase() = 0;

		virtual
		int
		nchildren() const = 0;


		virtual
		Atom const *
		child( int const k ) const = 0;


		virtual
		Atom *
		child( int const k ) = 0;


		virtual
		void
		replace_atom(
			Atom* const old_atom,
			Atom* const new_atom
		) = 0;

		virtual
		bool
		downstream( const Atom* atom1 ) const = 0;

		virtual
		bool
		fixed_downstream( const Atom* atom1, Kin_torsion_type const fixed_tor_id ) const = 0;

		///////////////////////////////////////////////////////////////////////////
		// get stub information
		virtual
		Stub
		get_stub(
			Coords const & coords
		) const = 0;


		virtual
		Stub
		get_input_stub(
			Coords const & coords
		) const = 0;


		virtual
		Atom_id const &
		stub_atom1() const = 0;


		virtual
		Atom_id const &
		stub_atom2() const = 0;


		virtual
		Atom_id const &
		stub_atom3() const = 0;


		virtual
		Atom_id const &
		input_stub_atom0() const = 0;


		virtual
		Atom_id const &
		input_stub_atom1() const = 0;


		virtual
		Atom_id const &
		input_stub_atom2() const = 0;


		virtual
		Atom_id const &
		input_stub_atom3() const = 0;


		///////////////////////////////////////////////////////////////////////////
		//friend class Atom_tree;


		//protected:

		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// protected methods
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////

		// useful helper function for manipulating stubs
		virtual
		void
		update_stub(
			Stub & stub
		) const = 0;


		// when subtrees have changed their coordinates
		virtual
		void
		update_child_torsions(
			Atom* const child,
			Coords const & coords
		) = 0;


		// routines for navigating the tree
		virtual
		Atom const *
		previous_sibling() const = 0;


		virtual
		Atom *
		next_child(
			Atom const * child
		) = 0;


		virtual
		Atom const *
		previous_child(
			Atom const * child
		) const = 0;


		virtual
		std::vector< Atom* >::const_iterator
		nonjump_atoms_begin() const = 0;


		virtual
		std::vector< Atom* >::iterator
		nonjump_atoms_begin() = 0;


		virtual
		bool
		stub_defined() const = 0;


		virtual
		Atom const *
		get_nonjump_atom(
			int const i
		) const = 0;


		virtual
		void
		update_atom_pointer(
			FArray2D< Atom* > & atom_pointer
		);


		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// data
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////

	public: // short-term
		Atom_id atom_id;
		Atom* parent;
	};


	// abort!
	inline
	void
	abort_bad_call()
	{
		std::cout << "kin::Atom bad method call in Atom hierarchy!" << std::endl;
		assert( false );
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

}

#endif
