// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_atom_tree
#define INCLUDED_kin_atom_tree


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "kin_id.h"
#include "kin_min.h"
#include "kin_moving_atom.h"
#include "kin_coords.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>

namespace kin {


	class Atom_tree {
	public:
		void
		setup(
			pose_ns::Fold_tree const & fold_tree,
			FArray3D_float const & full_coord,
			FArray1D_int const & res,
			FArray1D_int const & res_variant
		);


		void
		copy_torsions(
			Atom_tree const & src
		);

		void
		clear(); // deletes all pointers

		void
		update_torsions(
			FArray3D_float const & full_coord,
			int const nres,
			FArray1D_int const & res,
			FArray1D_int const & res_variant
		);

		void
		new_aa_and_coords(
			int const seqpos,
			int const old_aa,
			int const old_aav,
			int const new_aa,
			int const new_aav,
			FArray3D_float const & coords_in
		);

		void // call this after repacking, rotamer trials, etc, BUT NOT DESIGN!
		new_sidechain_coords(
			int const seqpos,
			int const aa,
			int const aav,
			FArray3D_float const & coords
		);


		void
		setup_min_map(
			Minimizer_map & min_map,
			bool const & use_nblist
		);

		void
		refold(
			FArray3D_float & coords
		) const;

		void
		update_domain_map(
			FArray1D_int & domain_map
		) const;


		void
		new_score_pose();



		// for accessing phi/psi/omega/chi
		float
		get_rosetta_torsion(
			int const torsion_number,
			int const rsd
		) const;

		void
		set_rosetta_torsion(
			int const torsion_number,
			int const rsd,
			float const value
		);

		inline
		float
		get_atom_torsion(
			int const atomno,
			int const rsd,
			Kin_torsion_type const type
		) const;

		inline
		void
		set_atom_torsion(
			int const atomno,
			int const rsd,
			Kin_torsion_type const type,
			float const value
		);

		// these two routines return the atom whose PHI torsion
		// corresponds to the rosetta torsion indicated
		Atom const *
		get_rosetta_torsion_atom(
			int const torsion,
			int const rsd
		) const;

		Atom *
		get_rosetta_torsion_atom(
			int const torsion,
			int const rsd
		);

		pose_ns::Jump &
		jump( int const n );

		inline
		Atom const *
		atom( int const atomno, int const rsd ) const;

		inline
		Atom const *
		atom( Atom_id const & id ) const;

		inline
		Atom *
		atom( int const atomno, int const rsd );

		inline
		Atom *
		atom( Atom_id const & id );

		inline
		Atom const *
		root() const { return root_; }

		inline
		Atom *
		root() { return root_; }

		inline
		float
		torsion( Torsion_id const & id ) const {
			return atom( id.atom_id() )->get_torsion( id.type() );
		};

		Atom *
		get_jump_atom(
			int const jump_number
		);

		Atom const *
		get_jump_atom(
			int const jump_number
		) const;

		~Atom_tree() { this->clear(); }

		Atom_tree & operator=( Atom_tree const & srd );

	private:
		Atom const*
		torsion_pointer(
			int const torsion_number,
			int const seqpos,
			float & offset
		) const;

		Atom *
		torsion_pointer(
			int const torsion_number,
			int const seqpos,
			float & offset
		);

		Atom *
		torsion_pointer(
			int const torsion_number,
			int const seqpos,
			float & offset,
			bool & chainbreak
		);

		void
		update_torsion_pointer(
			int const seqpos,
			int const aa,
			int const aav,
			Coords const & coords
		);

		Atom_id
		find_torsion_pointer(
			int const j, //torsion,
			int const i, //seqpos,
			int const aa,
			int const aav,
			float & offset,
			Coords const & coords
			) const;


		Atom* root_;
		FArray2D< Atom* > atom_pointer;
		//FArray1D_float backbone_n2c_offset; // hack
		FArray2D< Atom_id > torsion_pointer_;
		FArray2D_float torsion_offset_;
		//FArray1D< Atom* > jump_pointer;
	};

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////

	inline
	Atom const *
	Atom_tree::atom(
		int const atomno,
		int const rsd
	) const
	{
		return atom_pointer( atomno, rsd );
	}

	/////////////////////////////////////////////////////////////////////////////
	inline
	Atom const *
	Atom_tree::atom(
		Atom_id const & atom_id
	) const
	{
		return atom_pointer( atom_id.atomno(), atom_id.rsd() );
	}

	/////////////////////////////////////////////////////////////////////////////
	inline
	Atom *
	Atom_tree::atom(
		int const atomno,
		int const rsd
	)
	{
		return atom_pointer( atomno, rsd );
	}

	/////////////////////////////////////////////////////////////////////////////
	inline
	Atom *
	Atom_tree::atom(
		Atom_id const & atom_id
	)
	{
		return atom_pointer( atom_id.atomno(), atom_id.rsd() );
	}

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// bb or chi
	inline
	float
	Atom_tree::get_atom_torsion(
		int const atomno,
		int const rsd,
		Kin_torsion_type const type
	) const
	{
		Atom* atom( atom_pointer( atomno, rsd ) );
		if ( atom == 0 ) {
			std::cout << "bad atom: " << atomno << ' ' << rsd << std::endl;
			assert( false );
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		return atom->get_torsion( type );
	}

	/////////////////////////////////////////////////////////////////////////////
	inline
	void
	Atom_tree::set_atom_torsion(
		int const atomno,
		int const rsd,
		Kin_torsion_type const type,
		float const value
	)
	{
		Atom* atom( atom_pointer( atomno, rsd ) );
		if ( atom == 0 ) {
			std::cout << "bad atom: " << atomno << ' ' << rsd << std::endl;
			assert( false );
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		return atom->set_torsion( type, value );
	}


}


#endif
