// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_coords
#define INCLUDED_kin_coords


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "kin_id.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>

namespace kin {

	class Coords {
	public:

		virtual ~Coords() {}

		// interface
		virtual
		void
		set_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_float const & xyz
		) = 0;

		virtual
		void
		set_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_double const & xyz
		) = 0;

		virtual
		void
		get_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_double & xyz
		) const = 0;

		virtual
		void
		get_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_float & xyz
		) const = 0;

		virtual
		numeric::xyzVector_float
		get_xyz(
			Atom_id const & atom_id
		) const = 0;

	};

	/////////////////////////////////////////////////////////////////////////////
	// Coords class that can be created from FArray
	class Coords_FArray : public Coords {
	public:
		// constructor
		Coords_FArray( FArray3D_float & source );

		virtual ~Coords_FArray() {}

		virtual
		void
		set_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_double const & xyz
		);

		virtual
		void
		set_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_float const & xyz
		);

		virtual
		void
		get_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_double & xyz
		) const;

		virtual
		void
		get_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_float & xyz
		) const;

		virtual
		numeric::xyzVector_float
		get_xyz(
			Atom_id const & atom_id
		) const;

	private:
		FArray3D_float & src_coords;

	};

	/////////////////////////////////////////////////////////////////////////////
	// Coords class that can be created from const FArray's --> set_xyz
	// will fail
	class Coords_FArray_const : public Coords {
	public:

		virtual ~Coords_FArray_const() {}

		// constructor
		Coords_FArray_const( FArray3D_float const & source );

		virtual
		void
		set_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_double const & xyz
		);

		virtual
		void
		set_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_float const & xyz
		);

		virtual
		void
		get_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_double & xyz
		) const;

		virtual
		void
		get_xyz(
			Atom_id const & atom_id,
			numeric::xyzVector_float & xyz
		) const;

		virtual
		numeric::xyzVector_float
		get_xyz(
			Atom_id const & atom_id
		) const;

	private:
		FArray3D_float const & src_coords;

	};
}

#endif
