// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_fixed_atom
#define INCLUDED_kin_fixed_atom


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "kin_id.h"
#include "kin_min.h"
#include "kin_atom.h"
#include "kin_atom_bad_return_vals.h"
#include "kin_coords.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>

namespace kin {

	class Fixed_atom : public Atom {
	public:


		///////////////////////////////////////////////////////////////////////////
		// go back and forth between torsions and coords
		virtual
		void
		update_coords(
			Stub & stub,
			Coords & coords // could be a simple wrapper for FArray
		) const;


		virtual
		void
		update_torsions(
			Stub & stub,
			Coords const & coords,
			bool const recursive = true
		);


		///////////////////////////////////////////////////////////////////////////
		// access torsions
		virtual
		void
		set_torsion(
			Kin_torsion_type const, // type,
			float const// value
		){ abort_bad_call(); }


		virtual
		float
		get_torsion(
								Kin_torsion_type const //type
		) const;


		virtual
		pose_ns::Jump const &
		jump() const{ abort_bad_call(); return BAD_JUMP; }


		virtual
		pose_ns::Jump &
		jump(){ abort_bad_call(); return BAD_JUMP; }


		virtual
		void
		show_allow_move() const {}


		///////////////////////////////////////////////////////////////////////////
		// copy torsions, torsion_moved, allow_move
		virtual
		void
		copy_torsions( Atom const & src );


		///////////////////////////////////////////////////////////////////////////
		virtual
		Atom*
		copy( Atom* parent_in ) const;


		///////////////////////////////////////////////////////////////////////////
		// for minimizing
		virtual
		void
		setup_min_map(
			Torsion_id & last_torsion,
			Minimizer_map & min_map
		) const;


		virtual
		void
		get_torsion_axis_and_end_pos(
																 Coords const &,// coords,
																 numeric::xyzVector_float &,// axis,
																 numeric::xyzVector_float &,// end_pos,
																 Kin_torsion_type const// type
		) const{ abort_bad_call(); }


		///////////////////////////////////////////////////////////////////////////
		// miscellaneous inspection
		virtual
		bool
		is_jump() const { return false; }


		virtual
		bool
		torsions_fixed() const { return true; }


		virtual
		void
		show() const;


		virtual
		bool
		get_torsion_moved() const { return false; }


		virtual
		bool
		get_allow_move(
									 Kin_torsion_type const //type
		) const { return false; }


		///////////////////////////////////////////////////////////////////////////
		// setting miscellaneous stuff
		virtual
		void
		set_torsion_moved(
											bool const,// setting,
											bool const,// include_fixed_torsions,
											bool const// recursive
				) {}


		virtual
		void
		set_allow_move(
									 Kin_torsion_type const ,// type,
									 bool const// setting
				) {}


		///////////////////////////////////////////////////////////////////////////
		// update domain map
		virtual
		void
		update_domain_map(
			int & current_color,
			int & biggest_color,
			FArray1D_int & domain_map
		) const;


		///////////////////////////////////////////////////////////////////////////
		// destructor -- does not clear pointers, use erase


		///////////////////////////////////////////////////////////////////////////
		// for optimizing the tree
		virtual
		Atom*
		trim_fixed_atoms(
										 Atom* & ,//parent_in,
										 bool & //good_stub_in
										 ){ abort_bad_call(); return 0; }


		///////////////////////////////////////////////////////////////////////////
		// manage atom_list
		virtual
		void
		add_atom( Atom* ){ abort_bad_call(); }


		virtual
		void
		delete_atom( Atom* ){ abort_bad_call(); }


		virtual
		void
		insert_atom( Atom* ){ abort_bad_call(); }


		virtual
		void
		erase() {}


		virtual
		int
		nchildren() const { return 0;}


		virtual
		Atom const *
		child( int const /* k */ ) const { abort_bad_call(); return 0; }


		virtual
		Atom *
		child( int const /* k */ ) { abort_bad_call(); return 0; }


		virtual
		void
		replace_atom(
								 Atom* const,// old_atom,
								 Atom* const// new_atom
		) { abort_bad_call(); }


		virtual
		bool
		downstream( const Atom* ) const { abort_bad_call(); return false; }

		virtual
		bool
		fixed_downstream( const Atom*, const Kin_torsion_type ) const { abort_bad_call(); return false; }

		virtual
		void
		update_child_torsions(
													Atom* const,// child,
													Coords const &// coords
				) { abort_bad_call(); }


		///////////////////////////////////////////////////////////////////////////
		// get stub information
		virtual
		Stub
		get_stub(
						 Coords const &// coords
		) const{ abort_bad_call(); return BAD_STUB; }


		virtual
		Stub
		get_input_stub(
									 Coords const &// coords
		) const{ abort_bad_call(); return BAD_STUB; }


		virtual
		Atom_id const &
		stub_atom1() const{ abort_bad_call(); return BAD_ATOM_ID; }


		virtual
		Atom_id const &
		stub_atom2() const{ abort_bad_call(); return BAD_ATOM_ID; }


		virtual
		Atom_id const &
		stub_atom3() const{ abort_bad_call(); return BAD_ATOM_ID; }


		virtual
		Atom_id const &
		input_stub_atom0() const{ abort_bad_call(); return BAD_ATOM_ID; }


		virtual
		Atom_id const &
		input_stub_atom1() const{ abort_bad_call(); return BAD_ATOM_ID; }


		virtual
		Atom_id const &
		input_stub_atom2() const{ abort_bad_call(); return BAD_ATOM_ID; }


		virtual
		Atom_id const &
		input_stub_atom3() const{ abort_bad_call(); return BAD_ATOM_ID; }



		//protected:

		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// protected methods
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////

		// useful helper function for manipulating stubs
		virtual
		void
		update_stub(
								Stub & //stub
			) const {}


		// routines for navigating the tree
		virtual
		Atom const *
		previous_sibling() const { return 0; }


		virtual
		Atom const *
		previous_child(
									 Atom const * //child
		) const { return 0; }


		virtual
		Atom *
		next_child(
									 Atom const * //child
		) { return 0; }


		virtual
		std::vector< Atom* >::const_iterator
		nonjump_atoms_begin() const { abort_bad_call(); return BAD_ATOMS.end();}


		virtual
		std::vector< Atom* >::iterator
		nonjump_atoms_begin() { abort_bad_call(); return BAD_ATOMS.end();}


		virtual
		bool
		stub_defined() const { return true; }


		virtual
		Atom const *
		get_nonjump_atom(
										 int const //i
		) const { return 0; }



		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// data
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////

		numeric::xyzVector_double xyz;
	};
}
#endif
