// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_jump_atom_FS
#define INCLUDED_kin_jump_atom_FS


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "kin_id.h"
#include "kin_min.h"
#include "kin_coords.h"
#include "kin_jump_atom.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>

namespace kin {

	class Jump_atom_FS : public Jump_atom {
	public:


		///////////////////////////////////////////////////////////////////////////
		// go back and forth between torsions and coords
		virtual
		void
		update_coords(
			Stub & stub,
			Coords & coords // could be a simple wrapper for FArray
		) const;


		virtual
		void
		update_torsions(
			Stub & stub,
			Coords const & coords,
			bool const recursive = true
		);


		///////////////////////////////////////////////////////////////////////////
		// stubs
		Atom_id const &
		stub_atom1() const { return my_stub_id1; }


		Atom_id const &
		stub_atom2() const { return my_stub_id2; }


		Atom_id const &
		stub_atom3() const { return my_stub_id3; }


		Atom_id const &
		input_stub_atom0() const { return input_stub_id0; }


		Atom_id const &
		input_stub_atom1() const { return input_stub_id1; }


		Atom_id const &
		input_stub_atom2() const { return input_stub_id2; }


		Atom_id const &
		input_stub_atom3() const { return input_stub_id3; }


		///////////////////////////////////////////////////////////////////////////
		// c-tor
		Jump_atom_FS(
			Atom_id const & in_stub_id0,
			Atom_id const & in_stub_id1,
			Atom_id const & in_stub_id2,
			Atom_id const & in_stub_id3,
			Atom_id const & m_stub_id1,
			Atom_id const & m_stub_id2,
			Atom_id const & m_stub_id3
		):input_stub_id0( in_stub_id0 ),
			input_stub_id1( in_stub_id1 ),
			input_stub_id2( in_stub_id2 ),
			input_stub_id3( in_stub_id3 ),
			my_stub_id1( m_stub_id1 ),
			my_stub_id2( m_stub_id2 ),
			my_stub_id3( m_stub_id3 ){}

		//protected:

		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// data
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		Atom_id input_stub_id0, input_stub_id1, input_stub_id2, input_stub_id3,
			my_stub_id1, my_stub_id2, my_stub_id3;

	};
}
#endif
