// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.2 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $


// Rosetta Headers
#include "kin_stub.h"

// ObjexxFCL Headers
//#include <ObjexxFCL/FArray1D.h>
//#include <ObjexxFCL/FArray2D.h>
//#include <ObjexxFCL/FArray3D.h>
//#include <ObjexxFCL/FArray4D.h>
//#include <ObjexxFCL/formatted.io.h>

// Numeric Headers
#include <numeric/all.fwd.hh>
//#include <numeric/constants.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
//#include <utility/io/orstream.hh>

// C++ Headers
//#include <cstdlib>
//#include <cstdio>


namespace kin {

	/////////////////////////////////////////////////////////////////////////////
	Stub::Stub(
		numeric::xyzVector_double const & center,
		numeric::xyzVector_double const & a,
		numeric::xyzVector_double const & b,
		numeric::xyzVector_double const & c
	)
	{
		this->from_four_points( center,a,b,c );
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Stub::from_four_points(
		numeric::xyzVector_double const & center,
		numeric::xyzVector_double const & a,
		numeric::xyzVector_double const & b,
		numeric::xyzVector_double const & c
	)
	{
		typedef numeric::xyzVector_double Vec;
		typedef numeric::xyzMatrix_double Mat;

		Vec e1( a - b);
		e1.normalize();

		Vec e3( cross( e1, c - b ) );
		e3.normalize();

		Vec e2( cross( e3,e1));
		M.col_x( e1 ).col_y( e2 ).col_z( e3 );
		v = center;
	}
}
