// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_stub
#define INCLUDED_kin_stub


// Rosetta Headers
#include "util_basic.h"
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <numeric/all.fwd.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>

// fwd hack
// namespace pose_ns {
// 	class Jump;
// }


namespace kin {

	/////////////////////////////////////////////////////////////////////////////
	class Stub {
	public:
		numeric::xyzMatrix_double M;
		numeric::xyzVector_double v;

		Stub(){};

		Stub(
			numeric::xyzMatrix_double const & M_in,
			numeric::xyzVector_double const & v_in
			):
			M( M_in ),
			v( v_in )
		{}

		// construct a stub centered at v_in, as would come from building
		// c then b then a

		Stub(
			numeric::xyzVector_double const & center,
			numeric::xyzVector_double const & a,
			numeric::xyzVector_double const & b,
			numeric::xyzVector_double const & c
		);

		void
		from_four_points(
			numeric::xyzVector_double const & center,
			numeric::xyzVector_double const & a,
			numeric::xyzVector_double const & b,
			numeric::xyzVector_double const & c
		);
	};

	// deviation between two stubs
	inline
	double
	distance(
		Stub const & a,
		Stub const & b
	)
	{
		using namespace numeric;
		return std::sqrt( distance_squared( a.M.col_x(), b.M.col_x() ) +
											distance_squared( a.M.col_y(), b.M.col_y() ) +
											distance_squared( a.M.col_z(), b.M.col_z() ) +
											distance_squared( a.v,         b.v         ) );
	}
}

#endif
