// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_util
#define INCLUDED_kin_util


// Rosetta Headers
#include "pose_fwd.h"
#include "kin_atom.h"

#include <ObjexxFCL/ObjexxFCL.hh>
#include <numeric/all.fwd.hh>

// C++ Headers

int
chainbreak_phi_atomno(
	int const aa,
	int const aav
);


void
set_default_root_atomno(
	int const aa,
	int const atomno
);


void
set_default_anchor_atomno(
	int const aa,
	int const atomno
);


void
setup_torsion_atom_aa_aav(
	int const aa,
	int const aav,
	FArray2D_int & torsion_atoms,
	FArray2D_int & torsion_rsd_offset
);


kin::Atom*
build_tree(
	pose_ns::Fold_tree const & fold_tree,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray2D< kin::Atom* > & atom_pointer
);

kin::Atom*
build_peptide_edge(
	kin::Atom* parent,
	pose_ns::Edge const & edge,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray2D< kin::Atom* > & atom_pointer
);


kin::Atom*
build_aa(
	kin::Atom* parent,
	int const aa,
	int const aav,
	int const rsd, // needed since Atoms want to know what residue they are
	int const dir,
	FArray1Da< kin::Atom* > atom_ptr,
	kin::Atom* & end_ptr,
	int root_atomno = 0
);


// dir is only used to decide whether to create an "Atom_jump" or an "Atom"
// all recursive calls are made with dir defaulting to n2c

kin::Atom*
add_kin_atom(
	kin::Atom* parent,
	int const aa,
	int const aav,
	int const rsd,
	int const atomno,
	FArray1DB< kin::Atom * > & atom_ptr,
	int const dir = 1 // by default (equiv to c2n here, ie NOT jump)
);


void
setup_kin_atom_properties();

int
get_root_atomno(
	int const aa,
	int const aav,
	int const dir
);


int
get_anchor_atomno(
	int const aa,
	int const aav,
	int const dir
);

#endif
