// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_loops
#define INCLUDED_loops


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>


// Types
typedef  float (*Scoring_Function)();


// loops Function Declarations


void
initialize_start_loops();


void
select_splice_dir( bool & random /* was direction set randomly? */ );


void
initialize_decoy_loops();


void
save_START_loops();


void
set_extended_angles( int j );


void
main_loop_trial(
	Scoring_Function score_fxn,
	int cycle
);


void
main_loop_min_trial(
	Scoring_Function score_fxn,
	int cycle,
	std::string const & type
);


void
main_loop_insert( Scoring_Function scoring_function );


void
eval_loop_deriv(
	int & itorsion, // residue whose torsion the deriv is w/ respect to
	int & phi_or_psi,
	FArray1Da_float Eab, // unit vector along bond
	float & loop_deriv
);


void
set_loop_flag( bool yes_no );


bool
get_loop_flag();


void
set_pose_loop_flag( bool yes_no );


bool
get_pose_loop_flag();


void
choose_random_loop(
	int & begin,
	int & end,
	int & num
);


void
loop_save_overlap_coord(
	int loop_num,
	int key, // 1=Nterminal, 2=Cterminal
	FArray2Da_float position
);


void
loop_get_overlap(
	int loop_num,
	int key, // 1=Nterminal, 2=Cterminal
	FArray2Da_float position
);


void
loop_get_best_overlap(
	int loop_num,
	int key, // 1=Nterminal, 2=Cterminal
	FArray2Da_float position
);


void
loop_score_start(
	std::string const & filename,
	bool const & fullatom,
	bool const & rotamers_exist
);


void
move_loop_into_position(
	int & loop_num_in,
	int & context // number of surrounding residues to include
);


void
loop_restore_position();


void
trim_template();


void
trim_template_reset();


void
reset_loops();


void
identify_loop(
	int & res1,
	int & res2,
	int & begin,
	int & end,
	int & loop_num
);


void
retrieve_loop_ends(
	int loop_num,
	int & begin,
	int & end
);


float
get_loop_splicemsd();


void
loop_get_one_splicerms(
	int iloop,
	float & rms
);


void
loop_get_best_splicemsd(
	int iloop,
	float & msd
);


void
loop_get_all_splicerms(
	FArray1Da_float rms,
	int & num
);


void
loop_retrieve_best_pose();


void
loop_retrieve_low_pose();


void
loop_accept_best_pose();


void
loop_accept_low_pose();


void
calculate_segment_overlap(
	int const seg_num,
	int const fold_begin,
	int const fold_end,
	int const seg_begin,
	int const seg_end,
	int const dir
);


void
loop_halfsplice_reverse(
	FArray2Da_float pos1,
	FArray2Da_float pos2,
	FArray3Da_float pos3,
	int nres
);


void
read_loop_library(
	std::string const & filename,
	utility::io::izstream & funit,
	bool & exist
);


void
write_loop_library(
	std::ostream & funit,
	int num,
	int depth,
	float score1,
	float score2,
	bool const knots,
	float score3
);


void
loop_insert(
	int const loop_no,
	int const j,
	bool & err
);


void
select_starting_loops();


void
check_secstruct(
	FArray1Da_char ss,
	int & nres
);


void
fix_terminal_loops(
	bool yes_no,
	bool & exist
);


void
set_allow_insert_by_looplength(
	int length,
	bool yes_no,
	bool & exist
);


void
set_allow_insert_by_looprms(
	float rms,
	bool yes_no,
	bool & exist
);


bool
loopnum_is_valid( int loop_num );


bool
loop_is_extended( int loop_num );


bool
loop_is_terminal( int loop_num );


void
set_allow_insert_by_extended(
	bool yes_no,
	bool & exist
);


void
set_allow_insert_by_loopnum(
	int loop_num,
	bool yes_no,
	bool & exist
);


void
fix_lowrms_loops(
	float rms,
	bool yes_no,
	bool & exist // if loops >rms exist
);


void
loop_global_rms(
	int const loop_num,
	FArray3Da_float Eposition,
	float & rms
);


void
loop_global_CArms(
	int const_loop_num,
	FArray3Da_float Eposition,
	float & rms
);


void
loop_local_rms(
	int const_loop_num,
	FArray3Da_float p2, // coordinate array,position format
	float & avg_rms
);


void
loop_local_CArms(
	int const_loop_num,
	FArray3Da_float p2, // coordinate array,position format
	float & avg_rms
);


void
loop_gaps(
	float & ngap,
	float & cgap
);


int
loop_get_refold_dir(
	int const loop_num
);


void
loop_set_bfactor(
	float & bfactor,
	int residue
);


void
setup_loop_splicing( bool randomize );


void
initialize_compressed_loops(
	int & total_residue,
	FArray1Da_bool output_res
);


void
output_compressed_loops_header(
	utility::io::orstream & iunit
);


bool
get_loop_fold_with_dunbrack();


void
close_loop_after_moves();


#endif
