// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8300 $
//  $Date: 2006-05-10 22:02:18 +0300 (Wed, 10 May 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_loops_ns
#define INCLUDED_loops_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace loops_ns {


extern int const n2c;
extern int const c2n;


namespace loop_splicing {
	extern bool randomize_dir;
	extern int splice_dir;
}
using namespace loop_splicing;


extern int const max_loop;
extern int const max_loop_depth;
extern int const max_loop_size;


namespace loop_int {
	extern FArray1D_int loop_map; // loop number that each res is in
	extern FArray1D_int loop_begin;
	extern FArray1D_int loop_end;
	extern int num_loop;
	extern FArray1D_int loop_depth; // number of conformations of each loop
}
using namespace loop_int;


namespace loop_real {
	extern FArray4D_float overlap_coord; // xyz,atom,loop#,n/c
	extern FArray4D_float best_overlap_coord;
	extern FArray4D_float low_overlap_coord;
	extern FArray3D_float loop_phi; // loop angles
	extern FArray3D_float loop_psi;
	extern FArray3D_float loop_omega;
}
using namespace loop_real;


namespace loop_char {
	extern FArray3D_char loop_secstruct;
	extern FArray2D_string loop_name;
}
using namespace loop_char;


namespace loop_conflicts {
	extern FArray1D_int loop_rank; // rank order to build loops
	extern FArray1D_float conflicts;
		// any conflicts for each loop region will be stored here
}
using namespace loop_conflicts;


namespace loop_start {
	extern FArray1D_int start_loop_begin;
	extern FArray1D_int start_loop_end;
	extern int start_num_loop;
	extern FArray1D_int start_loop_depth;
}
using namespace loop_start;


namespace loop_bool {
	extern bool permute;
	extern bool screen;
	extern bool fast;
	extern bool fa_refine;
	extern bool fold;
	extern bool trim;
	extern bool idl_breaks;
	extern bool fix_natsc;
	extern bool sequential; // fold loops sequentially, not simultaneously
	extern bool dunbrack_close;
	extern bool fold_with_dunbrack;
	extern bool grow;
	extern bool vdw_max_on;
	extern float vdw_max;
	extern bool rg_max_on;
	extern float rg_max;
	extern bool wiggle_jxn;
}
using namespace loop_bool;

namespace loop_flag_bool {
	extern bool loop_flag;
	extern bool pose_loop_flag;
}

namespace pose_hijack {
	extern int store_num_loop;
	extern int store_loop_begin;
	extern int store_loop_end;
	extern FArray2D_float store_overlapN;
	extern FArray2D_float store_overlapC;
	extern int loop_num;
	extern int store_residue;
	extern FArray1D_int store_res;
	extern FArray1D_int store_resvariant;
	extern FArray3D_float Estore_position;
	extern FArray2D_float store_centroid;
	extern FArray1D_float store_phi;
	extern FArray1D_float store_psi;
	extern FArray1D_float store_omega;
	extern FArray3D_float store_fullcoord;
	extern FArray1D_char store_secstruct;
	extern FArray1D_string store_name;
}

namespace trim_hijack {
	extern bool trim_on;
	extern Dimension active; // Array allocation toggle (for memory savings when !trim_on)
//loops
	extern int store_num_loop;
	extern FArray1D_int store_loop_begin;
	extern FArray1D_int store_loop_end;
	extern FArray1D_int store_loop_depth;
	extern FArray3D_float store_loop_phi;
	extern FArray3D_float store_loop_psi;
	extern FArray3D_float store_loop_omega;
	extern FArray3D_char store_loop_secstruct;
	extern FArray2D_string store_loop_name;
	//pose
	extern int store_residue;
	extern FArray1D_int store_res;
	extern FArray1D_int store_resvariant;
	extern int store_total_domains;
	extern FArray1D_int store_domain_end;
	extern FArray3D_float Estore_position;
	extern FArray2D_float store_centroid;
	extern FArray1D_float store_phi;
	extern FArray1D_float store_psi;
	extern FArray1D_float store_omega;
	extern FArray3D_float store_fullcoord;
	extern FArray1D_char store_secstruct;
	extern FArray1D_string store_name;
	extern FArray1D_bool store_allow_insert;
	//fragments
	extern FArray4D_float store_align_phi;
	extern FArray4D_float store_align_psi;
	extern FArray4D_float store_align_omega;
	extern FArray2D_int store_align_depth;
	extern FArray4D_char store_ss_type;
	extern FArray3D_string store_align_name;
	extern FArray3D_char store_align_chain;
	extern FArray4D_char store_align_res_id;
	extern FArray3D_int store_align_resseq;
	//mapping
	extern FArray1D_int trim_map;
}


} // namespace loops_ns


#endif
