// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14631 $
//  $Date: 2007-04-30 02:54:11 +0300 (Mon, 30 Apr 2007) $
//  $Author: yab $


// Rosetta Headers
#include "initialize.h"
#include "job_distributor.h"
#include "namespace_options.h"
#include "repeat.h"

// Utility Headers
#include <utility/basic_sys_util.hh>

// C++ Headers
#include <algorithm>
#include <cstdlib>
#include <iostream>


// BOINC
#ifdef BOINC

#include "runlevel.h"
#define BOINC_MAX_NO_PROGRESS_INIT_CNT 5 // maximum allowed restarts w/ no progress

#ifdef _WIN32
#include "boinc_win.h"
#include "str_util.h"
#endif
#include "diagnostics.h"
#include "boinc_api.h"
#include "util.h"
#include "boinc_rosetta_util.h"
#include "boinc_rosetta_graphics.h"
#include "watchdog.h"

#ifdef BOINC_GRAPHICS
#include "graphics_api.h"
#include "graphics_lib.h"
#include "graphics_data.h"
#endif

#ifdef __APPLE__
#include "boinc_mac_app_icon.h"
#endif

#else

#if _MSC_VER >= 1400
#include "windows.h"
#endif

#endif

//Graphics
#ifdef GL_GRAPHICS
#include "gl_graphics.h"
#include <pthread.h>
#endif

void* main_rosetta_wrapper(void*);
void main_rosetta();

#if _MSC_VER >= 1400
void
RosettaInvalidParameterHandler(
	const wchar_t* expression,
	const wchar_t* function,
	const wchar_t* file,
	unsigned int line,
	uintptr_t pReserved
)
{
	fprintf(
		stderr,
		"Invalid parameter detected in function %s. File: %s Line: %d\n",
		function,
		file,
		line
	);
	fprintf(
		stderr,
		"Expression: %s\n",
		expression
	);
	DebugBreak();
}
#endif

#ifdef USEMPI
#include "after_opts.h"
#endif // MPI



int
main( int argc, char * argv[] )
{
#ifdef BOINC
	bool nographics_flag = false;

	// DIAGNOSTICS (defined at http://boinc.berkeley.edu/diagnostics.php)
    boinc_init_diagnostics(
		BOINC_DIAG_DUMPCALLSTACKENABLED |
        BOINC_DIAG_HEAPCHECKENABLED |
        BOINC_DIAG_MEMORYLEAKCHECKENABLED |
        // BOINC_DIAG_ARCHIVESTDERR |
        // BOINC_DIAG_ARCHIVESTDOUT |
        BOINC_DIAG_REDIRECTSTDERR |
        BOINC_DIAG_REDIRECTSTDOUT |
        //  BOINC_DIAG_REDIRECTSTDERROVERWRITE |
        //  BOINC_DIAG_REDIRECTSTDOUTOVERWRITE |
        BOINC_DIAG_TRACETOSTDERR // |
        //  BOINC_DIAG_TRACETOSTDOUT
    );

#ifdef __APPLE__
	setMacIcon(argv[0], MacAppIconData, sizeof(MacAppIconData));
#endif

	// Setup the Rosetta Symbol Store for Windows in case it was not already
	//   setup by the core client.
	//
	// TODO: Remove after BOINC 5.6 goes mainstream.
	diagnostics_set_symstore("http://boinc.bakerlab.org/rosetta/symstore");

#if _MSC_VER >= 1400
	// Every once and awhile something looks at a std::vector or some other
	// CRT/STL construct that throws an exception.  In this case we should
	// dump whatever information we can and then bail.  When we bail we
	// should dump as much data as possible.
	_set_invalid_parameter_handler(RosettaInvalidParameterHandler);
#endif
#ifdef _MSC_VER
	// Attempt to load the dlls that are required to display graphics, if
	// any of them fail do not start the application in graphics mode.
	if (FAILED(__HrLoadAllImportsForDll("GDI32.dll"))) {
	   fprintf( stderr, "Failed to load GDI32.DLL...\n" );
	   nographics_flag = true;
	}
	if (FAILED(__HrLoadAllImportsForDll("OPENGL32.dll"))) {
	   fprintf( stderr, "Failed to load OPENGL32.DLL...\n" );
	   nographics_flag = true;
	}
	if (FAILED(__HrLoadAllImportsForDll("GLU32.dll"))) {
	   fprintf( stderr, "Failed to load GLU32.DLL...\n" );
	   nographics_flag = true;
	}
#endif
#ifndef BOINC_GRAPHICS
	// If BOINC_GRAPHICS is not defined then this must be a commandline only
	// version of the application, so make sure graphics are disabled.
	nographics_flag = true;
#endif
	if (nographics_flag) {
	   fprintf( stderr, "Graphics are disabled due to configuration...\n" );
	}

#endif

	// Stream i/o initializations
	std::ios_base::sync_with_stdio( false ); // For C++ stream-only i/o efficiency
	std::cerr.tie( &std::cout ); // Flushes cout before cerr output

	// Set up command line options namespace
	options::arg_count = argc;
	options::arg_vector = argv;

#ifdef BOINC
	if (!nographics_flag) {
#ifdef BOINC_GRAPHICS
// Non-graphics builds can't get in here anyway, but they're also
// unaware of boinc_init_graphics() and throw a compile error...
		if ( boinc_init_graphics( &main_rosetta ) )
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
#endif
	} else {
		if ( boinc_init() )
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
#endif

#ifdef GL_GRAPHICS
		pthread_t p;
		set_worker_done( false );
		pthread_create ( &p, NULL,
										 &main_rosetta_wrapper, NULL );
		main_glut(argc, argv);
#else
		main_rosetta();
#endif
}

void*
main_rosetta_wrapper( void* ) {
	main_rosetta();
	return 0;
}


void
main_rosetta() {

	using namespace main_job_distributor;  // contains pointer to job_distributor "jd"

	// jk Instantiate a job distributor corresponding to the build type
#ifdef BOINC
	jd = new BOINC_job_distributor();
#else
#ifdef USEMPI
	if ( truefalseoption( "mpi_task_distribution" ) ) {
		jd = new MPI_generic_job_distributor();
	} else {
		jd = new MPI_full_job_distributor();
	}
#else
	jd = new job_distributor();
#endif // endif MPI
#endif // endif BOINC

	// general Rosetta setup calls
	jd->initialize();

	if ( jd->check_pose1() ) {
		jd->run_main_pose1();
	} else {
		initialize_query();
		repeat_init();
		if ( jd->check_csa() ) {
			jd->run_csa();
		} else {
			// loop over jobs (for each input structure, for each output decoy per input structure)
			while ( jd->setup_job() ) {
				jd->run_job();
			}
			jd->finish();
		}
	}

	delete jd;
	exit(0);

	return;
}


#ifdef BOINC
#ifdef _WIN32

/*******************************************************
 * Windows: Unix applications begin with main() while Windows applications
 * begin with WinMain, so this just makes WinMain() process the command line
 * and then invoke main()
 */

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrevInst,
                   LPSTR Args, int WinMode)
{
    LPSTR command_line;
    char* argv[1024];
    int argc;

    command_line = GetCommandLine();
    argc = parse_command_line( command_line, argv );
    return main(argc, argv);
}
#endif
#endif



