// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 19:37:52 +0200 (Fri, 10 Mar 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "maps_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>


// Using
using namespace param;


// maps to track where movement is allowed and has occured


namespace protein_maps {

	//--------------
	// torsion angles
	//--------------
	//
	FArray1D_bool allow_insert( MAX_RES() ); // can torsion angles change?
	FArray1D_int insert_map( MAX_RES() ); // list of all moveable residues
	int total_insert; // length of insert_map

	//--------------
	// rigid body interfaces
	//--------------
	//

	//--------------
	// side chains
	//--------------
	//
	//CAR NOTE:  design and docking use their own calls to the packer/rotamer trials
	//car        and allow_repack,allow_rottrial are not relevant
	//

	FArray1D_bool allow_rottrial( MAX_RES() );
	 // sidechains that can be moved by packer
	FArray1D_bool allow_repack( MAX_RES() );
	 // sc that can be moved by rot_trials

}

namespace move_map {
	// side chains that differ between best and current are specified by
	// global array new_rotamer, bb torsions that differ by new_phipsi
	FArray1D_bool new_rotamer( MAX_RES(), true );
	FArray1D_bool new_phipsi( MAX_RES(), true );

	// residues with rigid_body != 0 have undergone a rigid body perturbation
	// if new_rigid_body(i) == new_rigid_body(j), i and j underwent the same
	// rigid body perturbation(s).
	FArray1D_int new_rigidbody( MAX_RES(), 0 );
	int nrb_max_value = { 0 };
	RbMoves rbmoves;

	FArray1D_bool res_moved( MAX_RES() );
	FArray2D_bool pair_moved( MAX_RES(), MAX_RES() );
	FArray1D_bool res_moved_bbonly( MAX_RES() );
	FArray2D_bool pair_moved_bbonly( MAX_RES(), MAX_RES() );
	bool movemap_current = { false };
}

