// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18466 $
//  $Date: 2007-11-16 23:05:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $

#ifndef INCLUDED_minimize
#define INCLUDED_minimize


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <vector>

// Types
typedef  float (*Scoring_Function)();
typedef  float (*f_Function_bf)( bool &, float );


// minimize Function Declarations


void
minimize_reset();


void
minimize_set_tolerance( float const setting );


float
minimize_get_tolerance();


void
minimize_uninit_exclude_list();


void
minimize_exclude_sstype(
	bool Hsetting,
	bool Esetting
);


void
minimize_set_local_min(
	bool on_off,
	int window_size
);


void
minimize_set_vary_phipsi( bool const setting );


void
minimize_set_vary_omega( bool const setting );


void
minimize_set_vary_chi( bool const setting );


void
minimize_set_vary_rb_angle( bool const setting );


void
minimize_set_vary_rb_trans( bool const setting );


void
minimize(
	std::string const & min_type,
	std::string const & move_type,
	Scoring_Function score_fxn, // passed in to ensure correct setup of scorefxn
	int const fold_begin,
	int const fold_end,
	bool & gfrag
);


void
minimize_reset_exclude_list();


void
minimize_allow_residue( int const i );


void
minimize_disallow_residue( int const seqpos );


void
minimize_exclude_residues(
	FArray1DB_int & reslist,
	int & num
);


void
minimize_exclude_frag(
	int begin,
	int size
);


bool
minimize_res_is_excluded( int residue );


void
pack_phipsi(
	FArray1DB_float & phipsi,
	int & nangles,
	int const fold_begin,
	int const fold_end
);


void
unpack_phipsi(
	FArray1DB_float & phipsi,
	int & first,
	int & last,
	bool & gfrag
);


void
minimize_update_fullcoord();


float
func_vdw(
	FArray1DB_float & phipsi,
	bool & gfrag
);


void
dfunc_vdw(
	FArray1DB_float & phipsi,
	FArray1DB_float & dE_dphipsi,
	int nangles
);


void
get_atompairE_deriv(
	int first_res,
	int last_res,
	FArray3DB_float & F1_atompairE,
	FArray3DB_float & F2_atompairE,
	bool fullatom
);


void
link_torsion_vectors(
	int const seqpos,
	int const torsion,
	FArray3DB_float & F1,
	FArray3DB_float & F2
);


void
make_unit_vector(
	int const i,
	int const torsion,
	FArray1DB_float & vec,
	int & end_atom,
	int & end_res
);


void
get_rigid_body_region(
	int const seqpos, // current res
	int const torsion_type, // current torsion
	int & rigid_body_start_atm,
	int & rigid_body_end_atm
);


void
eval_dE_dR(
	int i,
	int ii,
	int j,
	int jj,
	int resi,
	int resj,
	int resvi,
	int resvj,
	bool fullatom,
	float & dE_dR,
	FArray1DB_float & f1, // dimension( 3 )
	FArray1DB_float & f2  // dimension( 3 )
);


void
eval_dis2_f2(
	int i,
	int ii,
	int j,
	int jj,
	FArray1DB_float & ixyz, // dimension( 3 )
	FArray1DB_float & jxyz, // dimension( 3 )
	float & dis2,
	FArray1DB_float & f2 // dimension( 3 )
);


void
get_atm_num_in_count_pair(
	int const aa,
	int const aav,
	int const atm_full,
	int & atm_cp
);


void
eval_total_dunbrack_deriv(
	int const first_res,
	int const last_res,
	FArray2DB_float & chiarray,
	FArray2DB_int & rotarray,
	FArray2DB_float & dunbrack_deriv
);


void
get_total_pair_deriv(
	int const first_res,
	int const last_res,
	FArray3DB_float & F1_pair,
	FArray3DB_float & F2_pair
);


void
calc_and_sum_pair_deriv(
	int const aa1,
	int const aa2,
	int const res1,
	int const res2,
	FArray1Da_float coord1,
	FArray1Da_float coord2,
	FArray1Da_float F1_pair,
	FArray1Da_float F2_pair
);


void
eval_local_vdw_deriv(
	int i,
	int ii,
	int j,
	int jj,
	int resi,
	int resj,
	int resvi,
	int resvj,
	float dis,
	float dis2,
	float & vdw_deriv
);


void
drv_update_nblist();


void
hijack_best_pose_release();


void
hijack_best_pose();


void
debug_minimize_allow_torsion();

void
minimize_set_func( int which_func );


float
func(
	bool & gfrag,
	FArray1DB_float & values
);

void
dfunc(
	FArray1DB_float & values,
	FArray1DB_float & derivatives,
	int n
);


int
get_func_evals();


void
powell(
	bool & gfrag,
	FArray1DB_float & p,
	int n,
	float ftol,
	int & iter,
	float & fret
);


void
brent_set_abs_tolerance( float new_tol );


float
BRENT(
	float const AX,
	float const BX,
	float const CX,
	float & FA,
	float & FB,
	float const FC,
	f_Function_bf F,
	float const TOL,
	float & XMIN,
	bool & gfrag
);


void
linmin(
	FArray1DB_float & P,
	FArray1DB_float & XI,
	int N,
	float & FRET,
	bool & gfrag
);


float
F1DIM(
	bool & gfrag,
	float X
);


void
MNBRAK(
	float & AX,
	float & BX,
	float & CX,
	float & FA,
	float & FB,
	float & FC,
	f_Function_bf func,
	bool & gfrag
);


void
MNBRAK_SMALL_STEP(
	float & AX,
	float & BX,
	float & CX,
	float & FA,
	float & FB,
	float & FC,
	f_Function_bf func,
	bool & gfrag
);


void
dfpmin(
			 FArray1DB_float & P,
			 int N,
			 float FTOL,
			 int & ITER,
			 float & FRET,
			 bool & gfrag
			 );


void dfpmin_armijo(
									 FArray1DB_float & P,
									 int N,
									 float FTOL,
									 int & ITER,
									 float & FRET,
									 bool & gfrag
									 );

void dfpmin_rosetta_r13068(
									 FArray1DB_float & P,
									 int N,
									 float FTOL,
									 int & ITER,
									 float & FRET,
									 bool & gfrag
									 );


void
dfpmin_atol(
	FArray1DB_float & P,
	int N,
	float ATOL,
	int & ITER,
	float & FRET,
	bool & gfrag
);


void
frprmn(
	FArray1DB_float & P,
	int N,
	float FTOL,
	int & ITER,
	float & FRET,
	bool & gfrag
);


void
frprmn_atol(
	FArray1DB_float & P,
	int N,
	float ATOL,
	int & ITER,
	float & FRET,
	bool & gfrag
);

//vds: pb put in to minimize only one residue
void
minimize_include_one_residue( int residue );

void
minimize_only_these_residues(  std::vector <int> min_res );

float
get_ediff_cutoff();

bool
get_minimize_exclude_frag_in_wobble();

bool
get_minimize_exclude_frag_in_crank();

bool
get_minimize_set_local_min();





void
ARMIJO_nonmonotone(
	float & XX,
	float & FP,
	float & DRV,
	f_Function_bf func,
	bool & gfrag,
	int & NF,
	float & XMIN,
	float & FRET
);


void
linmin_armijo_nonmonotone(
	FArray1DB_float & P,
	FArray1DB_float & XI,
	int & NF,
	float & DRV,
	float & FP,
	int & N,
	bool & gfrag,
	float & XMIN,
	float & FRET
);


void
dfpmin_armijo_nonmonotone(
	FArray1DB_float & P,
	int N,
	float FTOL,
	int & ITER,
	float & FRET,
	bool & gfrag
);











#endif



