// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12055 $
//  $Date: 2007-01-16 08:31:33 +0200 (Tue, 16 Jan 2007) $
//  $Author: yab $

#ifndef INCLUDED_misc
#define INCLUDED_misc


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

namespace misc {


//--------
// query
//--------


namespace ints {
	extern int total_residue;
	extern FArray1D_int res;
	extern int total_domains;
	extern FArray1D_int domain_end;
}
using namespace ints;


namespace chars {
	extern FArray1D_string residue3;
	extern FArray1D_char residue1;
}
using namespace chars;


//car atom and centroid types for atom_vdw tables:
//car 1 = N,2 = CA,3 = CB,4 = C,5 = O,6-25 = centroids

namespace radii {
	extern FArray1D_short atom_type;
	extern FArray2Dp_short Eatom_type; // 2D view
	extern FArray1D_short atom_type_cen;
}
using namespace radii;

namespace sstype{
	extern std::string sstype;
}
using namespace sstype;

//-------
// decoy
//-------


//  current

namespace current_pose {
	extern FArray2D_float position;
	extern FArray3Dp_float Eposition; // 3D view
	extern FArray2D_float centroid;
	extern FArray1D_float phi;
	extern FArray1D_float psi;
	extern FArray1D_float omega;
	extern FArray3D_float full_coord;
	extern FArray1D_int res_variant;
	extern FArray1D_string name;
	extern FArray1D_char secstruct;
	extern FArray3D_float centroid_parm_eachres;
}
using namespace current_pose;


// last accepted

namespace best_pose {
	extern FArray3D_float best_full_coord;
	extern FArray2D_float best_position;
	extern FArray3Dp_float Ebest_position; // 3D view
	extern FArray2D_float best_centroid;
	extern FArray1D_float best_phi;
	extern FArray1D_float best_psi;
	extern FArray1D_float best_omega;
	extern FArray1D_int best_res;
	extern FArray1D_int best_res_variant;
	extern FArray1D_string best_name;
	extern FArray1D_char best_secstruct;
	extern FArray3D_float best_centroid_parm_eachres;
}
using namespace best_pose;

}

//pb: temporary just to get things working:
namespace pose_flag_ns {
	extern bool pose_flag_setting;
}
inline bool pose_flag() { return pose_flag_ns::pose_flag_setting; }
void set_pose_flag( bool const setting );

#endif
