// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13219 $
//  $Date: 2007-03-02 17:03:59 +0200 (Fri, 02 Mar 2007) $
//  $Author: leaverfa $

#ifndef INCLUDED_monte_carlo
#define INCLUDED_monte_carlo


// monte_carlo Function Declarations


void
monte_carlo_reset();


void
monte_carlo_set_simannealing( bool setting );


void
monte_carlo_set_quench_temp( float set_temp );


void
monte_carlo_set_temp( float set_temp );


void
monte_carlo_set_accept( int accept_type );


float
monte_carlo_get_temp();


int
get_monte_carlo_accept();

float
get_monte_carlo_energy_drop();

int
get_monte_carlo_converged();

void
monte_carlo( int cycle_number );


void
monte_carlo_accept_best();

void
accept_best_coord();


void
mc_update_scorefxns();


void
monte_carlo_accept_low();


void
reset_movie();


void
write_xyz();

//// yab: misc removal
////   temporarily move tracking variables from misc to here
////   we will finalize later by either encapsulation inside
////   monte carlo/sampling class or score tracking class
namespace mc_global_track {
	//---------------------
	//  monte carlo scores
	//---------------------
	//car WARNING!! These variable belong to monte carlo. They are included
	//car here for diagnostic access only. Only monte carlo is allowed to
	//car change the value of best_score or low_score
	//car score should be set by scorefxn prior to calling monte carlo
	namespace mc_score {
		extern float score;
		extern float best_score;
		extern float low_score;
	}

	//-------------
	// diagnostics
	//-------------
	//CAR WARNING!! these variables belong to monte carlo, and are included
	//car here for diagnostic access only.
	//car best_rms,low_rms car and rms_min should only be changed by monte
	//car carlo, rms_err should be set only by calc_rms().
	namespace diagnose {
		extern float rms_err; // last evaluated rms
		extern float low_rms; // rms  of "low" strucure
		extern float best_rms; // rms  of "best" strucure
		extern float rms_min; // rms minimum encountered by mc
	}
}

//// yab: misc removal

#endif
