// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#include "murphp_classes.h"

#include <iostream>
#include <sstream>

namespace murphp {

  // ____________________ Colorable ____________________

  const int Colorable::WHITE = -1;
  const int Colorable::BLACK = -2;
  const int Colorable::GRAY  = -3;
  const int Colorable::RED   =  1;

  const string& Colorable::toString(const int c) {
    static const string white = "white";
    static const string black = "black";
    static const string gray  = "gray";
    static const string red   = "red";
    static const string other = "other";

    switch( c ) {
    case Colorable::WHITE:
      return white;
    case Colorable::BLACK:
      return black;
    case Colorable::GRAY:
      return gray;
    case Colorable::RED:
      return red;
    default:
      return other;
    } // c

  } // Colorable::toString

  const int Colorable::fromString(const string& s) {
    if( s == "white" ) {
      return Colorable::WHITE;
    }
    else if( s == "black" ) {
      return Colorable::BLACK;
    }
    else if( s == "gray" ) {
      return Colorable::GRAY;
    }
    else if( s == "red" ) {
      return Colorable::RED;
    }
    else {
      assert( false );
    }

  } // Colorable::fromString

  // ____________________ Indexable ____________________



  // ____________________ Point2 ____________________

  const double Point2::dist(const Point2& a, const Point2& b) {
    Point2 c = b - a;
    return c.size();
  }

  const double Point2::size() const {
    return sqrt(x*x + y*y);
  }

  const Point2 Point2::operator*(const double& d) const {
    return Point2(x*d, y*d);
  }

  const Point2 Point2::operator/(const double& d) const {
    return Point2(x/d, y/d);
  }

  const Point2 operator+(const Point2& a, const Point2& b) {
    return Point2(a.x + b.x, a.y + b.y);
  }

  const Point2 operator-(const Point2& a, const Point2& b) {
    return Point2(a.x - b.x, a.y - b.y);
  }

  Point2::operator Point3() const {
    return Point3(x,y,0);
  } // Point2::operator Point3

  ostream& operator<<(ostream& out, const Point2& p) {
    return out << p.x << " " << p.y;
  }

  istream& operator>>(istream& in , Point2& p) {
    return in >> p.x >> p.y;
  }


  const bool Point2::operator==(const Point2& other) const {
    return x == other.x && y == other.y;
  } // Point2::operator==

  const bool Point2::operator<(const Point2& other) const {
    return x < other.x || x == other.x && y < other.y;
  } // Point2::operator<

  const bool Point2::operator<=(const Point2& other) const {
    return (*this) < other || (*this) == other;
  } // Point2::operator<=

  const bool Point2::operator>(const Point2& other) const {
    return ! ((*this) <= other);
  } // Point2::operator>

  const bool Point2::operator>=(const Point2& other) const {
    return ! ((*this) < other);
  } // Point2::operator>=

  // ____________________ Point3 ____________________


  const Point3 Point3::rand() {
    return Point3(drand48(),drand48(),drand48());
  } // Point3::rand

  const Point3 Point3::theZero(0,0,0);
  const Point3 Point3::theXhat(1,0,0);
  const Point3 Point3::theYhat(0,1,0);
  const Point3 Point3::theZhat(0,0,1);

  const double Point3::calculate_angle(const Point3& a, const Point3& b, const Point3& c) {
    Point3 x;
    Point3 y;

    x = c-b;
    y = a-b;
    return acos(Point3::dot(x,y)/(x.size()*y.size()));
  }

  ostream& operator<<(ostream& out, const Point3& p) {
    for(int i = 0; i < 3 ; ++i ) {
      out << p[i] << " ";
    } // i
    return out;
  }

  istream& operator>>(istream& in, Point3& p) {
    for(int i = 0; i < 3 ; ++i ) {
      in >> p[i];
    } // i
    return in;
  }

  const string Point3::getR() const {
    ostringstream s;
    s << "c(" << m_d[0] << "," << m_d[1] << "," << m_d[2] << ")";
    return s.str();
  } // Point3::getR


} // murphp
