// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19066 $
//  $Date: 2007-12-12 10:37:37 +0200 (Wed, 12 Dec 2007) $
//  $Author: yab $

#ifndef INCLUDED_options
#define INCLUDED_options


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// options Function Declarations

void
get_rosetta_options(
	std::string & mode,
	int & number_of_output
);


void
get_io_options(
	std::string const & mode,
	bool & setup_fa,
	int & number_of_output
);


void
get_refine_options();


void
get_barcode_stats_options();


void
get_featurizer_options();


void
get_score_options();


void
get_idealize_options();


void
get_relax_options();


void
get_abrelax_options();


void
get_loopmode_options();


void
get_loop_options();


void
get_assemble_options();


void
get_pose1_options();


void
get_domain_insertion_options();

void
get_antibody_modeler_options();

void
get_pose_looping_options();


void
get_design_options();


void
get_dna_interface_options();


void
get_interface_options();


void
get_interface_ddg_options();


void
get_pdbstats_options();


void
get_docking_options();


void
get_dockmode_options();


void
get_membrane_options();

void
get_geometric_solvation_options();


void
setup_runlevel();


void
select_default_scorefxns(
	std::string const & fxn,
	std::string const & fa_fxn
);


void
setup_default_scorefxn( bool & output_fa );


void
check_options(
	std::string const & mode,
	int & number_of_output
);


void
enable_multi_chain();

void
adjust_options_protein_prefix_homolog();

void
adjust_options_protein_prefix_query();

void initialize_score_reweights();

#endif
