// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $

#ifndef INCLUDED_output_decoy
#define INCLUDED_output_decoy


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <iosfwd>

// Forward declarations
namespace pose_ns { class Pose; }
namespace silent_io { class Silent_out; }

// output_decoy Function Declarations

namespace makepdb_decoy {
	extern int makepdb_number;
	extern std::string decoy_cnt_filename;
}


// SJF Class definition for cat_pdb_writer
class cat_pdb_writer {

public:

	std::string curr_filename;
	utility::io::ozstream pdb_out_stream;

	cat_pdb_writer();

	void set_filename( std::string const & fullname );

	~cat_pdb_writer();

};

bool cat_filename_exists( std::string const & fullname ); // has this filename been started?

void
output_decoy( bool & accepted /* true if structure passes all cutoff criteria */ );

void
output_decoy_mem(std::stringstream &output_strstream,
                 bool & accepted /* true if structure passes all cutoff criteria */ );

void
open_decoy_pdb(
	std::string const & mode,
	int const ns, // number of the current starting structure
	int const no, // number of the current output structure for this start structure
	bool & fail
);


void
check_decoy_exists(
	std::string const & mode,
	int const ns, // number of the current starting structure
	int const no, // number of the current output structure for this start structure
	bool & exists,
	std::string & filename
);


void
retrieve_decoy_name( std::string & filename );


void
retrieve_decoy_number( int & number );


void
reset_timer();


double
retrieve_timer_start();


void
reset_decoy_pdb();


void
scorefile_output(
	std::string const & filename_in,
	std::string const & tag,
	bool fullatom
);


void
strip_path(
	std::string const & filename_in,
	std::string & filename_out
);


void
scorefile_scroll_and_detect(
	utility::io::izstream & iunit,
	std::string const & filename,
	std::string const & tag,
	bool & found_it
);


bool
scorefile_entry_present(
	std::string const & filename_in,
	std::string const & tag,
	bool const fullatom
);


void
output_compressed(
	bool const accepted,
	bool const fullatom
);


void
output_taboo( bool const accepted );


void
apply_filters(
	bool & accepted,
	std::string & tag
);


void
apply_filters_wrapper(
	bool const fullatom,
	bool & accepted
);


void
set_decoy_number( int const number );


void
get_decoy_number( int & number );


bool
get_output_silent_gz_flag();


bool
get_output_scorefile_gz_flag();


std::string
get_scorefile_name();


// Added for BOINC from World Community Grid
bool
saveDecoyInfo(
	int attempts,
	int complete,
	int farlx_stage
);


// Added for BOINC from World Community Grid
bool
restoreDecoyInfo(
	int & attempts,
	int & complete,
	int& farlx_stage
);


// Added for BOINC from World Community Grid
void
checkpoint_decoys(
	int attempts,
	int complete,
	int farlx_stage
);


void
output_score_only();

void
output_score_log( std::string const & name );


void
output_docking_compressed(
	bool const accepted,
	bool const fullatom
	);


void
output_pose_docking_compressed(
	bool const accepted,
	bool const fullatom
);


int
get_decoy_attempt_counter();


bool
no_prev_decoy_attempts();


void
reset_decoy_attempt_counter();


void
increment_decoy_attempt_counter();


bool
get_do_checkpointing();

bool
get_do_pose_checkpointing();

int
get_checkpoint_interval();

bool
get_pose_silent_out_flag();

void
silent_out_save_start_pose(
	bool const fullatom,
	bool const ideal_pose,
	bool const coords_init
);

void
silent_out_save_decoy_pose(
	pose_ns::Pose & pose
);

void
silent_out_write_nonideal_geometry(
	pose_ns::Pose & pose,
	silent_io::Silent_out & silent_out,
	std::string filename
);

void
output_pose_compressed(
	bool const accepted,
	bool const fullatom
);

bool
silent_out_decoy_pose_exist();

utility::io::ozstream & get_cat_pdb_stream( std::string const & fullname );

#endif
