// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef INCLUDED_pH_main
#define INCLUDED_pH_main


//ObjexxFLC Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// =============================================================================
//
//     pH_main.cc
//
//     Ryan Harrison May 2005
//     Gray Lab at Johns Hopkins University
//
// =============================================================================

// =============================================================================
// pH mode: (Ryan Harrison, JHU)
//
// This file adds capability for ROSETTA to handle fullatom pH-sensitive
// rotamers. pH-sensitive rotamers allow ROSETTA to sample the physically relevent
// charge states (protonation states) of asp, glu, his, lys, arg and tyr. The
// inclusion of these rotamers allows ROSETTA to not only calculate pKa shifts,
// but also to do pH-sensitive docking and design.
//
// pH-mode uses a simple protonation score to approximate the energy
// associated with transfering a proton from a side chain to solution (ie. acids)
// or solution to side chain (ie. bases). The protonation score is included with
// the other full atom energies. An additional aa variant is included in
// read_aaproperties.cc to represent the alternate charge states. These variants
// have explicitly added/removed hydrogens, modified partial charges, modified
// hbonding and modified solvation. This approach allows the amino acid
// local environment to shift the pH equilibrium accordingly. For example,
// a histidine surrounded by lysines could have its pKa shifted upwards
// to counteract the unfavorable electrostatics.
//
// Activate the pH-mode using the -pH <pH> command line flag.  For the moment,
// pH-mode does not work with abinitio (unknown bug) or alternate his tautomers
// (just not included yet).
// pH-mode is untested on all fullatom modes except score, docking and design.
//
// =============================================================================

void
get_pH_packing_options();

bool
get_pH_packing_flag();

void
set_pH_packing_flag( bool true_false );

float
get_current_pH();

void
calc_dGprotonation_table();

void
create_pH_variants( int aa );

#endif //End PH_run_main


