// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

#ifndef INCLUDED_pH_ns
#define INCLUDED_pH_ns


//ObjexxFLC Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace pH_ns {

	extern float pH;
	extern float WpH;
	extern float Wgb;
	extern float Wscale;
	extern FArray2D_float dGprotonation_table;
	extern FArray1D_float aa_pKa;
}

namespace LookUp_aav_pH {

	extern int asp_duplicate1;        // Duplicate of base variant of Aspartic Acid
	extern int asp_duplicate2;        // Duplicate of base variant of Aspartic Acid
	extern int asp_duplicate3;        // Duplicate of base variant of Aspartic Acid
	extern int asp_duplicate4;        // Duplicate of base variant of Aspartic Acid
	extern int asp_duplicate5;        // Duplicate of base variant of Aspartic Acid
	//rh Duplicate used to keep an equal number of degrenerate states for protonated and deprotonated variants.
	extern int asp_OD1protonated;    // Protonated variant for Apsartic Acid (1HD1-->OD1)
	extern int asp_OD2protonated;    // Protonated variant for Apsartic Acid (1HD2-->OD2)

	extern int glu_duplicate1;        // Duplicate of base variant of Glutamic Acid
	extern int glu_duplicate2;        // Duplicate of base variant of Glutamic Acid
	extern int glu_duplicate3;        // Duplicate of base variant of Glutamic Acid
	extern int glu_duplicate4;        // Duplicate of base variant of Glutamic Acid
	extern int glu_duplicate5;        // Duplicate of base variant of Glutamic Acid
	extern int glu_OE1protonated;    // Protonated variant for Glutamic Acid (1HE1-->OE1)
	extern int glu_OE2protonated;    // Protonated variant for Glutamic Acid (1HE2-->OE2)

	extern int his_protonated1;      // Fully protonated variant for Histidine. Both HD1 and HE1.
	extern int his_protonated2;      // Duplicate fully protonated variant for Histidine. Both HD1 and HE1.
	//rh Duplicate used to keep an equal number of degrenerate states for protonated and deprotonated variants.

	extern int tyr_HHdeprotonated;   // Deprotonated variant for Tyrosine (HH // OH)
	extern int lys_3HZdeprotonated;  // Deprotonated variant for Lysine ( 3HZ // NZ)
	extern int arg_1HH2deprotonated; // Deprotonated variant for Arginine ( 1HH2 // NH2)
}


void
get_aa_pKa();

#endif //End pH_ns
