// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15424 $
//  $Date: 2007-06-12 21:26:56 +0300 (Tue, 12 Jun 2007) $
//  $Author: bcorreia $

#ifndef INCLUDED_pack
#define INCLUDED_pack

#include "pack_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


//using namespace pack; -- WHOAAAA -- never put a "using namespace" in a .h file!


void
get_rotamer_set( std::string & setting );

/* -- Included in pack_fwd.h

void
select_rotamer_set( std::string const & setting );


void
pack_rotamers(
	pose_ns::Pose & pose,
	PackerTask const & Task
);

void
pack_rotamers_setup(
	PackerTask const & Task,
	RotamerSet & rotamer_set,
	pack::InteractionGraphBase * & ig,
	pose_ns::Pose & pose,
	FArray1D_int & current_rot_index,
	FArray1D_float & ligenergy1b_old
);

void
pack_rotamers_run(
	PackerTask const & Task,
	RotamerSet const & rotamer_set,
	pack::InteractionGraphBase * ig,
	pose_ns::Pose & pose,
	FArray1D_int & current_rot_index,
	FArray1D_float & ligenergy1b_old,
	std::vector<int> rot_to_pack = std::vector<int> (0) // default empty vector
);
*/

void
pack_update_new_rotamer(
	const DesignMap & design_map,
	int total_residue
);


void
set_design_matrix(
	const DesignMap & input_design_map,
	int const total_residue
);


void
get_design_matrix(
	DesignMap & output_design_map,
	int const total_residue
);


void
ang_from_pdb_wsc(
	int nres, // # of residues in the protein
	FArray1Da_int aan, // specifies amino acid at each seqpos
	FArray1Da_int aa_variant, // amino acid variation at each position
	FArray3Da_float xyz,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray2Da_float chi,
	FArray2Da_int rot
);

void
get_chi_and_rot_from_coords(
	int total_residue,
	FArray1Da_int aan,
	FArray1Da_int aavn,
	FArray3Da_float full_coord,
	FArray2Da_float chi_out,
	FArray2Da_int rot_out
);

void
get_real_chi_from_coords(
	int nres,
	FArray1Da_int aan,
	FArray1Da_int aavn,
	FArray3Da_float xyz,
	FArray2Da_float chi_out
);


void
set_all_chi_to_periodic_range(
	FArray1Da_float chi,
	int aa
);


float
set_chi_to_periodic_range(
	float chi,
	int aa,
	int chino
);


float
subtract_chi_angles(
	float chi1,
	float chi2,
	int aa,
	int chino
);


void
precompute_rotamer_energies(
	pack::InteractionGraphBase * ig,
	RotamerSet & rotamer_set,
	PackerTask const & Task,
	FArray2D_short & neighbor_indexno,
	FArray1D_float & ligenergy1b_old,
	pose_ns::Pose & pose
);

int
count_moltenres ( const DesignMap & design_map );

void
get_energies(
	RotamerSet & rotamer_set,
	const PackerTask & Task,
	FArray1D_float & ligenergy1b,
	FArray2DB_short const & neighbor_indexno,
	pack::PrecomputedPairEnergiesInteractionGraph & ig,
	int total_residue,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord
);

void
calc_one_body_energies_for_on_the_fly_graph(
	pack::OnTheFlyInteractionGraph & ig,
	FArray1D_float & ligenergy1b,
	FArray2DB_short const & neighbor_indexno,
	RotamerSet & rotamer_set,
	const PackerTask & Task,
	int total_residue,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord
);


void
assign_weight_map_for_on_the_fly_graph(
	pack::OnTheFlyInteractionGraph & ig,
	const PackerTask & Task
);

float
get_bb_bbE
(
	RotamerSet & rotamer_set,
	int rot1,
	int rot2
);

float
get_sc_bbE
(
	RotamerSet & rotamer_set,
	int scrot,
	int bbrot
);


float
get_1body_energy(
	RotamerSet & rotamer_set,
	int const & rot,
	int const & rotres,
	int const & aarot,
	int const & aavrot,
	FArray2Da_float rotcoord_11r,
	FArray1DB_float & energy1b_base,
	const PackerTask & Task
);


float
get_base_2body_energy(
	int const & rot1res,
	int const & aarot1,
	int const & aavrot1,
	FArray2Da_float coord1,
	FArray1Da_float actcoord1,
	int const & rot2res,
	int const & aarot2,
	int const & aavrot2,
	FArray2Da_float coord2,
	FArray1Da_float actcoord2,
	const PackerTask & Task
);

float
get_variant_2body_energy(
	int const & rot1res,
	int const & aarot1,
	int const & aavrot1,
	FArray2Da_float coord1,
	FArray1Da_float born_radius1,
	int const & rot2res,
	int const & aarot2,
	int const & aavrot2,
	FArray2Da_float coord2,
	FArray1Da_float born_radius2,
	const PackerTask & Task
);

void
get_Paa_ppE(
	float phi,
	float psi,
	int aa, // amino acid
	float & Paa_ppE, // -lnP(aa|phi,psi)
	float & dlog_Paa_dphi,
	float & dlog_Paa_dpsi
);


float
get_Paa_pp_deriv(
	int aa,
	float phi,
	float psi,
	int torsion
);


void
get_intra_resE(
	int const aa, // amino acid type
	int const aav, // amino acid variants
	FArray2Da_float coord, // coordinates
	float & atrE, // attractive energy
	float & repE // repulsive energy
);


void
get_bb_bbE(
	int res1,
	int res2,
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2DB_float & coord1,
	FArray2DB_float & coord2,
	float & repE,
	float & atrE,
	float & solE,
  float & elecE
);

void
get_bb_bbE_P(
	int res1,
	int res2,
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & repE,
	float & atrE,
	float & solE,
  float & elecE
);


void
get_sc_bbE_B(
	int aasc,
	int aavsc,
	int aabb,
	int aavbb,
	FArray2DB_float & sccoord,
	FArray2DB_float & bbcoord,
	int scres,
	int bbres,
	float & sc_bbsolvE,
	float & sc_bbatrE,
	float & sc_bbrepE,
  float & elecE
);


void
get_sc_bbE(
	int aasc,
	int aavsc,
	int aabb,
	int aavbb,
	FArray2Da_float sccoord,
	FArray2Da_float bbcoord,
	int scres,
	int bbres,
	float & sc_bbsolvE,
	float & sc_bbatrE,
	float & sc_bbrepE,
  float & sc_bbelecE
);


void
get_sc_scE_B(
	int aa1,
	int aav1,
	FArray2DB_float & coord1,
	int aa2,
	int aav2,
	FArray2DB_float & coord2,
	FArray1DB_float & actcoord1,
	FArray1DB_float & actcoord2,
	int res1,
	int res2,
	float & solvE,
	float & atrE,
	float & repE,
	float & pairE,
	float & plane_totalE,
  float & elecE
);


void
get_sc_scE(
	int aa1,
	int aav1,
	FArray2Da_float coord1,
	int aa2,
	int aav2,
	FArray2Da_float coord2,
	FArray1Da_float actcoord1,
	FArray1Da_float actcoord2,
	int res1,
	int res2,
	float & solvE,
	float & atrE,
	float & repE,
	float & pairE,
	float & plane_totalE,
  float & elecE
);


void
get_res_resE(
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2DB_float & coord1,
	FArray2Da_float coord2,
	FArray1DB_float & actcoord1,
	FArray1Da_float actcoord2,
	int res1,
	int res2,
	float & solE,
	float & atrE,
	float & repE,
	float & pairE,
	float & plane_totalE,
  float & elecE
);


void
get_pairtermE(
	int const aa1,
	int const aa2,
	int const res1,
	int const res2,
	FArray1Da_float actcoord1,
	FArray1Da_float actcoord2,
	float & pairE,
	float & dpairE_dr
);


void
get_ligenergies(
	FArray1D_float & energy1b,
	RotamerSet const & rotamer_set
);

void
compute_ligand_energies(
	pack::PrecomputedPairEnergiesInteractionGraph * ig,
	DesignMap const & design_map,
	RotamerSet const & rotamer_set,
	int total_residue,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord
);

void
add_to_energy1b(
	FArray1Da_float energy1b,
	FArray1Da_float subenergy1b,
	int const nrotamers
);


void
bump_check(
	int const aa,
	int const aav,
	int const resnum,
	FArray2Da_float coord,
	FArray3Da_float full_coord,
	FArray1Da_int aan,
	FArray1Da_int res_variant,
	const DesignMap & design_map,
	int & total_residue,
	float & bumpenergy
);


void
fast_pairenergy_attached_h(
	int const res1,
	int const res2,
	int const atom1,
	int const atom2,
	int const aa1,
	int const aa2,
	int const aav1,
	int const aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & repE,
  float & elecE
);


// fast_pairenergy_with_hydrogens is currently inlined in pack.cc
// It should not be called from other .cc files.
/*
void
fast_pairenergy_with_hydrogens(
	int const res1,
	int const res2,
	int const atom1,
	int const atom2,
	int const aa1,
	int const aa2,
	int const aav1,
	int const aav2,
	FArray2DB_float & coord1,
	FArray2DB_float & coord2,
	float & solvE,
	float & atrE,
	float & repE
);
*/


void
fast_pairenergy_flexible(
	int res1,
	int aa1,
	int startatom1,
	int endatom1,
	FArray2Da_float tcoord,
	int res2,
	int aa2,
	int startatom2,
	int endatom2,
	FArray2Da_float tcoord2,
	float & solE,
	float & atrE,
	float & repE,
  float & elecE
);


void
dang_from_chi(
	float chi1,
	float chi2,
	float & dang
);


void
get_wcentroid_closest_chi(
	int & chi, // highest chi angle controling the centroid
	int aa
);


void
put_wcentroid(
	FArray2Da_float aa_coord, // coordinates of sidechain
	FArray1Da_float wcentroidxyz,
	int aa // amino acid type
);



void
get_phibin(
	float phi,
	float psi,
	int & iphi,
	int & ipsi,
	int resnum,
	int total_residue
);


void
get_phi_interpolate_bin(
	float phi,
	float psi,
	int & phibin,
	int & psibin,
	int & phibin_next,
	int & psibin_next,
	float & phi_err,
	float & psi_err,
	int seqpos,
	int total_residue
);


void
make_neighbor_info(
	FArray1DB_int const & aan,
	int total_residue,
	FArray3DB_float const & full_coord,
	FArray2DB_bool & neighborlist,
	FArray1DB_int & neighbors
);


void
make_neighbor_indexno(
	FArray2Da_short neighbor_indexno,
	const DesignMap & design_map,
	pose_ns::Pose & pose
);


void
put_cah(
	FArray3DB_float & full_coord,
	int first,
	int last,
	FArray1DB_int const & res,
	FArray1DB_int const & res_variant
);


void
place_atom(
	int const aa,
	int const aav,
	int const atom,
	FArray2Da_float res_coor
);


void
design_output(
       int const & total_residue_inout,
       FArray1Da_int const res_inout,
       FArray1Da_int const res_variant_inout,
       FArray3Da_float const full_coord_inout,
			 //pose_ns::Pose & pose,
			 int const & run
);

void
design_score(
	pose_ns::Pose & pose,
	int & run
);


void
pre_design_trials(
									pose_ns::Pose & pose
);


void
design_rotamer_trials(
	DesignMap const & design_map,
	pose_ns::Pose & pose
);


float
get_native_bonus();


void
set_native_bonus(
	float const setting
);


bool
get_favor_native_residue();


void
set_favor_native_residue(
	bool const setting
);


void
design_mcmin_trials(
	pose_ns::Pose & pose,
  RotamerSet const & rotamer_set,
	FArray2DB_bool & neighborlist,
  FArray1DB_float & rot_freq,
	bool const start_with_current
);


void
place_rotamer(
  int seqpos,
	int aa,
	int aa_var,
  FArray2Da_float coord
);


void
set_maps_for_minimizing_neighbors(
  int const seqpos,
  FArray2DB_bool & neighborlist
);


void
output_mcmin_status(
  int const counter,
	FArray1DB_int & start_sequence,
	int total_residue,
	FArray1D_int const & res
);


void
make_pruned_rotamer_list(
	FArray1DB_float & rot_freq,
	RotamerSet const & rotamer_set,
	FArray1DB_int & pruned_rot_list,
  int & npruned_rotamers
);


void apply_electrostatic_complementarity_shift(
 	pack::InteractionGraphBase * ig,
	RotamerSet & rotamer_set,
	float const Eshift
);


void
dump_rotamers_pdb(
	PackerTask const & Task,
	RotamerSet & rotamer_set,
	pack::InteractionGraphBase * ig,
	int const pos,
	std::ofstream & rotsfile,
	int const aa
);

void
print_residue_coords(
	std::ostream & outstream,
	int const pos,
	int const aa,
	int const aav,
	FArray2Da_float coord,
	float const b_col
);

#endif
