// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13219 $
//  $Date: 2007-03-02 17:03:59 +0200 (Fri, 02 Mar 2007) $
//  $Author: leaverfa $


// Rosetta Headers
#include "after_opts.h"
#include "pack_bump_selector.h"
#include "pack_bump_selector_ns.h"
#include "param.h"
#include "param_pack.h"



////////////////////////////////////////////////////////////////////////////////
/// @begin reset_bump_selector
///
/// @brief reset bump selector best energy
///
/// @detailed
///
/// the bump selector is designed to include one lowest bump energy
/// rotamer for each aa-pos if (aoif) all rotamers fail the bump filter
///
/// this function signals the bump selector that a new seqpos+aa+aav
/// combination is being started in the rotamer creation loop, which
/// resets the selector process to the ground state
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors ctsa 10-2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
reset_bump_selector()
{
	using namespace bumpenergy_selecter;

	best_rot_bumpenergy = starting_rot_bumpenergy;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin iterate_bump_selector
///
/// @brief run bump filter for current rot
///
/// @detailed
///
/// the bump selector is designed to include  one lowest bump energy
/// rotamer for each aa-pos if (aoif) all rotamers fail the bump filter
///
/// this function decides whether the current rotamer should be deleted, or
/// if the previous best rotamer should be deleted and the current rotamer
/// should take its place
///
/// @param[in]   bumpenergy - in - bump energy of current rot
/// @param[out]   delete_current_rot - out - if true, delete current rot
/// @param[out]   delete_previous_rot - out - if true, delete last rot
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors ctsa 10-2003
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
iterate_bump_selector(
	float & bumpenergy,
	bool & delete_current_rot,
	bool & delete_previous_rot
)
{
	using namespace bumpenergy_selecter;
	using namespace param_pack;

	delete_current_rot = false;
	delete_previous_rot = false;

	static bool use_input_bump_cutoff( truefalseoption("pack_bump_cutoff") );
	static float input_bump_cutoff(
		use_input_bump_cutoff ? realafteroption("pack_bump_cutoff") : max_rot_bumpenergy );

	//// determine if the current rot should be erased
	////
	//// reasons:
	//// 1) it's not the first rot for this aa
	////   and this rot has an bump energy higher
	////   than both the bump threshold and the
	////   that of the best rotamer so far considered
	////
	//// ! note that this introduces an unnecessary
	////   extra rot w/ include current (?still does?)
	////
	if ( best_rot_bumpenergy != starting_rot_bumpenergy &&
		( bumpenergy > max_rot_bumpenergy ||
		(use_input_bump_cutoff && bumpenergy > input_bump_cutoff)) &&
		bumpenergy >= best_rot_bumpenergy)
	{
		delete_current_rot = true;
		return;
	}

	//// determine if the previous rot should be deleted and
	//// the current rotamer inserted in its place
	////
	//// reasons:
	////  1) the current rot is not the first rot for this aa
	////     and it has a lower bump energy than the previous
	////     rot and no rotamers have a bump energy below the
	////     bump threshold
	////  2) the current rot is not the first rot for this aa
	////     and the current rot is the first rotamer with a
	////     bump energy lower than the bump threshold
	////
	if ( best_rot_bumpenergy != starting_rot_bumpenergy &&
		bumpenergy < best_rot_bumpenergy &&
		(best_rot_bumpenergy > max_rot_bumpenergy ||
		(use_input_bump_cutoff && bumpenergy > input_bump_cutoff)))
	{
		delete_previous_rot = true;

		//// reset starting_rot_energy so that the current rot
		//// will be correctly re-accepted in the next iteration
		////
		reset_bump_selector();
		return;
	}

	//// update best bumpenergy
	////
	if ( bumpenergy < best_rot_bumpenergy ) {
		best_rot_bumpenergy = bumpenergy;
	}

}
