// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13164 $
//  $Date: 2007-02-28 16:51:28 -0500 (Wed, 28 Feb 2007) $
//  $Author: leaverfa $

#ifndef INCLUDED_PACK_MODULE_INTERFACE_FUNCTIONS_AND_CLASS_FORWARD_DECLARATIONS
#define INCLUDED_PACK_MODULE_INTERFACE_FUNCTIONS_AND_CLASS_FORWARD_DECLARATIONS

// Rosetta++ Forward Declarations
#include "InteractionGraphFWD.h"
#include "PackerTask_fwd.h"
#include "RotamerSetFWD.h"
#include "pose_fwd.h"


//ObjexxFCL
#include <ObjexxFCL/ObjexxFCL.hh>

//STL
#include <vector>

void
select_rotamer_set( std::string const & setting );


void
pack_rotamers(
	pose_ns::Pose & pose,
	PackerTask const & Task
);

void
pack_rotamers_setup(
	PackerTask const & Task,
	RotamerSet & rotamer_set,
	pack::InteractionGraphBase * & ig,
	pose_ns::Pose & pose,
	FArray1D_int & current_rot_index,
	FArray1D_float & ligenergy1b_old
);

void
pack_rotamers_run(
	PackerTask const & Task,
	RotamerSet const & rotamer_set,
	pack::InteractionGraphBase * ig,
	pose_ns::Pose & pose,
	FArray1D_int & current_rot_index,
	FArray1D_float & ligenergy1b_old,
	std::vector<int> rot_to_pack = std::vector<int> (0) // default empty vector
);


#endif

