// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 18466 $
//  $Date: 2007-11-16 23:05:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $

// Rosetta Headers
#include "aa_name_conversion.h"
#include "add_pser.h"
#include "design.h"
#include "dna.h"
#include "enzyme.h"
#include "files_paths.h"
#include "param.h"
#include "param_aa.h"
#include "param_pack.h"
#include "packer_weights.h"
#include "pH_ns.h"
#include "weights_manager.h"

// Utility Headers
#include <utility/basic_sys_util.hh>

// C++ Headers
#include <iostream>
#include <sstream>
#include <fstream>
#include <string>


// Using
using namespace param;
using namespace param_aa;
using namespace param_pack;


//jjh Constructor for PackerWeights
//JSS These are the PW_STANDARD weights, taken from param_pack.h and moved here.

void
Waa_initializer( FArray1D_float & Waa )
{
		Waa( aa_ala ) = -0.16;  //ALA,1
		Waa( aa_cys ) = -1.70;  //CYS,2
		Waa( aa_asp ) =  0.67;  //ASP,3
		Waa( aa_glu ) =  0.81;  //GLU,4
		Waa( aa_phe ) = -0.63;  //PHE,5
		Waa( aa_gly ) =  0.17;  //GLY,6
		Waa( aa_his ) = -0.56;  //HIS,7
		Waa( aa_ile ) = -0.24;  //ILE,8
		Waa( aa_lys ) =  0.65;  //LYS,9
		Waa( aa_leu ) =  0.10;  //LEU,10
		Waa( aa_met ) =  0.34;  //MET,11
		Waa( aa_asn ) =  0.89;  //ASN,12
		Waa( aa_pro ) = -0.02;  //PRO,13
		Waa( aa_gln ) =  0.97;  //GLN,14
		Waa( aa_arg ) =  0.98;  //ARG,15
		Waa( aa_ser ) =  0.37;  //SER,16
		Waa( aa_thr ) =  0.27;  //THR,17
		Waa( aa_val ) = -0.29;  //VAL,18
		Waa( aa_trp ) = -0.91;  //TRP,19
		Waa( aa_tyr ) = -0.51;  //TYR,20
														//KMa phospho_ser 2006-01
		if ( add_pser() ) {
			Waa( aa_sep ) = 0.37;  //SEP,21
		}
		if ( dna_enabled() || rna_enabled() ) {
			Waa( na_gua ) = 0.000;  // GUA
			Waa( na_ade ) = 0.000;  // ADE
			Waa( na_cyt ) = 0.000;  // CYT
			Waa( na_thy ) = 0.000;  // THY
			Waa( na_rgu ) = 0.000;  // rGUA
			Waa( na_rad ) = 0.000;  // rADE
			Waa( na_rcy ) = 0.000;  // rCYT
			Waa( na_ura ) = 0.000;  // rURA
		}
		if( get_enable_ligaa_flag() ){
			Waa( ligand_aa_vector[1] ) = 0.00;  //ligand aa
			Waa( ligand_aa_vector[2] ) = 0.00;
		}
}



PackerWeights::PackerWeights() :
	lock_(false),
	display_(false), // JSS for debugging, show when weights are changed.
	Waa_( param::MAX_AA(), Waa_initializer ),
	Wsol_( 0.65  ), // JSS numbers taken from param_pack; ideally these should be initialized by the weight manager. This is for compatiability while refactoring.
	Wdun_( 0.56 ),
	Wref_( 1.0 ), // weight for reference energy Waa
	WpH_( pH_ns::WpH ), // weight for protonation potential
	Wone_( 0.64 ),
	Wpair_( 0.49 ),
	Wplane_total_( 0.0 ),
	Watr_( 0.80 ),
	Wrep_( 0.44 ),
	Wintra_( 0.004 ), //chu downweighted 100 folds compared to Wrep
	Wh2o_( 1.00 ), // weight for total water energy
								 // jk note: Wh2o_intra is negative for more waters!
	Wh2o_intra_( 0.30 ), // it's slightly unfavorable to add a water
  Wh2o_lj_( 0.80 ), // weight for lj repulsive energy between water
										// and protein atoms
	Wh2o_hb_( -1.20 ), // peak value for water-mediated hbond energy

	Whbond_bb_( 1.17 ),
	Whbond_sc_( 1.10 ),
	Whbond_bb_sc_( 1.17 ),
	Whb_srbb_( 1.0 ), // moved from score weights for refactoring
	Whb_lrbb_( 1.0 ),
	Whb_sc_( 1.0 ),

	Wgb_elec_( 0.0 ),
	Wdna_bs_( 1.00 ),
	Wdna_bp_( 1.00 ),
  Wsasa_( 0.15 ),

	Wlig_rep_( 0.44 ),
	Wlig_atr_( 0.80 ),
	Wlig_h2o_( 1.00 ),
	Wlig_hb_( 1.30 ),
	Wlig_cou_( 0.25 ),
	Wlig_sol_( 0.65 ),
	Wlig_vir_( 3.00 ),
  Wele_( 0.35 ) // SJF distance-dependent dielectric weight. Parameterized on a set
//of 44 bound complexes to have a standard deviation of ~1.3 energy units in small_pert
{
	check_hbond_nonzero();
}

/////////////////////////////////////////////////////////////////////////////
//lin specify packer weight set from file
//
// file format:
//
// reading begins with "PACKER_WEIGHTS_SET::BEGIN" and end with "PACKER_WEIGHTS_SET::END"
//
// PACKER_WEIGHTS_SET::BEGIN
// # specify packer weights, default is standard weight set
//         packerweight_id: PW_STANDARD
// # assign value to each weight, whose name is defined in ""
// #                     weight_name  value
//         packer_weight: Wsol   1.0
//         packer_weight: Wdun   1.0
//         packer_weight: Watr   1.0
// PACKER_WEIGHTS_SET::END
void
PackerWeights::read_weight_file( std::string const & filename_in ) {

	using namespace files_paths;

	std::ifstream file;
	std::istringstream line_stream;
	std::string filename;

	if ( filename_in == "dummy" ) {
		std::cout << "PackerWeights::read_weight_file - please specify the weights file" << std::endl;
		exit( EXIT_FAILURE );
	} else if( filename_in == "default" ) {
		filename = start_path + "packer_weights_set";
	} else {
		filename = start_path + filename_in;
	}
	file.clear();
	file.open( filename.c_str() );

	if ( !file ) {
		std::cout << "PackerWeight::read_weight_file - unable to open file " << filename  << std::endl;
		exit( EXIT_FAILURE );
	} else {
		std::cout << "Packerweight::read_weight_file "<< filename  << std::endl;
	}

	std::string line, key(""), tag(""), weight_tag, packerweight_name;
	float  value;
	bool start( false);

	//lin retrieve the weight from current
	*this=pack_wts;

	while(file) {
		key = "";
		getline(file, line);
		line_stream.clear();
		line_stream.str(line);
		line_stream.seekg( std::ios_base::beg );
		line_stream >> key;

		if( key == "PACKER_WEIGHTS_SET::BEGIN" ) {
			start=true;
		}
		if( key == "PACKER_WEIGHTS_SET::END" ) {
			start=false;
			return;
		}

		if( !start ) continue;

		//lin read template information
		if( key == "packerweight_id:" ) {
			packerweights_id weight_id;
			line_stream >> packerweight_name;
			weight_id = packerweights_id_from_string( packerweight_name );
			std::cout<<"apply the packerweight_id "<<weight_id<<std::endl;
			*this = RetrieveWeights(weight_id);
		} else if( key == "packer_weight:" ) {
			line_stream >> tag ;
			if( tag != "Waa" ) {
			  line_stream >> value ;
			  std::cout<<"set "<<tag<<" from "<<GetWeight(tag)<<" to "<<value<<std::endl;
			  SetWeight( tag, value );
			} else {
				line_stream >> tag >> value;
				int index;
				num_from_res3( tag, index );
        std::cout<<"set Waa("<<tag<<") from "<<Waa(index)<<" to "<<value<<std::endl;
				set_Waa( index, value );
			}
		}
	}
	return;
}


void
PackerWeights::SetWeight( std::string const & name, float const & value)
{
  if( name ==  "Wsol" ) {             set_Wsol          ( value ) ;}
  else if( name == "Wdun" ) {         set_Wdun          ( value ) ;}
  else if( name == "Wref" ) {         set_Wref          ( value ) ;}
  else if( name == "WpH" ) {          set_WpH           ( value ) ;}
  else if( name == "Wone" ) {         set_Wone          ( value ) ;}
  else if( name == "Wpair" ) {        set_Wpair         ( value ) ;}
  else if( name == "Wplane_total" ) { set_Wplane_total  ( value ) ;}
  else if( name == "Watr" ) {         set_Watr          ( value ) ;}
  else if( name == "Wrep" ) {         set_Wrep          ( value ) ;}
  else if( name ==	"Wintra" ) {       set_Wintra        ( value ) ;}
  else if( name ==	"Wh2o" ) {         set_Wh2o          ( value ) ;}
  else if( name ==	"Wh2o_intra" ) {   set_Wh2o_intra    ( value ) ;}
  else if( name ==	"Wh2o_lj" ) {      set_Wh2o_lj       ( value ) ;}
  else if( name ==	"Wh2o_hb" ) {      set_Wh2o_hb       ( value ) ;}
  else if( name ==	"Whbond_bb" ) {    set_Whbond_bb     ( value ) ;}
  else if( name ==	"Whbond_sc" ) {    set_Whbond_sc     ( value ) ;}
  else if( name ==	"Whbond_bb_sc" ) { set_Whbond_bb_sc  ( value ) ;}
  else if( name ==	"Wgb_elec" ) {     set_Wgb_elec      ( value ) ;}
  else if( name ==	"Wdna_bs" ) {      set_Wdna_bs       ( value ) ;}
  else if( name ==	"Wdna_bp" ) {      set_Wdna_bp       ( value ) ;}
  else if( name ==	"Wlig_atr" ) {     set_Wlig_atr      ( value ) ;}
  else if( name ==	"Wlig_sol" ) {     set_Wlig_sol      ( value ) ;}
  else if( name ==	"Wlig_cou" ) {     set_Wlig_cou      ( value ) ;}
  else if( name ==	"Wlig_rep" ) {     set_Wlig_rep      ( value ) ;}
  else if( name ==	"Wlig_hb" ) {      set_Wlig_hb       ( value ) ;}
  else if( name ==	"Wlig_h2o" ) {     set_Wlig_h2o      ( value ) ;}
  else if( name ==	"Wlig_vir" ) {     set_Wlig_vir      ( value ) ;}
  else if( name ==  "Wsasa" ) {        set_Wsasa         ( value ) ;}
  else {
	std::cout<<"ERROR: PackerWeights::SetWeight wrong name"
		 <<name<<std::endl;
        utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
}

float
PackerWeights::GetWeight( std::string const & name )
{
  if( name == "Wsol" ) {        return Wsol          ( ); }
  else if( name == "Wdun" ) {        return Wdun          ( ); }
  else if( name == "Wref" ) {        return Wref          ( ); }
  else if( name == "WpH" ) {         return WpH           ( ); }
  else if( name == "Wone" ) {        return Wone          ( ); }
  else if( name == "Wpair" ) {       return Wpair         ( ); }
  else if( name == "Wplane_total" ) {return Wplane_total  ( ); }
  else if( name == "Watr" ) {        return Watr          ( ); }
  else if( name == "Wrep" ) {        return Wrep          ( ); }
  else if( name ==	"Wintra" ) {      return Wintra        ( ); }
  else if( name ==	"Wh2o" ) {        return Wh2o          ( ); }
  else if( name ==	"Wh2o_intra" ) {  return Wh2o_intra    ( ); }
  else if( name ==	"Wh2o_lj" ) {     return Wh2o_lj       ( ); }
  else if( name ==	"Wh2o_hb" ) {     return Wh2o_hb       ( ); }
  else if( name ==	"Whbond_bb" ) {   return Whbond_bb     ( ); }
  else if( name ==	"Whbond_sc" ) {   return Whbond_sc     ( ); }
  else if( name ==	"Whbond_bb_sc" ) {return Whbond_bb_sc  ( ); }
  else if( name ==	"Wgb_elec" ) {    return Wgb_elec      ( ); }
  else if( name ==	"Wdna_bs" ) {     return Wdna_bs       ( ); }
  else if( name ==	"Wdna_bp" ) {     return Wdna_bp       ( ); }
  else if( name ==	"Wlig_atr" ) {    return Wlig_atr      ( ); }
  else if( name ==	"Wlig_sol" ) {    return Wlig_sol      ( ); }
  else if( name ==	"Wlig_cou" ) {    return Wlig_cou      ( ); }
  else if( name ==	"Wlig_rep" ) {    return Wlig_rep      ( ); }
  else if( name ==	"Wlig_hb" ) {     return Wlig_hb       ( ); }
  else if( name ==	"Wlig_h2o" ) {    return Wlig_h2o      ( ); }
  else if( name ==	"Wlig_vir" ) {    return Wlig_vir      ( ); }
  else if( name ==  "Wsasa" ) {       return Wsasa         ( ); }
  else {
	 std::cout<<"ERROR: PackerWeights::GetWeight wrong name"
		<<name<<std::endl;
         utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
	return 0;
}

void // print the values of managed PackerWeights
PackerWeights::print() {
  std::cout <<
	" Wsol=" << Wsol_ <<
	" Wdun=" << Wdun_ <<
	" Wref=" << Wref_ <<
	" WpH=" << WpH_ <<
	" Wone=" << Wone_ <<
	" Wpair=" << Wpair_ <<
	" Wplane_total=" << Wplane_total_ << std::endl;
	std::cout <<   " Watr=" << Watr_ <<
	" Wrep=" << Wrep_ <<
	" Wintra=" << Wintra_ <<
	" Wh2o=" << Wh2o_ <<
	" Wh2o_intra=" << Wh2o_intra_ <<
	" Wh2o_lj=" << Wh2o_lj_ << std::endl;
	std::cout <<    " Wh2o_hb=" << Wh2o_hb_ <<
	" Whbond_bb=" << Whbond_bb_ <<
	" Whbond_sc=" << Whbond_sc_ <<
	" Whbond_bb_sc=" << Whbond_bb_sc_ <<
	" Whb_srbb=" << Whb_srbb_ <<
	" Whb_lrbb=" << Whb_lrbb_ <<
	" Whb_sc=" << Whb_sc_ <<std::endl;
	std::cout <<    " Wgb_elec=" << Wgb_elec_ <<
	" Wdna_bs=" << Wdna_bs_ <<
	" Wdna_bp=" << Wdna_bp_ <<
	" Wsasa=" << Wsasa_ <<std::endl;
	std::cout <<    " Wlig_rep=" << Wlig_rep_ <<
	" Wlig_atr=" << Wlig_atr_ <<
	" Wlig_h2o=" << Wlig_h2o_ <<
	" Wlig_hb=" << Wlig_hb_ <<
	" Wlig_cou=" << Wlig_cou_ <<
	" Wlig_sol=" << Wlig_sol_ <<
	" Wlig_vir=" << Wlig_vir_ << std::endl;
  std::cout << " Wele=" << Wele_ << std::endl;

	std::cout << "Waa:";
	for (int i = 1; i <= 20; i++) std::cout << " " << Waa_(i);
	std::cout << std::endl;
}

bool // display message if lock_ and/or display_ flags are set
PackerWeights::should_update(std::string const & message, float const oldval, float const newval) const {
	if (oldval == newval) { // if weight unchanged
		return false;
	}

  if (display_ || lock_) std::cout << "PackerWeight setting " << message << oldval << "->" << newval << std::endl;
  if (lock_) {
    std::cout << "ERROR: with lock set" << std::endl;
    utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }
	return true;
}

