// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19066 $
//  $Date: 2007-12-12 10:37:37 +0200 (Wed, 12 Dec 2007) $
//  $Author: yab $

#ifndef INCLUDED_pairenergy
#define INCLUDED_pairenergy


// Rosetta Headers
#include "geometric_solvation_ns.h"
#include "pdbstatistics_pack.h"
#include "score.h"
#include "param_aa.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/Fmath.hh>

// C++ Headers
#include <cassert>

////////////////////////////////////////////////////////////////////////////////
//\BEGIN pairenergy
//
//\BRIEF
//
//\FULL
//
//\PARAM - atom1 - in/out -
//\PARAM - atom2 - in/out -
//\PARAM - attype1 - in/out -
//\PARAM - attype2 - in/out -
//\PARAM - senergy1 - in/out -
//\PARAM - senergy2 - in/out -
//\PARAM - attract - in/out -
//\PARAM - repulse - in/out -
//\PARAM - d2 - in/out -
//
//\GLOBAL_READ
//
//\GLOBAL_WRITE
//
//\NOTES
//
//\COMMENTERS
//
//\END
////////////////////////////////////////////////////////////////////////////////
inline
void
pairenergy(
	FArray1Da_float atom1,
	FArray1Da_float atom2,
	int const attype1,
	int const attype2,
  float const chrg1,
  float const chrg2,
  float & senergy1,
  float & senergy2,
  float & attract,
  float & repulse,
  float & elecE,
  float & d2
)
{
	using namespace pdbstatistics_pack;

//bk  uses lookup table to find the pairwise energies between two atoms,
//bk  currently calculate lennard jones and solvation energy

//------------------------------------------------------------------------------

	d2 = (
	 square( atom1[ 0 ] - atom2[ 0 ] ) +
	 square( atom1[ 1 ] - atom2[ 1 ] ) +
	 square( atom1[ 2 ] - atom2[ 2 ] ) ); // [ i ] == ( i+1 )

	if ( d2 >= safe_max_dis2 || d2 == 0.0 ) {
		senergy1 = senergy2 = attract = repulse = elecE = 0.0;
		return;
	}

//ctsa
//ctsa  get bins and interpolation fraction
//ctsa
	float const d2_bin = d2 * fa_bins_per_A2;
	int const disbin1 = static_cast< int >( d2_bin ) + 1;
//	int const disbin2 = disbin1 + 1;
	float const frac = d2_bin - ( disbin1 - 1 );
  float e1;
  int l1, l2;

  if ( get_simple_elec() ) { // SJF elecE == -1000 is a signal that elecE should not be computed
    l1 = pCurrentEtable->elec_rep.index(disbin1,1,1);
    l2 = l1 + 1;
    elecE = chrg1 * chrg2;

    if ( elecE > 0 ) { // repulsion
      e1 = pCurrentEtable->elec_rep[ l1 ];
      elecE *= e1 + frac * ( pCurrentEtable->elec_rep[ l2 ] - e1);
    }
    else { // attraction
      e1 = pCurrentEtable->elec_atr[ l1 ];
      elecE *= e1 + frac * ( pCurrentEtable->elec_atr[ l2 ] - e1);
    }
  }
  else { elecE = 0.0; }

//ctsa
//ctsa  tables have been hacked so that if disbin2 = lastbin, all values = 0.
//ctsa

//Objexx: The following assumes arrays having the same dimensions
//Objexx: GCC 3.3.3 bug prevents use of these asserts
//	assert( ( equal_dimensions( ljatr, ljrep ) ) );
//	assert( ( equal_dimensions( ljatr, solv1 ) ) );
//	assert( ( equal_dimensions( ljatr, solv2 ) ) );

	l1 = pCurrentEtable->ljatr.index(disbin1,attype2,attype1); l2 = l1 + 1;
	// [ l1 ] == (disbin1,attype2,attype1) // [ l2 ] == (disbin2,attype2,attype1)

	e1 = pCurrentEtable->ljatr[ l1 ];
	attract  = e1 + frac * ( pCurrentEtable->ljatr[ l2 ] - e1 );

	e1 = pCurrentEtable->ljrep[ l1 ];
	repulse  = e1 + frac * ( pCurrentEtable->ljrep[ l2 ] - e1 );

	if ( geometric_sol::geometric_sol_flag && geometric_sol::lk_sol_weight <= 1e-20) {
		// jk solvation energy is computed elsewhere
		senergy1 = 0.0;
		senergy2 = 0.0;
		return;
	}

	e1 = pCurrentEtable->solv1[ l1 ];
	senergy1 = e1 + frac * ( pCurrentEtable->solv1[ l2 ] - e1 );

	e1 = pCurrentEtable->solv2[ l1 ];
	senergy2 = e1 + frac * ( pCurrentEtable->solv2[ l2 ] - e1 );

	if ( geometric_sol::geometric_sol_flag && geometric_sol::lk_sol_weight > 1e-20) {
		//rhiju even in geometric solvation mode, might want a little bit of the
		//rhiju the usual Lazaridis-Karplus solvation...
		//rhiju this is inelegant, and will make much more sense in mini-rosetta
		//rhiju where there will be no need to have geom_sol and regular solvation  all
		//rhiju mixed up.
		senergy1 *= geometric_sol::lk_sol_weight;
		senergy2 *= geometric_sol::lk_sol_weight;
	}

}


inline
void
get_lj_energy(
	float const d,
	int const attype1,
	int const attype2,
	float & attract,
	float & repulse
	){
	using namespace pdbstatistics_pack;
	float const d2_bin = d * d * fa_bins_per_A2;
	int const disbin1 = static_cast< int >( d2_bin ) + 1;
	float const frac = d2_bin - ( disbin1 - 1 );
	int const l1 = pCurrentEtable->ljatr.index(disbin1,attype2,attype1), l2 = l1 + 1;

	float e1 = pCurrentEtable->ljatr[ l1 ];
	attract  = e1 + frac * ( pCurrentEtable->ljatr[ l2 ] - e1 );

	e1 = pCurrentEtable->ljrep[ l1 ];
	repulse  = e1 + frac * ( pCurrentEtable->ljrep[ l2 ] - e1 );

}

#endif
