// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 11972 $
//  $Date: 2007-01-07 03:30:52 +0200 (Sun, 07 Jan 2007) $
//  $Author: johnk $

#ifndef INCLUDED_param
#define INCLUDED_param


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/Dimension.hh>


namespace param {


//-------------
// parameters
//-------------

extern int const MAX_START; // number of starting pdb structures
inline Dimension & n_frag_sizes() { static Dimension d; return d; }
inline Dimension & MAX_RES() { static Dimension d; return d; } // residues in protein chain
extern int const MAX_POS; // atoms/residue in position array
inline Dimension & MAX_NEIGH() { static Dimension d; return d; } // max frags/position for each length
inline Dimension & MAX_LEN() { static Dimension d; return d; } // max frag length
extern int const MAX_SEGMENTS; // foldable segments

extern float const init_phi;
extern float const init_psi;
extern float const init_omega;

inline Dimension & HETERO_ATOM_MAX() { static Dimension d; return d; } // maximum # of hetatoms


//-------------------------------
// full atom / packer parameters
//-------------------------------

inline Dimension & MAX_ATOM() { static Dimension d; return d; } // max atoms per amino acid in fullcoord array
inline Dimension & MAX_AA() { static Dimension d; return d; } // # of monomer types (amino plus nucleic acids)
inline Dimension & MAX_AA_PLUS() { static Dimension d; return d; } // # of monomer types (amino acids plus modified aa)//KMa phospho_ser
extern int const MAX_AUTH_AA; // # of genuine amino acids
inline Dimension & MAX_AA_VARIANTS() { static Dimension d; return d; } // some amino acids have more variants e.g. explicit water
extern int const MAX_CHI;
inline Dimension & MAX_ATOMTYPES() { static Dimension d; return d; }
extern Dimension MAX_REALTYPES;
extern int const MAXANGLES_PER_CHI;

// jk for symmetric design
inline Dimension & MAX_CLONES() { static Dimension d; return d; }

//ctsa linear-memory packer parameters:
extern short const MAX_PACK_NEIGHBORS;
 // max number of residues that can influence a rotamers pair-energy


//-------------------------------
// jumping params
//-------------------------------

extern int const max_jump;
extern int const max_fold_tree_edges;

//-------------------------------
// RNA params
//-------------------------------
extern int const MAX_TORSIONS;


// MAX_RES sizing function
void
MAX_RES_assign_res( int const nres );


} // param


#endif
