// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18466 $
//  $Date: 2007-11-16 23:05:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $


// Rosetta Headers
#include "param_pack.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

// Using
using namespace param;

namespace param_pack {


//bk weights and reference values for packer scoring function
//   reference values were last modified on 9/6/04 with the flags
//   ex1, ex2aro_only

//// ctsa protocl of fitting weights
//// /users/ctsa/devel/rosetta/add_solv_deriv/v13_ff/pack_db.info2.cvs
//------------------------------------------------------------------------------

//// ctsa -- new limits refer to all chi angles for any rotamer
////   instead of previous convention of max number of chi1&2 combinations
////   New limits were chosen to produce approximately the same number of
////   rotamers as previous chi1/2 limit using ex34.
////

//// ff flags
////
namespace packer_logical {
  bool dna_weights = { false }; // use dna weights
	bool soft_rep = { false }; // use jjh's soft repulsive potential
	bool soft_rep_design = { false }; // use jjh's soft repulsive potential
	bool use_packing_etables_always = { false }; // apply soft_rep in minimizations, designs, scoring, etc.
	bool gen_born = { false }; // use jjh's generalized born electrostatics
 	bool pH_rot   = { false }; // use rh's pH-sensitive rotamers
	bool small_radii = { false }; //reduce radii as specified in fullatom_setupa
	bool smooth_etable = { false };    // use smoothed etables
	bool reduce_templates = { false }; // use templates w/ H pos from reduce
	bool use_aw = { false };
	bool use_bw = { false };

}

PackerWeights pack_wts;

//// other packer parameters:
////
namespace packer_misc_parameters {
	float perc_limit_surface_default = { 0.95 };
	 // used to limit rotamers in get_rotamers
	float perc_limit_buried_default = { 0.98 }; // "
	int rot_limit_surface_default = { 24 }; // "
	int rot_limit_buried_default = { 30 }; // "
	float perc_limit_surface_large = { 0.99 };
	 // used to limit rotamers in get_rotamers
	float perc_limit_buried_large = { 0.99 }; // "
	int rot_limit_surface_large = { 45 }; // "
	int rot_limit_buried_large = { 45 }; // "
	float perc_limit_surface = { 0. }; // flag as uninitialized
	float perc_limit_buried = { 0. }; // "
	int rot_limit_surface = { -1 }; // "
	int rot_limit_buried = { -1 }; // "
	int rot_min_count = { 2 }; // "
	 //ctsa - min no. or rotamers regardless of probability
	float Wdisulf_dist_sc = { 1.0 };
	float Wdisulf_csang_sc = { 1.0 };
	float Wdisulf_dihedral_sc = { 1.0 };
	float Wdisulf_ca_dihedral_sc = { 0.0 };
	 // 0 b/c not understand the distribution yet
	float Wdisulf_cbs_dist_sc = { 0.0 };

	float Wlig_int_rep = { 0.44 };//kwk haven't fit the internal
	float Wlig_int_atr = { 0.80 };//kwk ligand energy weights
	float Wlig_int_solv = { 0.65};//kwk may need to add ligand
	float Wlig_int_hb = { 1.00 };//kwk ligand interactions weights
	float Wlig_int_dihed = { 1.00 };//kwk for multiligand energies
	float Wlig_int_cou = { 0.25 };
	//ctsa -  rotamer culling controls
	float max_rot_bumpenergy = { 5.0 };
	float min_extrachi_rot_prob = { 0.001 };
	 // eliminate ex rots with very small prob's
	float min_extrachi_sd = { 0.0 };
	 // eliminate ex rots with very small sd's

	float scale_inner_iterations_value( 1.0 );
	float scale_outer_iterations_value( 1.0 );
}


}
