// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15424 $
//  $Date: 2007-06-12 21:26:56 +0300 (Tue, 12 Jun 2007) $
//  $Author: bcorreia $


// Rosetta Headers
#include "pdbstatistics_pack.h"
#include "etable_class.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray5D.hh>

// Using
using namespace param;


namespace pdbstatistics_pack {


//bk pdbstatistic variables
//bk Paa        :probability of an amino acid
//bk Paa_n      :probability of an amino acid with a certain # of neighbors
//bk Paa_pp     :probability of an amino acid with a certain phi,psi
//bk paircorr   :pair term corrected for intrinsic preferences
//bk paircutoff :maximum distance two sidechains can have interaction energy
//bk Ppp        :probability of phi,psi
//bk ljatr      :lennard-jones attractive
//bk ljrep      :lennard-jones repulsive
//bk solv1      :solvation atom1
//bk solv2      :solvation atom2
//ctsa dsolv     :d(solvation atom1+solvation atom2)/d(r)

int const max_cb_neighbors = { 30 };
float fa_max_dis = { 5.5 }; // cutoff distance in A for lj vdw and lz solv
float fa_max_dis2 = { fa_max_dis * fa_max_dis };
int   fa_bins_per_A2 = { 20 }; // number of disbins in etable per A**2
int   etable_disbins =
	{ static_cast< int >( fa_max_dis2 * fa_bins_per_A2 ) + 1 };
	// MAX_ETABLE_DISBINS is set in options.cc: get_rosetta_options

//
//  if two heavy atoms are further apart than the sqrt(cutoff), then the
//  interactions between their hydrogens are not evaluated
//  this may be reset in options.cc: get_rosetta_options
//

float hydrogen_interaction_cutoff = { 4.6 * 4.6 };
float hydrogen_interaction_cutoff_long = { 7.5 * 7.5 }; // SJF for electrostatic interactions with hydrogens


int const max_phipsi_bins = { 36 };
int const max_neighbor_bins = { 14 };


	//// pair term parameters
	////
int const pair_score_cb_thresh = { 16 };
	//// cbk min separation between residues in sequence space
int const pair_score_min_sep = { 1 };
float const pair_score_binbase = { 3.0 };
float const pair_score_binrange = { 1.5 };


float const epsilon = { 0.0001 };
float safe_max_dis2 = { fa_max_dis2 - epsilon };
 // prevent 'trickling' over the disbin boundary


namespace pdbstatistics {
	Etable * pCurrentEtable = { NULL };
	FArray1D_float Paa( MAX_AA() );
	FArray2D_float Paa_n( MAX_AA(), max_neighbor_bins );
	FArray3D_float Paa_pp( max_phipsi_bins, max_phipsi_bins, MAX_AA() );
	FArray5D_float paircorr( MAX_AA(), MAX_AA(), 2, 2, 5 );
}


namespace avg_pdbstats {
	FArray2D_float atr_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float rep_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float sol_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float pair_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float one_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float hb_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float dun_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float intrares_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float tot_avg( MAX_AA(), max_cb_neighbors );
	FArray2D_float tlj_avg( MAX_AA(), max_cb_neighbors );
}


}
