// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15424 $
//  $Date: 2007-06-12 21:26:56 +0300 (Tue, 12 Jun 2007) $
//  $Author: bcorreia $

#ifndef INCLUDED_pdbstatistics_pack
#define INCLUDED_pdbstatistics_pack

// Rosetta Headers
#include "etable_class.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/Dimension.hh>

namespace pdbstatistics_pack {


//bk pdbstatistic variables
//bk Paa        :probability of an amino acid
//bk Paa_n      :probability of an amino acid with a certain # of neighbors
//bk Paa_pp     :probability of an amino acid with a certain phi,psi
//bk paircorr   :pair term corrected for intrinsic preferences
//bk paircutoff :maximum distance two sidechains can have interaction energy
//bk Ppp        :probability of phi,psi
//bk ljatr      :lennard-jones attractive
//bk ljrep      :lennard-jones repulsive
//bk solv1      :solvation atom1
//bk solv2      :solvation atom2
//ctsa dsolv     :d(solvation atom1+solvation atom2)/d(r)
//bk bb_hbW     :weights to use on backbone hbonds, derived from probability
//bk               :of a hbond given environment
//bk sc_hbW     :weights to use on sidechain hbonds, derived from probability
//bk               :of a hbond given environment

extern int const max_cb_neighbors;
extern float fa_max_dis; // cutoff distance in A for lj vdw and lz solv
extern float fa_max_dis2;
extern int   fa_bins_per_A2; // number of disbins in etable per A**2
extern int   etable_disbins;
extern int etable_elec_disbins;
inline Dimension & MAX_ETABLE_DISBINS() { //size for etable arrays
	static Dimension d; return d;
}

//
//  if two heavy atoms are further apart than the sqrt(cutoff), then the
//  interactions between their hydrogens are not evaluated
//
extern float hydrogen_interaction_cutoff;
extern float hydrogen_interaction_cutoff_long; // SJF for electrostatic potential

extern int const max_phipsi_bins;
extern int const max_neighbor_bins;


	//// pair term parameters
	////
extern int const pair_score_cb_thresh;
	//// cbk min separation between residues in sequence space
extern int const pair_score_min_sep;
extern float const pair_score_binbase;
extern float const pair_score_binrange;


extern float const epsilon;
extern float safe_max_dis2;
extern float safe_max_dis2_elec;
 // prevent 'trickling' over the disbin boundary

namespace pdbstatistics {
	extern Etable * pCurrentEtable;
	extern FArray1D_float Paa;
	extern FArray2D_float Paa_n;
	extern FArray3D_float Paa_pp;
	extern FArray5D_float paircorr;
}
using namespace pdbstatistics;


namespace avg_pdbstats {
	extern FArray2D_float atr_avg;
	extern FArray2D_float rep_avg;
	extern FArray2D_float sol_avg;
	extern FArray2D_float pair_avg;
	extern FArray2D_float one_avg;
	extern FArray2D_float hb_avg;
	extern FArray2D_float dun_avg;
	extern FArray2D_float intrares_avg;
	extern FArray2D_float tot_avg;
	extern FArray2D_float tlj_avg;
}
using namespace avg_pdbstats;


}


#endif
