// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $

#ifndef INCLUDED_pdbstats_ns
#define INCLUDED_pdbstats_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace pdbstats {


//bk variables specific to pdbstats mode


//bk flags

namespace pdbstats_flags {
	extern bool avg_dis;
	extern bool avg_E;
	extern bool hbond_stats;
	extern bool phipsichi;
	extern bool dun_rot;
	extern bool pdbstat_dotcutoff;
	extern bool rep_atm_pair;
	extern bool phe_planes;
	extern bool cation_pi;
	extern bool carbonyl_o;
	extern bool rama_stats;
	extern bool solv_stats;
	extern bool born_placeholder;
	extern bool sasa_stats;
	extern bool pair_energies;
	extern bool env_stats;
  extern bool arom_hbonds; // SJF
}
using namespace pdbstats_flags;


//bk parameters average energies

namespace pdb_stats {
	extern FArray2D_float atr_n;
	extern FArray2D_float rep_n;
	extern FArray2D_float tot_n;
	extern FArray2D_float sol_n;
	extern FArray2D_float pair_n;
	extern FArray2D_float dun_n;
	extern FArray2D_float one_n;
	extern FArray2D_float hb_n;
	extern FArray2D_int cnt_n;
	extern FArray2D_float tlj_n;
	extern FArray2D_float intrares_n;
}
using namespace pdb_stats;


//bk parameters for average distances between atom types

namespace pdb_stats_avgd {
	extern float const disbin_size;
	extern float const max_dis;
	extern int const ndisbins;
	extern FArray3D_int cnt_dis;
}
using namespace pdb_stats_avgd;


//bk parameters for hydrogen bonds

namespace pdb_stats_hbonding {
	extern int numNH;
	extern int numNH_nhb;
	extern int numNH_nwat;
	extern int numNH_nhb_nwat;
	extern int numO;
	extern int numO_nhb;
	extern int numO_nwat;
	extern int numO_nhb_nwat;
}
using namespace pdb_stats_hbonding;


//chu parameters for phi,psi,chi angles and the closest rotamers in Dunbrack

namespace pdb_stats_rotamers {
	extern FArray1D_float input_phi;
	extern FArray1D_float input_psi;
	extern FArray2D_float input_chi;
	extern FArray2D_int input_rot;
	extern FArray2D_float dun_closest_chi;
	extern FArray2D_float delta_chi;
}
using namespace pdb_stats_rotamers;


//chu parameters for clashing atom-pairs in pdbs

namespace pdb_stats_clashing {
	extern float const repE_atom_pair_cutoff;
	extern FArray2D_float repE_atom_pair;
	extern FArray2D_int repN_atom_pair;
}
using namespace pdb_stats_clashing;


//jjh parameters for determining optimal GB placeholders

namespace born_place {
	extern double rb_err_accum;
	extern FArray2D_float real_rb;
}
using namespace born_place;

//km parameters for calculate planes

//namespace pdb_stats_planes {
//  extern float plane_angle;
//  extern float plane_angle;
//  extern float plane_angle;
//  extern int pair_found;
//  extern FArray2D_float output_array;
//  extern int const number_angle_bins;
//  extern FArray1D_int angles_distances;
//}
//using namespace pdb_stats_planes;


//km parameters for lk calculations

namespace lk_solv_stats {
	extern int const number_bins;
	extern float const bin_size;
	extern FArray2D_int counted_nohb;
	extern FArray2D_int counted_hb;
	extern FArray2D_int counted_total;
}
using namespace lk_solv_stats;

//bq parameters for sasa stats

namespace sasa_stats_ns {
	extern FArray1D_float rsd_sasa;
	extern FArray1D_float rsd_sasa_fraction;
}
using namespace sasa_stats_ns;

//bq parameters for sasa stats
namespace env_stats_ns {
	extern FArray2D_float homolog_env;
	extern FArray3D_float homolog_pair;
	extern FArray2D_float pdb_pair;
	extern FArray1D_int nenvs;
	extern FArray2D_int npairs;
}
using namespace env_stats_ns;

// SJF
namespace arom_hbonds_stats {
  extern int delta_bins, theta_bins, phi_bins; // the number of count bins
  extern float delta_cutoff2; // distance cutoff between hyd and acceptor site squared
  extern float short_cutoff2; // dist threshold above short hbonds
  extern float vlong_cutoff2; // dist threshold below very long hbonds
  extern int theta_bins, phi_bins, delta_bins;

  extern FArray1D_float arom_arom_delta       ;
  extern FArray1D_float arom_arom_theta_short ;
  extern FArray1D_float arom_arom_phi_short   ;
  extern FArray1D_float arom_arom_theta_long  ;
  extern FArray1D_float arom_arom_phi_long    ;
  extern FArray1D_float arom_arom_theta_vlong ;
  extern FArray1D_float arom_arom_phi_vlong   ;


  extern FArray1D_float polar_arom_acceptor_delta       ; // arom is acceptor
  extern FArray1D_float polar_arom_acceptor_theta_short ;
  extern FArray1D_float polar_arom_acceptor_phi_short   ;
  extern FArray1D_float polar_arom_acceptor_theta_long  ;
  extern FArray1D_float polar_arom_acceptor_phi_long    ;
  extern FArray1D_float polar_arom_acceptor_theta_vlong ;
  extern FArray1D_float polar_arom_acceptor_phi_vlong   ;



  extern FArray1D_float polar_arom_donor_delta       ; // arom is donor
  extern FArray1D_float polar_arom_donor_theta_short ;
  extern FArray1D_float polar_arom_donor_phi_short   ;
  extern FArray1D_float polar_arom_donor_theta_long  ;
  extern FArray1D_float polar_arom_donor_phi_long    ;
  extern FArray1D_float polar_arom_donor_theta_vlong ;
  extern FArray1D_float polar_arom_donor_phi_vlong   ;

//backbone stats

  extern FArray1D_float bb_polar_arom_acceptor_delta       ; // arom is acceptor
  extern FArray1D_float bb_polar_arom_acceptor_theta_short ;
  extern FArray1D_float bb_polar_arom_acceptor_phi_short   ;
  extern FArray1D_float bb_polar_arom_acceptor_theta_long  ;
  extern FArray1D_float bb_polar_arom_acceptor_phi_long    ;
  extern FArray1D_float bb_polar_arom_acceptor_theta_vlong ;
  extern FArray1D_float bb_polar_arom_acceptor_phi_vlong   ;



  extern FArray1D_float bb_polar_arom_donor_delta       ; // arom is donor
  extern FArray1D_float bb_polar_arom_donor_theta_short ;
  extern FArray1D_float bb_polar_arom_donor_phi_short   ;
  extern FArray1D_float bb_polar_arom_donor_theta_long  ;
  extern FArray1D_float bb_polar_arom_donor_phi_long    ;
  extern FArray1D_float bb_polar_arom_donor_theta_vlong ;
  extern FArray1D_float bb_polar_arom_donor_phi_vlong   ;

}
using namespace arom_hbonds_stats;

}



#endif
