// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $


// Rosetta Headers
#include "pose_disulfides.h"
#include "pose_abinitio.h"
#include "after_opts.h"
#include "fold_abinitio.h"
#include "force_barcode.h"
#include "files_paths.h"
#include "fragments.h"
#include "fragments_pose.h"
#include "fragments_ns.h"
#include "homolog_distances.h"
#include "initialize.h"
#include "gunn.h"
#include "job_distributor.h" // for pose Monte_carlo checkpointing
#include "jumping_util.h"
#include "jumping_pairings.h"
#include "output_decoy.h"
#include "param.h"
#include "param_aa.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_rms.h"
#include "random_numbers.h"
#include "torsion_bbmove_trials.h"
#include "score.h"
#include "silent_input.h"
#include "ssblocks.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/string.functions.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyz.functions.hh>
#include <numeric/xyzVector.hh>
#include <numeric/xyzMatrix.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <fstream>

// BOINC
#ifdef BOINC
#include "boinc_rosetta_util.h"
#include "counters.h"
#include "trajectory.h"
#endif



///////////////////////////////////////////////////////////////////////////////
//
// this may perturb the setting of top_N_frags
//
// currently this routine is not doing convergence checking. It
// should be straightforward to add, I just haven't gotten around to it.
//
//
// assumes that the input structure is already filled without init_phi,init_psi
// frags. If not, I don't think any score0 moves will be done. Or maybe just
// one.
//
// also no trajectories, etc -- any of the monte_carlo bells and whistles
// and minimal status info
//

void
fold_abinitio(
	pose_ns::Pose & pose,
	bool const score_chainbreaks, // = true
	bool const choose_frag_ss_check, // = true
	float const cycle_factor,  // = 1.0
	float const init_temp // = 2.0
)
{
	using namespace pose_ns;

	int number3merfrags = get_number3merfrags(); // Default 200
	int number9merfrags = get_number9merfrags(); // Default 25

	float increasecycles = cycle_factor * get_increase_cycles();
	if (truefalseoption("benchmark")) increasecycles = 0.01;

	// params
	int const score0_cycles(  static_cast< int > (2000 * increasecycles) );
	int const score1_cycles(  static_cast< int > (2000 * increasecycles) );
	int const score25_cycles( static_cast< int > (2000 * increasecycles) );
	int const score3_cycles(  static_cast< int > (4000 * increasecycles) );
	//float const init_temp( 2.0 );
	choose_frag_set_top_N_frags(number9merfrags); // use top 25 frags

	// init score:
	Score_weight_map score0_weight_map( score0 );
	pose.score( score0_weight_map );

	// create Monte_carlo object that we will use throughout
	Monte_carlo mc( pose, score0_weight_map, init_temp );
	mc.set_autotemp( true, init_temp );

	std::cout << "starting fragment insertions..." << std::endl;

	decide_block_state();

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//  insert secondary structure, bump check only
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	if (!main_job_distributor::jd->skip_to_mc_checkpoint()) {
		int const size( 9 );

		for ( int j = 1; j <= score0_cycles; ++j ) {
			// don't mc checkpoint in this or any loop with a break statement
			choose_fragment_pose( pose, size, choose_frag_ss_check, true );
			mc.boltzmann( pose );
			if ( start_sim( pose ) ) break; // all swapped one or more times
			if ( j == score0_cycles ) {
				std::cout << "WARNING:: extended chain may still remain!" << std::endl;
			}
		}
		ai_stats( "score0", pose );
	}


// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    regular moves   w/bumps,secondary structure, light strand pairing
//    no rg or cbeta yet
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const size(9);

		Score_weight_map weight_map( score1 );
		if ( score_chainbreaks ) {
			weight_map.set_weight( CHAINBREAK, 0.25 );
			weight_map.set_weight( CHAINBREAK_OVERLAP, 0 );
		}
		mc.set_weight_map( weight_map );

		mc.set_temperature( init_temp );

		for ( int j = 1; j <= score1_cycles; ++j ) {
			if (mc.checkpoint( pose )) continue;
			choose_fragment_pose( pose, size, choose_frag_ss_check, true );
			mc.boltzmann( pose );
		}

		ai_stats( "score1", pose );
	}


// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   Add cbeta, rg (collapse chain)
//   alternate score2/score5 (high/low sheet weight)
//   convergence-checking enabled in monte_carlo
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const nloop = 1;
		int const nloop2 = 10;
		int const size = 9;

		mc.set_temperature( init_temp );

		for ( int jj = 1; jj <= nloop; ++jj ) {
			for ( int kk = 1; kk <= nloop2; ++kk ) {

				float chainbreak_weight(0.0);
				Score_weight_map weight_map; // empty

				if ( mod( kk, 2 ) == 0 || kk > 7 ) {
					// score2
					chainbreak_weight = jj*kk*0.25;
					weight_map.set_weights( score2 );
				} else {
					// score5
					chainbreak_weight = jj*kk*0.05;
					weight_map.set_weights( score5 );
				}

				if ( score_chainbreaks ) {
					weight_map.set_weight( CHAINBREAK, chainbreak_weight );
					weight_map.set_weight( CHAINBREAK_OVERLAP, 0.0 );
				}
				mc.set_weight_map( weight_map );
				pose = mc.low_pose();

				for ( int j = 1; j <= score25_cycles; ++j ) {
					if (mc.checkpoint( pose )) continue;
					choose_fragment_pose( pose, size, choose_frag_ss_check, true );
					mc.boltzmann( pose );
				}

				ai_stats( "score2/5", pose );
			}
		}
	}

// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//   regular moves/smooth moves
//   score 3 ->all centroid based terms on
// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	{
		int const nloop = 3;
		int const size = 3;
		float const gunn_cutoff( 7.0 );

		for ( int kk = 1; kk <= nloop; ++kk ) {
			Score_weight_map weight_map( score3 );
			if ( score_chainbreaks ) {
				weight_map.set_weight( CHAINBREAK, kk*0.5+2.5);
				weight_map.set_weight( CHAINBREAK_OVERLAP, kk );
			}
			mc.set_weight_map( weight_map );

			pose = mc.low_pose();

			mc.set_temperature( init_temp );

			if ( kk == 2 ) choose_frag_set_top_N_frags(number3merfrags);
			for ( int j = 1; j <= score3_cycles; ++j ) {
				if (mc.checkpoint( pose )) continue;
				if ( kk == 1 ) {
					choose_fragment_pose( pose, size, choose_frag_ss_check, true );
					mc.boltzmann( pose );
				} else {
					choose_fragment_gunn_pose( pose, size, gunn_cutoff );
					mc.boltzmann( pose );
				}
			}                  // loop j
			ai_stats( "score3", pose );
		}                     // kk
	}

	score_set_evaluate_all_terms(true);
	pose = mc.low_pose();
	pose.score( score4 ); // output-score
	score_set_evaluate_all_terms(false);
}

///////////////////////////////////////////////////////////////////////////////
bool
start_sim(
	pose_ns::Pose const & pose
)
{
	int const nres( pose.total_residue_for_scoring() );
	bool all_done( true );

	for ( int i=1; i<= nres; ++i ) {
		if ( pose.phi(i) == param::init_phi ||
				 pose.psi(i) == param::init_psi ) {
			all_done = false;
			break;
		}
	}
	return all_done;
}
///////////////////////////////////////////////////////////////////////////////
void
ai_stats(
	std::string const & tag,
	pose_ns::Pose const & pose
)
{

	std::cout << "ai_stats: " << tag << ' ' <<
		pose.get_0D_score( pose_ns::SCORE ) << std::endl;
}
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void
pose_ai( bool const jumping )
{
	using namespace silent_io;
	using namespace pose_ns;

	Pose start_pose;

	files_paths::mode_title = "Initializing";

	// New options to allow user to close chainbreaks or relax after jumping.
	bool close_chainbreaks_flag = truefalseoption("close_chainbreaks");
	bool const jump_relax_flag = truefalseoption("jump_relax");
	bool const apply_filters_flag = truefalseoption("apply_filters");
	bool const pose_relax_flag = truefalseoption("pose_relax");
	bool const pose_disulf = truefalseoption("pose_disulf");
	bool const pose_disulf_salvagejumps = truefalseoption("salvage_jumps");
	bool const homolog_jumps = truefalseoption("homolog_jumps");
	bool chainbreaks_closed(false);
	bool jump_accepted(true);
	if (jump_relax_flag)	close_chainbreaks_flag = true;
	if (jump_relax_flag || pose_relax_flag)
		initialize_query(); // Reads in bbdep, and all the stuff we need for full atom relax.


	// defines length, sequence of start_pose
	initialize_query_pose( start_pose );
	int num_fold_tree_cutpoint;

	// read native
	bool native_exists;
	Pose native_pose;
	FArray1D_int native_mapping; // from pose to native
	setup_homolog_native( start_pose, native_exists,native_pose,native_mapping );
	// fill in native namespace too, useful for BOINC and for jump_relax. And it never hurts?
	if (native_exists){
		pose_to_native(native_pose);
		start_pose.set_native_pose();
	}

	// read fragments -- after reading native in case MAX_RES increases!
	read_fragments( start_pose.total_residue() );
	//fragment_diversity(); // needed for crankshaft?

	// initialize torsion angles
	int const nres( start_pose.total_residue() );
	insert_init_frag( start_pose, 1, nres );

	// Allow user to input a starting conformation, if desired...
	if (truefalseoption("s"))
		pose_from_pdb( start_pose, stringafteroption("s"), false, false );

	barcode_initialize_start( nres );

	// open silent-output object
	//	Silent_out out( files_paths_pdb_out_prefix()+"jump.out" );
	Silent_out out( files_paths_pdb_out_prefix_nochain()+".out" ); //The most common name of an outfile....

	//Total hack by rhiju and rob to test some fun disulfide stuff.
	//bool const disulfide_jump_test = truefalseoption( "disulfide_jump_test" );
	//if (disulfide_jump_test) setup_disulfide_fold_tree( start_pose, native_pose );

	files_paths::mode_title = "Ab initio";
	if (jumping) files_paths::mode_title = "Ab initio (jumping)";

	// decoy loop
	int nstruct;
	intafteroption("nstruct",1000,nstruct);
	for ( int n=1; n<= nstruct; ++n ) {
		std::string tag( "S_"+string_of(n) );
		if ( !out.start_decoy(tag) ) continue; // already done or started
		if (jump_relax_flag) makepdb_decoy::makepdb_number = n; // If relaxing, output is done by output_decoy and needs to know the number.

		Pose pose;
		pose = start_pose;

		// setup jumps
		barcode_initialize_decoy(); // Chooses a barcode.
		if (jumping) pose_from_random_pairings( pose );
		if (homolog_jumps) {
			// for some reason the call to pose_from_pdb in get_homolog_jumps is
			// obliterating both the fragments and files_paths::protein_chain.
			// Until I refactor the way that Rosetta deals with fragments,
			// the following code is a hack to deal with that behavior.
			char old_chain = files_paths::protein_chain;
			get_homolog_jumps( pose );
			files_paths::protein_chain = old_chain;
			read_fragments( start_pose.total_residue() );
		}

		// sort of a filter... check if any jumps were defined.
		pose.fold_tree().get_fold_tree_cutpoint( num_fold_tree_cutpoint );
		if (jumping   &&  num_fold_tree_cutpoint < 1) tag[0]='F'; // flag that something went awry

		// fold
		if ( pose_disulf ) {
			if ( pose_disulf_salvagejumps ) {
				fold_salvagejumpmoves_posedisulf_abinitio( pose );
			} else {
				fold_posedisulf_abinitio( pose );
			}
		} else {
			fold_abinitio( pose );
		}


		// skip closing chainbreaks to reach last pose Monte_carlo checkpoint
		// use the job distributor since we don't have a Monte_carlo object
		if (!main_job_distributor::jd->skip_to_mc_checkpoint()) {
			// close chainbreaks if desired
			if (close_chainbreaks_flag){
				chainbreaks_closed = close_chainbreaks_after_jumping(pose);
				if (!chainbreaks_closed) tag[0]='F'; //flag that something went awry
			}

			// apply filters?
			if (apply_filters_flag){
				jump_accepted = apply_filters_after_jumping(pose);
				if (!jump_accepted) tag[0]='F';
			}
		} else {
			// assume chain breaks were closed for last checkpoint
			std::cout << "Skipping close chainbreaks because of previous checkpoint!!" << std::endl;
			chainbreaks_closed = true;
		}

		// relax if desired.
		if (jump_relax_flag && chainbreaks_closed && !pose_relax_flag) relax_and_output_after_jumping(pose);
		if (pose_relax_flag){
			if (native_exists){
				calc_homolog_rms( pose, native_pose, native_mapping );
				pose.set_extra_score("INIT_RMSD", pose.get_0D_score( RMSD ));
			}
			pose_relax_after_jumping(pose);
		}

		// output
		if ( native_exists ) {
			calc_homolog_rms( pose, native_pose, native_mapping );
		}
		if (!jump_relax_flag || !chainbreaks_closed || pose_relax_flag) out.write( tag, pose );

		main_job_distributor::jd->reset_mc_checkpoint(); // reset monte carlo checkpoint counter

#ifdef BOINC
		out.append_to_list( tag ); // mark as done
		store_low_info(); // for trajectory plotting.
		clear_trajectory();
		counters::monte_carlo_ints::ntrials = 0;
		int farlx_stage = 0;
		bool ready_for_boinc_end = boinc_checkpoint_in_main_loop(n, n, nstruct, farlx_stage);
		if (ready_for_boinc_end)	return; // Go back to main, which will then go to BOINC_END and shut off BOINC.
#endif

	}
}






///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
