// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18466 $
//  $Date: 2007-11-16 23:05:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $

#ifndef INCLUDED_pose_backrub
#define INCLUDED_pose_backrub

// Rosetta Headers
#include "DesignMap.h"
#include "pose_movie.h"
#include "pose_rotamer_controller.h"
#include <IntervalSet.fwd.hh>

// C++ Headers
#include <fstream>

// Utility Headers
#include <utility/vector0.hh>
#include <utility/vector1.hh>

void
detailed_balance_test();

void
pose_backrub_test();

void
pose_backrub_mc(
	int const n_struct,
	int const nstart
);

void
pose_read_resfile(
	pose_ns::Pose & pose,
	std::string resfile
);

utility::vector0<int>
pose_pick_free_sc(
	pose_ns::Pose const & pose,
	utility::vector1<int> const & nrotpos,
	int const start_res,
	int const end_res,
	int max_res,
	float const prob_zero
);

utility::vector1<bool>
pose_chain_breaks(
	pose_ns::Pose const & pose,
	float const chain_break_cutoff = 4.0
);

void
coord_cst_residue(
	cst_set_ns::Cst_set & cstset,
	pose_ns::Pose const & src,
	int const src_pos,
	pose_ns::Pose const & dest,
	int const dest_pos,
	int const level
);

utility::vector0<utility::vector0<int> >
pose_backrub_allowed_moves(
	pose_ns::Pose & pose,
	const int max_res = 3
);

void backrub_rot_pose(
	pose_ns::Pose & pose,
	int const start,
	int const end,
	float const angle
);

void backrub_rot_Eposition(
	FArray3D_float & Eposition,
	int const start,
	int const end,
	float const angle
);

void backrub_rot_full_coord(
	FArray3D_float & full_coord,
	FArray1D_int const & aa,
	FArray1D_int const & aav,
	int const start,
	int const end,
	float const angle
);

void set_ca_angle_pose(
	pose_ns::Pose & pose,
	int const res,
	float const angle
);

void set_ca_angle_full_coord(
	FArray3D_float & full_coord,
	FArray1D_int const & aa,
	FArray1D_int const & aav,
	int const res,
	int const totres,
	float const angle
);

void copy_full_coord_Eposition(
	FArray3D_float const & full_coord,
	FArray3D_float & Eposition,
	int const start,
	int const end
);

void replace_cbha_pose(
	pose_ns::Pose & pose
);

void replace_cb(
	int const aa,
	int const aav,
	FArray2Da_float res_coor
);

void replace_ha(
	int const aa,
	int const aav,
	FArray2Da_float res_coor
);

void place_atom_polar(
	FArray1Da_float a1,
	FArray1Da_float a2,
	FArray1Da_float a3,
	FArray1Da_float a4,
	float len,
	float theta,
	float phi
);

void
getrot_parallel_plane(
	FArray1Da_float a1,
	FArray1Da_float b1,
	FArray1Da_float b2,
	FArray1Da_float b3,
	float & rot_ang, // rotate angle
	FArray2Da_float mat,
	FArray1Da_float vec
);

float get_chi_angle(
	int const aa,
	int const aav,
	FArray2Da_float coor,
	int ichi
);

float backrub_get_angle(
	pose_ns::Pose const & pose1,
	pose_ns::Pose const & pose2,
	int const start,
	int const end
);

bool assert_bond_length_res(
	int const aa,
	int const aav,
	FArray2Da_float coor
);

float
backrub_dE_dtheta(
	FArray1Da_float const ca0,
	FArray1Da_float const nc1,
	FArray1Da_float const ca1,
	FArray1Da_float const cn1,
	float const Ktheta,
	float const Theta0
);

float
backrub_dE_dtheta_Eposition(
	FArray3D_float const & Eposition,
	FArray1D_int const & aa,
	FArray1D_int const & aav,
	int const start,
	int const end
);

namespace numeric {

template< typename T >
inline
void
planar_angle(
	xyzVector< T > const & p1,
	xyzVector< T > const & p2,
	xyzVector< T > const & p3,
	T & angle
);

template< typename T >
inline
T
planar_angle(
	xyzVector< T > const & p1,
	xyzVector< T > const & p2,
	xyzVector< T > const & p3
);

}

template< typename T >
void
center_angle_radians( T & ang );

double
backrub_select_angle(
	pose_ns::Pose const & pose,
	int const res1,
	int const res2,
	double const alpha_min,
	double const alpha_max,
	bool const res_dependent,
	double const angle_disp,
	bool const jacobian
);

void
backrub_tau_intervals(
	pose_ns::Pose const & pose,
	int const res,
	int const res_ref,
	double const alpha_min,
	double const alpha_max,
	IntervalSet<double> & tau_intervals
);

void
backrub_dangle_dtau_constants(
	pose_ns::Pose const & pose,
	int const res,
	int const res_ref,
	utility::vector0<double> & constants
);

void
backrub_dangle_dtau(
	utility::vector0<double> const & constants,
	double const tau,
	double & dalpha_dtau,
	double & dphi_dtau,
	double & dpsi_dtau,
	double & alpha,
	double & phi,
	double & psi
);

double
backrub_select_angle(
	pose_ns::Pose const & pose,
	int const res1,
	int const res2,
	double const angle_min,
	double const angle_max,
	bool const jacobian
);

void
backrub_dD_write(
	pose_ns::Pose const & pose,
	int res1,
	int res2,
	std::ostream & stream
);

void
backrub_dD_debug(
	pose_ns::Pose const & pose,
	int const res1,
	int const res2,
	double const tau,
	std::ostream & stream
);

namespace backrub_ns {

class Backrub_eval {

private:

	pose_ns::Pose *pose_;
	utility::vector0<int> residue_pairs_;
	utility::vector0<int> residues_;
	bool use_full_coord_;
	FArray3D_float Eposition_;
	FArray3D_float full_coord_;
	std::ostream *func_trace_;

	void
	update_residues();

	void
	update_Eposition(
		FArray1DB_float & values
	);

	void
	update_full_coord(
		FArray1DB_float & values
	);

public:

	Backrub_eval(
		pose_ns::Pose * pose
	);

	Backrub_eval(
		pose_ns::Pose * pose,
		utility::vector0<int> residue_pairs
	);

	void
	push_back(
		int start,
		int end
	);

	utility::vector0<int>
	residue_pairs();

	utility::vector0<int>
	residues();

	bool
	use_full_coord();

	void
	set_use_full_coord(
		bool use_full_coord
	);

	void
	set_func_trace(
		std::ostream & func_trace
	);

	void
	reset_func_trace();

	float
	func(
		FArray1DB_float & values,
		bool & gfrag
	);

	void
	dfunc(
		FArray1DB_float & values,
		FArray1DB_float & derivatives,
		int n
	);

	void
	minimize(
		FArray1DB_float & values,
		std::string const & min_type
	);
};

} // end backrub_ns namespace

void
minimize_set_backrub_eval(
	backrub_ns::Backrub_eval & backrub_eval
);

backrub_ns::Backrub_eval &
minimize_get_backrub_eval();

void
minimize_reset_backrub_eval();

float
minimize_func_backrub_eval(
	FArray1DB_float & values,
	bool & gfrag
);

void
minimize_dfunc_backrub_eval(
	FArray1DB_float & values,
	FArray1DB_float & derivatives,
	int n
);

#endif
