// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 23432 $
//  $Date: 2008-06-24 16:25:52 +0300 (Tue, 24 Jun 2008) $
//  $Author: yab $



// Rosetta Headers
#include "pose_design.h"
#include "after_opts.h"
#include "current_pose.h"
#include "design.h"
#include "enzyme_ns.h"
#include "fullatom.h"
#include "fullatom_setup.h"
#include "fragment_class.h"
#include "fragments.h"
#include "fragments_pose.h"
#include "gl_graphics.h"
#include "jumping_util.h"
#include "map_sequence.h"
#include "minimize.h"
#include "misc.h"
#include "monte_carlo.h"
#include "nblist.h"
#include "pack_fwd.h"
#include "PackerTask.h"
#include "param.h"
#include "param_aa.h"
#include "param_pack.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_rms.h"
#include "random_numbers.h"
#include "recover.h"
#include "score.h"
#include "silent_input.h"
#include "vall_data.h"
#include "weights_manager.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/string.functions.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyz.functions.hh>
#include <numeric/xyzVector.hh>
#include <numeric/xyzMatrix.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <fstream>


#ifdef GL_GRAPHICS
#include "gl_graphics.h"
#endif

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// some default settings for packing, minimizing
void
pose_setup_packer()
{
	using namespace param;

	initialize_fullatom(); //ensure that this has been done

	if ( truefalseoption("pdebug" ) ) {
		set_rot_limit( 5, 3 );
		set_perc_limit( 0.9999, 0.9999 );
		design::active_rotamer_options.set_ex12( false, false, false );
	} else {
		set_rot_limit( 45, 27 );
		set_perc_limit( 0.9999, 0.9999 );
		design::active_rotamer_options.set_ex12( true, true, true ); // ex1, ex2, ex1_aro
	}

}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// some default settings for packing, minimizing
void
pose_setup_minimizer( float const tolerance )
{
	using namespace param;

	minimize_exclude_sstype( false, false );
	minimize_set_vary_phipsi( true );
	minimize_set_vary_chi( true );
	minimize_set_vary_omega( false ); // NOT omega, but everything else
	minimize_set_vary_rb_angle( true );
	minimize_set_vary_rb_trans( true );
	minimize_set_tolerance( tolerance );
	minimize_set_local_min( false, 0 ); // all non-move-list rsds minimized
	pose_set_use_nblist(true);
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void
set_rot_limit( const int buried, const int surface ) {
	assert ( buried >= surface );
	param_pack::rot_limit_buried = buried;
	param_pack::rot_limit_surface = surface;
}

///////////////////////////////////////////////////////////////////////////////
void
set_perc_limit( const float buried, const float surface ) {
	assert ( buried >= surface );
	param_pack::perc_limit_buried = buried;
	param_pack::perc_limit_surface = surface;
}


//Namespace
namespace pose_ns {

	/////////////////////////////////////////////////////////////////////////////
	//lin pose design routines
	void
	Pose::redesign(
				 FArray2D_bool const & design_matrix_in,
				 PackerWeights design_weight ){
		//param_pack::pack_wts.print();
    PackerWeights save_pack_wts;
		save_pack_wts = param_pack::pack_wts;
		param_pack::pack_wts = design_weight;
		//param_pack::pack_wts.print();
		redesign( design_matrix_in);
		param_pack::pack_wts = save_pack_wts;
    //param_pack::pack_wts.print();
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Pose::redesign( FArray2D_bool const & design_matrix_in,
									bool const include_current /* = true */){

		using namespace design;
		using namespace param_pack;

		// copy design matrix to global, setup allow_repack
		static FArray1D_bool allow_repack_local( param::MAX_RES(), false );

		int const n_aa( design_matrix_in.size1() );
		assert( int(design_matrix_in.size2()) >= total_residue_ );

		use_design_matrix = true ;

		for ( int i=1; i<= total_residue_; ++i ) {
			for ( int aa=1; aa<= n_aa; ++aa ) {
				design_matrix( aa, i ) = design_matrix_in( aa, i ) ;
				if ( design_matrix_in(aa,i) ) {
					//std::cout<<"DBUG: "<<aa<<" "<<i<<"\n";
					allow_repack_local( i ) = true;
				}
			}
		}

		// set the pose as the current pose
		pack_set_current_pose( *this );

		//lin call pack_rotamers
		std::string packmode( "design" );
		bool make_output_file( false );

		//Create PackerTask and setup values before pass into pack_rotamers
		PackerTask Task( *this );
		Task.set_task( packmode, make_output_file, allow_repack_local,include_current );
		Task.setup_residues_to_vary();
// 		if( enzyme::ligand_weight_scale != 1.0f ) {
// 			for( int seqpos1=1; seqpos1<=total_residue_;seqpos1++ ) {
// 				if( !param_aa::is_ligand( res(seqpos1) ) ) continue;
// 				for( int seqpos2=1; seqpos2<=total_residue_;seqpos2++ ) {
// 					if( param_aa::is_ligand( res(seqpos2) ) ) continue;
// 					Task.set_residue_weight( enzyme::ligand_weight_scale, seqpos1, seqpos2 );
// 				}
// 			}
// 		}

		pack_rotamers(*this, Task );
		//pack_wts.print();//debug

		pack_reset_current_pose();

//		for ( int i=1; i<= total_residue_; ++i ) {
//			if( allow_repack_local(i) ) {
//				copy_sidechain( i, misc::res(i), misc::res_variant(i),
//												misc::full_coord(1,1,i) );
//			}
//		}

		update_sequence();
		domain_map_updated = false;

		score_data.after_refolding();

	}
}



