// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.13 $
//  $Date: 2005/05/18 07:35:25 $
//  $Author: mentzer $

#ifndef INCLUDED_pose_docking_flexible
#define INCLUDED_pose_docking_flexible

//Rosetta headers
#include "loop_class.h"
#include "pose.h"

void
pose_docking_loops_protocol(
	pose_ns::Pose & pose,
	//int const rb_cutpoint,
	pose_ns::Loops & loops
);


void
pose_docking_loops_protocol_2(
	pose_ns::Pose & pose,
	pose_ns::Loops & loops
);


void
pose_docking_setup_dock_loop_tree(
	pose_ns::Pose & pose,
	int const nres,
	int const rb_cutpoint,
	const pose_ns::Loops & loops
);


void
pose_docking_calc_interf_energy(
	pose_ns::Pose & pose,
	const pose_ns::Loops & loops
);


void
pose_update_docking_query(
	pose_ns::Pose const & pose,
	int const dock_jump
);

void
pose_docking_hinge_protocol(
	pose_ns::Pose & pose
);

void
pose_docking_hinge_mcm_trial(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map
);

float
pose_docking_hinge_move_trial(
	pose_ns::Pose & pose,
	int const cycles,
	const pose_ns::Score_weight_map & wt_map,
	float trans_mag,
	float rot_mag
);

void
pose_docking_perturb_hinge_region(
	pose_ns::Pose & pose,
	int const hinge_start,
	int const hinge_end,
	float const helix_size,
	float const strand_size,
	float const other_size
);

void
pose_docking_minimize_loop_protocol(
	pose_ns::Pose & pose,
	pose_ns::Loops & loops
);

#endif
