// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

///jjh Code for loop design protocols

#include "after_opts.h"
#include "design.h"
#include "dna.h"
#include "dna_classes.h"
#include "are_they_neighbors.h"
#include "files_paths.h"
#include "loops.h"
#include "pose_jjh_loops.h"
#include "dock_structure.h"
#include "misc.h"
#include "refold.h"
#include "refold_ns.h"
#include "loop_relax.h"
#include "loops_ns.h"
#include "pack.h"
#include "param.h"
#include "param_aa.h"
#include "PackerTask.h"
#include "fold_loops.h"
#include "input_pdb.h"
#include "dna_motifs.h"
#include "fullatom.h"
#include "fullatom_energies.h"
#include "fullatom_energy.h"
#include "fragments_pose.h"
#include "maps.h"
#include "monte_carlo.h"
#include "constraints.h"
#include "minimize.h"
#include "minimize_ns.h"
#include "nblist.h"
#include "score.h"
#include "recover.h"
#include "param_pack.h"
#include "water.h"
#include "orient_rms.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_design.h"
#include "pose_dna.h"
#include "pose_loops.h"
#include "loop_class.h"
#include "pose_rms.h"
#include "prof.h"
#include "fold_tree.h"
#include "jumping_loops.h"
#include "pose_constraints.h"
#include "hbonds.h"
#include "util_vector.h"

// ObjexxFCL Headers
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>
#include <ObjexxFCL/FArray1D.hh>


#include <iostream>
#include <string>
#include <map>

float loop_energy(0.0);

int max_motif_depth( 99 );

///************ START NEW POSE-BASED PROTOCOL ***************


void
dna_jjh_loops(
)
{
	assert( truefalseoption("enable_dna" ) &&
					truefalseoption("dna_weights" ) &&
					truefalseoption("gen_born") );

	std::string data( stringafteroption("s").c_str() );
	pose_ns::Pose pose;
	bool const ok( pose_from_pdb( pose, data, true, false, true ) );

	if( !ok ) {
		std::cout << "PDB reader says not ok!" << std::endl;
		exit(0);
	}

	LoopDesign::DNAMotifLoopDesign dna_loop_design;
	dna_loop_design.do_design( pose );

	exit(0);

}

///************  END  NEW POSE-BASED PROTOCOL ***************

using namespace LoopDesign;

//namespace LoopDesign {

	///jjh The skeleton code for a loop design protocol

  void
	LoopDesignProtocol::do_design(
	pose_ns::Pose & pose
	)
	{

		using namespace loops_ns;

		///jjh Perform problem-specific initialization
		do_initialize( pose );

		do_loop_shooting( pose );

		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}


//*****************************************
///jjh Below here is the DNA Motif subclass
//*****************************************


  void
	DNAMotifLoopDesign::do_initialize( pose_ns::Pose & pose ) {

		using namespace param;
		using namespace param_pack;

		if( initialized == true ) {
			return;
		}

		initialized = true;

		///jjh Check to see if a search depth maximum is
		///jjh requested
		intafteroption( "max_recursion_depth", 99, max_recursion_depth );

		std::cout << "Using maximum recursion depth value of " <<
				max_recursion_depth << std::endl;

		int nres( pose.total_residue() );

		///jjh Get basepair partners
		DnaSeqInfo base_pairs;
		find_basepairs( pose, base_pairs );

		set_basepairs_from_pair_vector( pose, base_pairs );

		std::vector<int> positions_to_shave;
		std::string motif_region_file;
		stringafteroption("motif_regions", "dummy", motif_region_file);
		///jjh Read in the bases on which to build inverse rotamers, etc.
		ReadDNARegionsFile( motif_region_file, loop_region, omit_regions,
			target_regions, positions_to_shave );

		///jjh Identify neighboring (second shell) positions
		do_find_second_shell( pose );

		///jjh Set up the fold tree
		FArray1D_bool excludes ( nres, false );
		int ipos = loop_region.start() - 3;
		int epos = loop_region.end() + 3;
		if( ipos < 1 ) ipos = 1;
		if( epos > nres ) epos = nres;
		std::cout << "Excluding from " << ipos << " to " << epos << std::endl;
		for( int lpos = ipos ; lpos <= epos ; ++ lpos ) {
			excludes( lpos ) = true;
		}
		for( int lpos = 0, elpos = second_shell_positions.size() ;
					lpos < elpos ; ++lpos ) {
			int bbpos( second_shell_positions[lpos] );
			excludes( bbpos ) = true;
			if( bbpos > 1 ) excludes( bbpos - 1 ) = true;
			if( bbpos < nres ) excludes( bbpos + 1 ) = true;
		}

		setup_simple_dna_fold_tree( pose, excludes );
		saved_fold_tree =  pose.fold_tree();

		///jjh Build the library of inverse rotamers and return as
		///jjh a std::vector of free-floating rotamers
		inv_rot_lib = GetDNAMotifRotamerLibrary( loop_region, omit_regions,
			target_regions, pose );

		///jjh Figure out how close the inverse rotamers are to the native loop
		///jjh deletes rotamers w/ rmsd >= A value defined global to the file
		///jjh dna_motifs.cc.
		find_closest_to_dna_motif_inv_rotamers( pose, inv_rot_lib, loop_region );

		///jjh Mutate the loop region to glycine
		std::vector< int > keep_the_same;
		keep_the_same.push_back( param_aa::aa_gly );
		keep_the_same.push_back( param_aa::aa_pro );
		mutate_region_to_aa( pose, loop_region, param_aa::aa_ala, keep_the_same );

		///jjh Mutate vector to alanine
///jjh Skip this for a try, since I'm getting inv. rotamers that
///jjh interfere with pre-existing, good contacts.
//		mutate_vector_to_aa( pose, second_shell_positions, param_aa::aa_ala);
///jjh Still want to mutate the selected 'shave' positions
		mutate_vector_to_aa( pose, positions_to_shave, param_aa::aa_ala);

		///jjh GB is slow - turn it off until design
		enable_gb( false );

		return;
	}

	void
	DNAMotifLoopDesign::do_loop_shooting(
		pose_ns::Pose & pose
	)
	{

		FArray1D_int setpos( pose.total_residue(), -1 );
		LoopState ls(  get_loop_state_from_pose( pose ) );

		int const starting_depth( 1 );
		try_for_more( pose, setpos, ls, starting_depth );

	}

//Utility Headers
#include <utility/basic_sys_util.hh>

///////////////////////////////////////////////////////////////////////////////
/// START RECURSIVE LOOP PLACEMENT  ///////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

  void
	DNAMotifLoopDesign::try_for_more(
		pose_ns::Pose & pose,
		FArray1D_int setpos,
		LoopState ls,
		int depth
	)
	{
		static int loop_uniq_id(0);
		FArray1D_int closest_pos( inv_rot_lib.size(), -1 );
		FArray1D_float closest_rmsd( inv_rot_lib.size(), 9999.99 );
		FArray1D_float closest_ca( inv_rot_lib.size(), 9999.99 );

		float const Motif_Cutoff_rmsd( DNA_Motifs::Motifs_close_enough );
		float const Motif_Cutoff_ca( DNA_Motifs::Motifs_close_enough );
		int const Min_Try( 3 );

		int const nres( pose.total_residue() );

		if( depth <= max_recursion_depth ) {	// If we are at max depth, just output

			for( int iset = 1 ; iset <= nres ; ++iset ) {
				if( setpos( iset ) != -1 ) {
					std::cout << "Position " << iset << " already set" << std::endl;
				}
			}

			for( int imot = 0, emot = inv_rot_lib.size() ; imot < emot ; imot++ ) {
				pose.set_fold_tree( saved_fold_tree );
				copy_loop_state_to_pose( pose, ls );
				if( imot == 0 ) { ///jjh Only need to gather motif/loop distances once
					get_closest_pos_and_rmsd( pose, closest_pos, closest_rmsd, closest_ca );
				}
				DNA_Motifs::RegionPair free_window =
								check_free_length( pose.total_residue(), closest_pos(imot+1), setpos );

				if( ( closest_pos(imot+1) > loop_region.start() ) &&
						( closest_pos(imot+1) < loop_region.end() ) &&
						( closest_rmsd(imot+1) < Motif_Cutoff_rmsd ) &&
						( closest_ca(imot+1) < Motif_Cutoff_ca ) &&
						( free_window.size() >= Min_Try ) &&
						( setpos( closest_pos(imot+1) ) == -1 ) &&
						( is_clash_free( pose, closest_pos(imot+1), setpos,
								inv_rot_lib[imot].aa(),
								inv_rot_lib[imot].aav(), inv_rot_lib[imot].get_rotcoord() ) ) ) {
					std::cout << "Trying motif number " << imot+1 << " of " << emot << " total " << " at position " <<
														closest_pos(imot+1) << std::endl;

					if( successful_loop_closure( pose, setpos, imot, closest_pos(imot+1),
																free_window ) ) {
						std::cout << "Loop closure at depth " << depth << " succeeded! recurse down loop..." << std::endl;
						FArray1D_int new_setpos( setpos );
						new_setpos( closest_pos(imot+1) ) = imot;
						LoopState new_ls( get_loop_state_from_pose( pose ) );
						try_for_more( pose, new_setpos, new_ls, (depth + 1) );
					} else {
						std::cout << "Loop closure at depth " << depth << " failed, next motif..." << std::endl;
					}
				}
			}

			std::cout << "Exhausted motifs:  rising from depth of " << depth << std::endl;

		} // End of trying for more

		// Print it out
//		make_named_pdb( "loop_" + make_loop_name( pose.total_residue(), setpos ) + "_" +
//				lead_zero_string_of( loop_uniq_id++, 4 ) + ".pdb", true );
		pose_ns::Score_weight_map dump_weight_map( score12 );
		pose.dump_scored_pdb( files_paths::pdb_out_path + "loop_" + make_loop_name( pose.total_residue(), setpos ) + "_" +
				lead_zero_string_of( loop_uniq_id++, 4 ) + ".pdb", dump_weight_map );

		return;
	}

	void
	DNAMotifLoopDesign::get_closest_pos_and_rmsd(
		pose_ns::Pose & pose,
		FArray1Da_int pos,
		FArray1Da_float rmsd,
		FArray1Da_float ca_dist )
{
	using namespace aaproperties_pack;

	FArray3D_float const & fcoord( pose.full_coord() );

	pos.dimension( inv_rot_lib.size() );
	rmsd.dimension( inv_rot_lib.size() );
	pos = -1;
	rmsd = 9999.999;
	ca_dist = 9999.999;

	//jjh local variables
	int bbres;

	for ( int irot = 0, erot = inv_rot_lib.size();
			irot < erot; ++irot ) {

		int thisaa = inv_rot_lib[irot].aa();
//		int thisaav = inv_rot_lib[irot].aav();

		int start_res = loop_region.start();
		int end_res = loop_region.end();
		for ( bbres = start_res; bbres <= end_res; ++bbres ) {
				// loop through target DNA regions positions

			int bbaa = pose.res( bbres );
//			int bbaav = pose.res_variant( bbres );

 			float chk_rmsd(0.0);
 			float tmp_rmsd(0.0);

			int num_atoms = 0;
			distance2_bk( inv_rot_lib[irot].get_rotcoord()(1,1), fcoord(1,1,bbres), tmp_rmsd );
			chk_rmsd += tmp_rmsd;
			num_atoms++;

			distance2_bk( inv_rot_lib[irot].get_rotcoord()(1,2), fcoord(1,2,bbres), tmp_rmsd );
			chk_rmsd += tmp_rmsd;
			float ca_dist_tmp = std::sqrt( tmp_rmsd );
			num_atoms++;

			distance2_bk( inv_rot_lib[irot].get_rotcoord()(1,3), fcoord(1,3,bbres), tmp_rmsd );
			chk_rmsd += tmp_rmsd;
			num_atoms++;

			int iat1 = HApos( thisaa, 1 );
			int iat2 = HApos( bbaa, 1 );

			distance2_bk( inv_rot_lib[irot].get_rotcoord()(1,iat1), fcoord(1,iat2,bbres), tmp_rmsd );
			chk_rmsd += tmp_rmsd;
			num_atoms++;
			chk_rmsd /= ( float( num_atoms ) );
			chk_rmsd = std::sqrt( chk_rmsd );

//			if( chk_rmsd < rmsd(irot + 1) ) {
			if( ca_dist_tmp < ca_dist(irot + 1) ) {
				rmsd(irot + 1) = chk_rmsd;
				pos(irot + 1) = bbres;
				ca_dist(irot + 1) = ca_dist_tmp;
			}

		}               // end looping through backbone positions
//    std::cout << "Rotamer " << irot << " closest rmsd is " << closest_rmsd << " with " << closest_pos << std::endl;
	} // end of loop through inverse rotamer library
}

	bool
	DNAMotifLoopDesign::successful_loop_closure(
		pose_ns::Pose & pose,
		FArray1Da_int setpos,
		int try_mot,
		int bb_pos,
		DNA_Motifs::RegionPair & free_window
	)
{
		using namespace misc;
		using namespace param_pack;
		using namespace aaproperties_pack;

		int const nres( pose.total_residue() );

		setpos.dimension( nres );

		FArray3D_float const & fcoord( pose.full_coord() );

		if( bb_pos == loop_region.start() || bb_pos == loop_region.end() )
			return false;

		std::cout << "Trying to close at position " << bb_pos << " in range " << free_window.start() <<
			" to " << free_window.end() << std::endl;
//		std::cout << "Current loop start is " << cur_loop_start << std::endl;

		///jjh Retrieve a reasonable fold tree that was stored during
		///jjh initialization
		pose.set_fold_tree( saved_fold_tree );
		pose_ns::Pose save_pose;
		save_pose = pose;

//		std::cout << "Fold tree contents:" << std::endl << pose.fold_tree() << std::endl;
		///jjh Make sure no jumps currently sit in the loop_region
		pose_ns::Fold_tree f( pose.fold_tree() );
		for( int i = loop_region.start() ; i <= loop_region.end() ; ++i ) {
			assert( !f.get_is_jump_point()(i) );
		}

		///jjh Get some info about our inverse rotamer
		int ir_aa( inv_rot_lib[try_mot].aa() );
		int ir_aav( inv_rot_lib[try_mot].aav() );

		///jjh Slam in the inverse rotamer
		pose.copy_sidechain( bb_pos, ir_aa, ir_aav,
			inv_rot_lib[try_mot].get_rotcoord(), false );

//		std::cout << "Fold tree contents:" << std::endl << f << std::endl;

//*************************************************************
//*** Set up fold tree for initial loop closure onto motif  ***
//*************************************************************

		///jjh Put in two new cuts and jumps
		if( bb_pos != loop_region.start() ) {
			f.new_jump( loop_region.start()-2, bb_pos, bb_pos-1 );
		}
		if( bb_pos != loop_region.end() ) {
			f.new_jump( loop_region.start()-2, loop_region.end()+2,
																	bb_pos );
		}

		pose.set_fold_tree( f );
//		std::cout << "Fold tree contents:" << std::endl << pose.fold_tree() << std::endl;

//**************************************************
//*** Create loop closure energy term parameters ***
//**************************************************


		///jjh Set up the constraints energy term, which will be used for the
		///jjh first two rounds, for loop closure
		pose_ns::Score_weight_map weight_map( score12 );
		weight_map.set_weight( pose_ns::CHAINBREAK_CST, 1.0 );

		///jjh Indicate that the motif represents a chainbreak
		cst_set_ns::Cst_set chain_cst_set;
		chain_cst_set.add_chainbreak( bb_pos-1, 1.0 );
		chain_cst_set.add_chainbreak( bb_pos  , 1.0 );
//********************************************************
//*** Create hbond preservation energy term parameters ***
//********************************************************

		cst_set_ns::Cst_set ap_cst_set;
		bool use_atompair_cst( true );

		if( use_atompair_cst ) {
			///jjh Set up some distance constraints along the loop, primarily
			///jjh to preserve hbonding.

			///jjh Call score to set up hbonding arrays
			pose.set_constraints( ap_cst_set );
			pose.score( weight_map );
			weight_map.set_weight( pose_ns::ATOMPAIR_CST, 1.0 );
			for( int hbi = loop_region.start(), hbe = loop_region.end() ; hbi <= hbe ;
									++hbi ) {
				int other_atm, other_res;
				find_CO_bb_hbond_partner( pose, hbi, other_atm, other_res );
				if( other_atm > 0 && other_res > hbi ) {
					int const atm1( 4 );
					int const res1( hbi );
					int const atm2( other_atm );
					int const res2( other_res );

					kin::Atom_id aid1( atm1, res1 );
					kin::Atom_id aid2( atm2, res2 );
					cst_set_ns::Cst cst_r( std::sqrt( vec_dist2( fcoord( 1, atm1, res1 ),
																						fcoord( 1, atm2, res2 ))));
					ap_cst_set.add_atompair_constraint( aid1, aid2, cst_r );
				}

				find_NH_bb_hbond_partner( pose, hbi, other_atm, other_res );
				if( other_atm > 0 && other_res > hbi ) {
//				std::cout << "Adding atm res hbond for pos " << other_atm << " , " <<
//											other_res << " , " << hbi << std::endl;

					int const atm1( HNpos( pose.res(hbi), pose.res_variant(hbi) ) );
					int const res1( hbi );
					int const atm2( other_atm );
					int const res2( other_res );

					kin::Atom_id aid1( atm1, res1 );
					kin::Atom_id aid2( atm2, res2 );
					cst_set_ns::Cst cst_r( std::sqrt( vec_dist2( fcoord( 1, atm1, res1 ),
																						fcoord( 1, atm2, res2 ))));
					ap_cst_set.add_atompair_constraint( aid1, aid2, cst_r );
				}

			}
		}

//***************************************************************
//*** Create short persistence length energy  term parameters ***
//***************************************************************

		///jjh Hmmmm, maybe in addition to lateral constraints, I should also
		///jjh add some longitudinal constraints from Ca to Ca+1, Ca+2

		cst_set_ns::Cst_set long_cst_set;
		bool use_longitudinal_cst( false );

		if( use_longitudinal_cst ) {
			int const Ca_id( 2 );

			weight_map.set_weight( pose_ns::ATOMPAIR_CST, 1.0 );
			for( int hbi = (loop_region.start()-2), hbe = loop_region.end() ; hbi <= hbe ;
									++hbi ) {

				if( hbi < 1 ) continue;
				kin::Atom_id a_id_i( Ca_id, hbi );

				int hbj( hbi + 1 );
				if( hbj <= nres ) {
					kin::Atom_id a_id_j( Ca_id, hbj );
					cst_set_ns::Cst cst_r( std::sqrt( vec_dist2( fcoord( 1, Ca_id, hbi ),
																						fcoord( 1, Ca_id, hbj ))));
					long_cst_set.add_atompair_constraint( a_id_i, a_id_j, cst_r );
				} else {
					continue;
				}

				hbj = hbi + 2 ;
				if( hbj <= nres ) {
					kin::Atom_id a_id_j( Ca_id, hbj );
					cst_set_ns::Cst cst_r( std::sqrt( vec_dist2( fcoord( 1, Ca_id, hbi ),
																						fcoord( 1, Ca_id, hbj ))));
					long_cst_set.add_atompair_constraint( a_id_i, a_id_j, cst_r );
				}
			}
		}

//***************************************
//*** Backbone torsional constraints  ***
//***************************************


		cst_set_ns::Cst_set bb_tor_cst_set;
		bool use_bb_tor_cst( true );

		if( use_bb_tor_cst ) {

			weight_map.set_weight( pose_ns::PHIPSI_CST, 0.1 );
//			weight_map.set_weight( pose_ns::OMEGA_CST, 1.0 );
			for( int hbi = (loop_region.start()-1), hbe = (loop_region.end()+1) ; hbi <= hbe ;
									++hbi ) {

				if( hbi < 1 || hbi > nres ) continue;

				///jjh Limit this to the 'stems' of the loop
				if( ( (hbi - loop_region.start() ) > 2 ) &&
						( (loop_region.end() - hbi)  ) > 2 )
					continue;

				bb_tor_cst_set.add_rosetta_torsion_constraint( hbi, 1, pose.phi( hbi ) );
				bb_tor_cst_set.add_rosetta_torsion_constraint( hbi, 2, pose.psi( hbi ) );
//				bb_tor_cst_set.add_rosetta_torsion_constraint( hbi, 3, pose.omega( hbi ) );

			}
		}

	cst_set_ns::Cst_set cst_set;

	// report the constraints
//	std::cout << "Constraints for first loop closure:" << std::endl;
//	std::cout << cst_set << std::endl;

	cst_set.collect( chain_cst_set ).collect( ap_cst_set ).collect( bb_tor_cst_set );

	pose.set_constraints( cst_set );

//*******************************************
//*** Perform the actual CCD loop closure ***
//*******************************************

		///jjh CCD loop closure parameters
		float fdev,bdev,tor_delta,rama_delta;
		int const ccd_cycles(100);

		///jjh Parameters for Phil's ccd_moves
		int const num_cycles( 20 ); //Phil had 30
		int const num_ccd_moves( 4 ); //Phil had 5
		int const num_loop_weight_steps( 5 );
		bool do_profiling( false );

		///jjh N to C folding to close on the motif
		{
			///jjh restrict movement from the start to the free window
			pose.set_allow_move( kin::ALL, false );
			for ( int i=free_window.start(); i <= free_window.end(); ++i ) {
				pose.set_allow_bb_move( i, true );
			}

			///jjh Perform relaxation/perturbation/closure/minimization du jour

			if( false ) {
			pose.dump_pdb( "ccd_start" + string_of(try_mot) + ".pdb" );
			fast_ccd_loop_closure( pose,free_window.start(),bb_pos-1,
				bb_pos-1, ccd_cycles, 0.01, true, 2.0, 10, 30, 90, fdev, bdev,
					tor_delta, rama_delta );
			pose.dump_pdb( "ccd_post_n" + string_of(try_mot) + ".pdb" );
			fast_ccd_loop_closure( pose,bb_pos+1,free_window.end(),
				bb_pos, ccd_cycles, 0.01, true, 2.0, 10, 30, 90, fdev, bdev,
					tor_delta, rama_delta );
			pose.dump_pdb( "ccd_post_both" + string_of(try_mot) + ".pdb" );
			std::cout << "fdev: " << F(9,3,fdev) << F(9,3,bdev) <<
				F(9,3,tor_delta) << F(9,3,rama_delta ) << std::endl;
			} else {

				pose_ns::Monte_carlo mc( pose, weight_map, 0.8 );
				pose_setup_minimizer( 0.001 );
				set_use_nblist( false );

				if( do_profiling ) prof::reset( true );

				float chainbreak_weight(0.5);
				for ( int c1=1; c1<= num_loop_weight_steps; ++c1 ) {
					chainbreak_weight *= 2.0;
					weight_map.set_weight( pose_ns::CHAINBREAK_CST, chainbreak_weight );
					mc.set_weight_map( weight_map );

//					pose.main_minimize( weight_map, "dfpmin" );
					pose.main_minimize( weight_map, "linmin" );
					mc.boltzmann( pose, "min-trial" );

					for ( int c2=1; c2<= num_cycles; ++c2 ) {
						ccd_moves( num_ccd_moves, pose, loop_region.start(), bb_pos-1, bb_pos-1 );
//						pose.main_minimize( weight_map, "dfpmin" );
						pose.main_minimize( weight_map, "linmin" );
						mc.boltzmann( pose, "nterm-ccd-moves" );

						ccd_moves( num_ccd_moves, pose, bb_pos+1, loop_region.end(), bb_pos);
//						pose.main_minimize( weight_map, "dfpmin" );
						pose.main_minimize( weight_map, "linmin" );
						mc.boltzmann( pose, "cterm-ccd-moves" );
					}
					pose = mc.low_pose();
					std::cout << "round " << c1 << ' ' << pose.show_scores() << std::endl;
					mc.show_counters();
				}
				pose = mc.low_pose();
				if( do_profiling ) prof::show();
			}

			pose.score( weight_map );
			std::cout << pose.show_scores() << std::endl;

			///jjh Output
//			pose.dump_pdb( "min_split" + string_of(try_mot) + ".pdb" );

		}

//***************************************
//*** See how well the closure worked ***
//***************************************

		///jjh Now need to obtain separate chainbreak scores for the two
		///jjh sides of the inverse rotamer

		float const all_close = calc_pose_constraint_scores( pose, 0.0, 0.0,
											0.0, 0.0, 0.0, 0.0, 0.0, 1.0 );

		///jjh remove the c-terminal chainbreak
		cst_set.clear_all_chainbreaks();
		cst_set.add_chainbreak( bb_pos-1, 1.0 );
		pose.set_constraints( cst_set );

		float const n_close = calc_pose_constraint_scores( pose, 0.0, 0.0,
											0.0, 0.0, 0.0, 0.0, 0.0, 1.0 );

		float const c_close( all_close - n_close );

		std::cout << "Total Closure  = " << all_close << std::endl;
		std::cout << "Closure from N-terminal side = " << n_close << std::endl;
		std::cout << "Closure from C-terminal side = " << c_close << std::endl;

//*************************************************************
//*** Determine which side, if either, to close onto motif  ***
//*************************************************************

		int cut_pt( -1 );
		int glue_pt( -1 );
		float close_cutoff( 1.0 );

		if( ( c_close < n_close ) && c_close <= close_cutoff ) {
			///jjh ligate inverse rotamer to c-term loop
			glue_pt = bb_pos;
			cut_pt = bb_pos - 1;
		} else if ( (n_close < c_close ) && n_close <= close_cutoff ) {
			///jjh ligate inverse rotamer to n-term loop
			glue_pt = bb_pos - 1;
			cut_pt = bb_pos ;
		} else {
			///jjh failure to close loop!
		  pose = save_pose; // very fast!
			return false;
		}

		pose_ns::Fold_tree min_f( saved_fold_tree );
		min_f.new_jump( loop_region.start()-2, loop_region.end()+2, cut_pt );
		pose.set_fold_tree( min_f );
//		std::cout << "Fold tree contents:" << std::endl << pose.fold_tree() << std::endl;

		pose.insert_ideal_bonds_at_cutpoint( glue_pt );

		///jjh First set the chainbreak position
		cst_set.clear_all_chainbreaks();
		cst_set.add_chainbreak( cut_pt, 1.0 );

//**********************************************
//*** Set motif functional group restraints  ***
//**********************************************

		///jjh Now set tether constraints on the three inverse rotamer atoms
		///jjh that define the motif's interaction with DNA

		FArray1D_int temp_motif_set( setpos );
		temp_motif_set( bb_pos ) = try_mot;
		int i_nmotifs = set_vector_motif_sidechain_cst( cst_set, inv_rot_lib,
																										temp_motif_set, nres );
		float nmotifs( i_nmotifs );

		std::cout << "Using " << i_nmotifs << " sidechains as constraints " << std::endl;

		pose.set_constraints( cst_set );

	// report the constraints
//	std::cout << "Constraints for second loop closure:" << std::endl;
//	std::cout << cst_set << std::endl;

		weight_map.set_weight( pose_ns::COORD_CST, 1.0 );
//		pose.score( weight_map );
//		std::cout << pose.show_scores() << std::endl;

//********************************
//*** Now do some minimization ***
//********************************

		///jjh Try some minimization on just the free window region
		{
			///jjh restrict movement from the start to the free window
			pose.set_allow_move( kin::ALL, false );
//			for ( int i=free_window.start(); i< free_window.end(); ++i ) {
			///jjh Actually, try to let the whole loop relax
			for ( int i=loop_region.start(); i< loop_region.end(); ++i ) {
				pose.set_allow_bb_move( i, true );
			}

			pose_ns::Monte_carlo mc( pose, weight_map, 0.8 );
			pose_setup_minimizer( 0.001 );
			set_use_nblist( false );

			if( do_profiling ) prof::reset( true );

			float chainbreak_weight(0.5);
			for ( int c1=1; c1<= num_loop_weight_steps; ++c1 ) {
				chainbreak_weight *= 2.0;
				weight_map.set_weight( pose_ns::CHAINBREAK_CST, chainbreak_weight );
				mc.set_weight_map( weight_map );

//					pose.main_minimize( weight_map, "dfpmin" );
				pose.main_minimize( weight_map, "linmin" );
				mc.boltzmann( pose, "post-min-trial" );

				for ( int c2=1; c2<= num_cycles; ++c2 ) {
					ccd_moves( num_ccd_moves, pose, loop_region.start(), bb_pos-1, bb_pos-1 );
//						pose.main_minimize( weight_map, "dfpmin" );
					pose.main_minimize( weight_map, "linmin" );
					mc.boltzmann( pose, "post-nterm-ccd-moves" );

					ccd_moves( num_ccd_moves, pose, bb_pos+1, loop_region.end(), bb_pos);
//						pose.main_minimize( weight_map, "dfpmin" );
					pose.main_minimize( weight_map, "linmin" );
					mc.boltzmann( pose, "post-cterm-ccd-moves" );
				}
				pose = mc.low_pose();
				std::cout << "round " << c1 << ' ' << pose.show_scores() << std::endl;
				mc.show_counters();
			}
			pose = mc.low_pose();
			if( do_profiling ) prof::show();

			pose.score( weight_map );
			std::cout << pose.show_scores() << std::endl;

			///jjh Output
//			pose.dump_pdb( "min_free_win_" + string_of(try_mot) + ".pdb" );

		}


		float const final_close = calc_pose_constraint_scores( pose, 0.0, 0.0,
											0.0, 0.0, 0.0, 0.0, 0.0, 1.0 );

		std::cout << "Final closure score:  " << final_close << std::endl;

		float const final_motif = calc_pose_constraint_scores( pose, 0.0, 0.0,
											0.0, 0.0, 0.0, 0.0, 1.0, 0.0 )/nmotifs;

		std::cout << "Final ave. motif match:  " << final_motif << std::endl;

		if( final_close > 0.5 || final_motif > 2.0 ) {
		  pose = save_pose; // very fast! (ha ha)
		  return false;
		}

		return true;
}

	DNA_Motifs::RegionPair
	DNAMotifLoopDesign::check_free_length(
		int nres,
		int mpos,
		FArray1Da_int setpos
	)
	{
		setpos.dimension( nres );

		DNA_Motifs::RegionPair loop_window( loop_region );

		for( int i = 1, ei = nres ; i <= ei ; ++i ) {
			if( setpos(i) < 1 ) {
				continue;
			} else if( setpos(i) == mpos ) {
				loop_window.set_start( setpos(i) );
				loop_window.set_end( setpos(i) );
				return loop_window;
			} else if( setpos(i) > mpos && setpos(i) < loop_window.end() ) {
				loop_window.set_end( setpos(i) );
			} else if( setpos(i) < mpos && setpos(i) > loop_window.start() ) {
				loop_window.set_start( setpos(i) );
			}
		}

		return loop_window;

	}


	bool
	DNAMotifLoopDesign::is_clash_free(
		pose_ns::Pose & pose,
		int seqpos,
		FArray1Da_int setpos,
		int aa,
		int aav,
		FArray2Da_float coords )
{

	using namespace param;
	using namespace param_pack;

	FArray3D_float const & fcoord( pose.full_coord() );
	int nres( pose.total_residue() );

	FArray1D_float dummyactcoord1( 3, 1.0 );
	FArray1D_float dummyactcoord2( 3, 3.0 );

	setpos.dimension( pose.total_residue() );
	coords.dimension( 3, MAX_ATOM() );

	float solvE, atrE, repE, pairE, planeE, elecE;

	float clash_energy = 0.0;

	for( int ipos = 1, epos = nres; ipos <= epos ; ++ipos ) {
		if( setpos(ipos) <= 0 ) continue;

		int thisaa( pose.res(ipos) );
		int thisaav( pose.res_variant(ipos) );

		get_sc_scE( thisaa, thisaav, fcoord(1,1,ipos),aa,aav,
			coords, dummyactcoord1, dummyactcoord2, ipos, seqpos ,
			solvE, atrE, repE, pairE, planeE, elecE);

		clash_energy += pack_wts.Watr()*atrE + pack_wts.Wrep()*repE;

	}

	return ( clash_energy > 5.0 ? false : true );

}


	void
	DNAMotifLoopDesign::copy_loop_state_to_pose(
		pose_ns::Pose & pose,
		LoopState & ls
	)
{
	using namespace param;

	ls.aa.dimension( loop_region.size() );
	ls.aav.dimension( loop_region.size() );
	ls.coords.dimension( 3, MAX_ATOM(), loop_region.size() );

	for( int ipos = ls.start, epos = ls.end, il = 1 ;
				ipos <= epos ; ++ipos, ++il ) {

		pose.copy_sidechain( ipos, ls.aa( il ), ls.aav( il ), ls.coords(1, 1, il), false );

	}

	return;
}

	LoopState
	DNAMotifLoopDesign::get_loop_state_from_pose(
		pose_ns::Pose & pose
	)
{
	using namespace param;

	LoopState ls;

	FArray3D_float const & fcoord( pose.full_coord() );

	ls.start = loop_region.start();
	ls.end = loop_region.end();

	ls.aa.dimension( loop_region.size() );
	ls.aav.dimension( loop_region.size() );
	ls.coords.dimension( 3, MAX_ATOM(), loop_region.size() );

	for( int ipos = ls.start, epos = ls.end, il = 1 ;
				ipos <= epos ; ++ipos, ++il ) {
		ls.aa( il ) = pose.res( ipos );
		ls.aav( il ) = pose.res_variant( ipos );
		for( int ai = 1, ae = MAX_ATOM() ; ai <= ae ; ++ai ) {
			for( int ki = 1, ke = 3 ; ki <= ke ; ++ki ) {
				ls.coords(ki,ai,il) = fcoord(ki,ai,ipos);
			}
		}
	}

	return ls;
}

	std::string
	DNAMotifLoopDesign::make_loop_name(
		int nres,
		FArray1Da_int setpos
	)
{

	using namespace param;
	using namespace param_aa;
	using namespace misc;

	setpos.dimension( nres );

	std::string retval;

	for( int ipos = loop_region.start(), epos = loop_region.end() ;
				ipos <= epos ; ++ipos ) {
		if( setpos(ipos) > 0 ) {
//			retval +=  str( aa_name3( res(ipos) ) ) + str( ipos );
			retval +=  aa_name3( res(ipos) );
			retval += lead_zero_string_of(ipos, 3);
		}
	}

	return retval;

}




///////////////////////////////////////////////////////////////////////////////
/// END OF RECURSIVE LOOP PLACEMENT  //////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

  void
	DNAMotifLoopDesign::do_find_second_shell(
	pose_ns::Pose & pose
	)
	{

		using namespace param_aa;

		FArray3D_float const & fcoord ( pose.full_coord() );
		int const & nres( pose.total_residue() );

		second_shell_positions.clear();

		///jjh Find all neighbors for the positions
		///jjh in the loop region and store

		for( int ires = loop_region.start() , end = loop_region.end() ;
																							ires <= end ; ++ires ) {
			for( int bbres = 1, ebbres = nres ; bbres <= ebbres ;
						++bbres ) {
				if( loop_region.in_check( bbres ) ) continue;
				if( !is_protein( pose.res( bbres ) ) ) continue;

				float dis2;
				bool is_neighbor;
				are_they_neighbors( pose.res(ires), pose.res(bbres),
					fcoord(1,1,ires),fcoord(1,1,bbres),
					dis2,is_neighbor);

				///jjh I like this better than is_neighbor, which is more
				///jjh generous (too many neighbors)
				if( dis2 < 81.0) {
					second_shell_positions.push_back( bbres );
//					std::cout << "found " << ires << " with " << bbres << " dis2 " << dis2 << std::endl;
				}
			}
		}

		///jjh Sort the positions
		sort( second_shell_positions.begin(), second_shell_positions.end() );

		///jjh Reduce to the unique set, since we made no
		///jjh effort to do that when we were finding them
		second_shell_positions.erase(
			unique( second_shell_positions.begin(), second_shell_positions.end() ),
			second_shell_positions.end() );

		///jjh Print them out
		for ( int iprint = 0, eprint = second_shell_positions.size() ;
						iprint < eprint ; ++iprint ) {
//			std::cout << "Neighbor at pos " << second_shell_positions[ iprint ] << std::endl;
		}

		return;
	}

	LoopDesign::LoopState::LoopState( int s, int e ) {
		using namespace param;
		start = s;
		end = e;
//		set.dimension( (e - s + 1 ) );
		aa.dimension( (e - s + 1 ) );
		aav.dimension( (e - s + 1 ) );
		coords.dimension( 3, MAX_ATOM(), (e - s + 1 ), 0.0 );
	}

	LoopDesign::LoopState::LoopState( const LoopDesign::LoopState &ls  ) {
		using namespace param;
		start = ls.start;
		end = ls.end;
//		set.dimension( ls.size() );
		aa.dimension( ls.size() );
		aav.dimension( ls.size() );
		coords.dimension( 3, MAX_ATOM(), ls.size() );
		for( int i = 1, e = ls.size() ; i <= e ; ++i ) {
//			set(i) = ls.set(i);
			aa(i) = ls.aa(i);
			aav(i) = ls.aav(i);
			for( int ai = 1, ae = MAX_ATOM() ; ai <= ae ; ++ ai ) {
				for( int ki = 1, ke = 3 ; ki <= ke ; ++ ki ) {
					coords( ki, ai, i ) = ls.coords( ki, ai, i );
				}
			}
		}
	}

	LoopDesign::LoopState& LoopDesign::LoopState::operator=( const LoopDesign::LoopState &ls  ) {
		using namespace param;

		if( this == &ls ) return *this;
		start = ls.start;
		end = ls.end;
//		set.dimension( ls.size() );
		aa.dimension( ls.size()  );
		aav.dimension( ls.size() );
		coords.dimension( 3, MAX_ATOM(), ls.size() );
		for( int i = 1, e = ls.size() ; i <= e ; ++i ) {
//			set(i) = ls.set(i);
			aa(i) = ls.aa(i);
			aav(i) = ls.aav(i);
			for( int ai = 1, ae = MAX_ATOM() ; ai <= ae ; ++ ai ) {
				for( int ki = 1, ke = 3 ; ki <= ke ; ++ ki ) {
					coords( ki, ai, i ) = ls.coords( ki, ai, i );
				}
			}
		}
		return *this;
	}



void
enable_gb( bool onoff )
{
using namespace param_pack;

static float save_Wgb_elec = pack_wts.Wgb_elec();

if( onoff ) {
	gen_born = true;
	pack_wts.set_Wgb_elec(save_Wgb_elec);
} else {
	gen_born = false;
	pack_wts.set_Wgb_elec(0.0);
}

}


void
dna_loop_min()
{
	using namespace pose_ns;
	using namespace kin;

	std::vector<int> _loop_start;
	std::vector<int> _loop_end;

	if( !read_loop_file( _loop_start, _loop_end ) ) {
		std::cout << "Failure to read loop file" << std::endl;
		std::exit( EXIT_FAILURE );
	}

	std::cout << "Sizes are " << _loop_start.size() << " " << _loop_end.size() << std::endl;

	if( _loop_start.size() != 1 || _loop_end.size() != 1 ) {
		std::cout << "For now, only works on one loop at a time" << std::endl;
		std::exit( EXIT_FAILURE );
	}

	int const loop_start( _loop_start[0] );
	int const loop_end( _loop_end[0] );
//	int const loop_size( loop_end-loop_start+1 );

	assert( truefalseoption("enable_dna" ) &&
					truefalseoption("dna_weights" ) &&
					truefalseoption("gen_born") );

	std::string data( stringafteroption("s").c_str() );
	pose_ns::Pose pose;
	bool const ok( pose_from_pdb( pose, data, true, false, true ) );

	int const nres( pose.total_residue() );

	if( !ok ) {
		std::cout << "PDB reader says not ok!" << std::endl;
		exit(0);
	}

	FArray1D_bool excludes( nres, false );

	int ipos = loop_start - 3;
	int epos = loop_end + 3;
	if( ipos < 1 ) ipos = 1;
	if( epos > nres ) epos = nres;
	std::cout << "Excluding from " << ipos << " to " << epos << std::endl;
	for( int lpos = ipos ; lpos <= epos ; ++ lpos ) {
		excludes( lpos ) = true;
	}

	setup_simple_dna_fold_tree( pose, excludes );
	Fold_tree f_tree( pose.fold_tree() );

	{

		int moving_residue( (loop_start + loop_end) / 2 );

		f_tree.new_jump( loop_start-1, loop_end+1, moving_residue-1 );
		pose.set_fold_tree( f_tree );

		///////////
		// scorefxn
		Score_weight_map w( score12 );
		w.set_weight( CHAINBREAK_CST, 1.0 );

		// setup chainbreak constraints
		cst_set_ns::Cst_set cst_set;
		cst_set.add_chainbreak( moving_residue-1, 1.0 );
		pose.set_constraints( cst_set );


		///jjh CCD loop closure parameters
//		float fdev,bdev,tor_delta,rama_delta;
//		int const ccd_cycles(100);

		///jjh Parameters for Phil's ccd_moves
//		int const num_cycles( 20 ); //Phil had 30
//		int const num_ccd_moves( 4 ); //Phil had 5
//		int const num_loop_weight_steps( 4 ); //Phil had 5
//		bool do_profiling( false );

		///jjh Let only the loop move
		pose.set_allow_move( kin::ALL, false );
		for ( int i=loop_start; i <= loop_end; ++i ) {
			pose.set_allow_bb_move( i, true );
			pose.set_allow_chi_move( i, true );
		}


		{ // experiment with dna vdw and fast hbonds...

			Monte_carlo mc( pose, w, 0.8 );
			prof::reset( true );
			pose_setup_minimizer( 0.001 );
			set_use_nblist( false );

			float chainbreak_weight(0.5);
			for ( int c1=1; c1<= 2; ++c1 ) {
				chainbreak_weight *= 2.0;
				w.set_weight( CHAINBREAK_CST, chainbreak_weight );
				mc.set_weight_map( w );

				pose.main_minimize( w, "linmin" );
				mc.boltzmann( pose, "min" );

				for ( int c2=1; c2<= 2; ++c2 ) {
					ccd_moves( 5, pose, loop_start, moving_residue-1, moving_residue-1 );
					mc.boltzmann( pose, "nterm" );

					ccd_moves( 5, pose, moving_residue+1, loop_end, moving_residue );
					mc.boltzmann( pose, "cterm" );

					if ( true ) {
						ccd_moves( 5, pose, moving_residue+1, loop_end, moving_residue );
						pose.main_minimize( w, "linmin" );
						mc.boltzmann( pose, "cterm-min" );

						ccd_moves( 5, pose, loop_start, moving_residue-1,moving_residue-1);
						pose.main_minimize( w, "linmin" );
						mc.boltzmann( pose, "nterm-min" );
					}
				}
				pose = mc.low_pose();
				std::cout << "round " << c1 << ' ' << pose.show_scores() << std::endl;
				mc.show_counters();
			}

			pose = mc.low_pose();
//			pose.dump_pdb( "final.pdb" );
			make_named_pdb("final.pdb",true);
			output_decoy_pose( pose );
			prof::show();

		}
	}
}


void
dna_jjh_refine(
)
{
	assert( truefalseoption( "enable_dna" ) &&
					truefalseoption( "dna_weights" ) &&
					truefalseoption( "gen_born") &&
					truefalseoption( "hydrate_dna" ) );

	std::string data( stringafteroption("s").c_str() );
	pose_ns::Pose pose;
	bool const ok( pose_from_pdb( pose, data, true, false, true ) );

	if( !ok ) {
		std::cout << "PDB reader says not ok!" << std::endl;
		exit(0);
	}

	///jjh Do a water-variant only repack/redesign to hydrate
	///jjh the interface
	std::cout << "Calling pack_rotamers() to place waters..." << std::endl;

	std::string mode( "design" );
	pose.pack_hack( true, mode );

	// scorefxn
	pose_ns::Score_weight_map w( score12 );

	pose.dump_scored_pdb( files_paths::pdb_out_path + "hacky_pack.pdb", w);

	///jjh Now do the actual refinement
	std::cout << "Calling relax/minimize to refine structure..." << std::endl;

	minimize_set_tolerance( 0.001 );
	pose_setup_packer();
	set_use_nblist( false ); // safety

	int loop_start( 18 );
	int loop_end( 34 );

	FArray1D_bool everybody( pose.total_residue(), true );
	for( int i = 1, ei = pose.total_residue() ; i <= ei ; ++i ) {
		if( param_aa::is_DNA( pose.res( i ) ) ) everybody( i ) = false;
		if( i < loop_start || i > loop_end ) everybody( i ) = false;
	}

	// minimize interface sc + bb for protein
	pose.set_allow_chi_move( everybody );
	pose.set_allow_bb_move( everybody );
	pose.set_allow_jump_move( false ); /////////////////////PERMANENT NOW

//	pose.main_minimize( w, "dfpmin" );
//	calc_rms( pose );

//	pose.dump_scored_pdb( files_paths::pdb_out_path + "hacky_min.pdb", w);

	// Set up some refinement moves
	pose_ns::Loops loop_list;
	loop_list.add_loop( 18, 34, 24 );
//	loop_list.add_loop( 108, 117, 112 );

	loops_ns::fast = true;
//	pose_refine_loops_with_ccd( pose, w, loop_list );

//	pose.dump_scored_pdb( files_paths::pdb_out_path + "hacky_refine.pdb", w );

	exit(0);

}


