// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.13 $
//  $Date: 2005/05/18 07:35:25 $
//  $Author: mentzer $

#ifndef INCLUDED_pose_loops
#define INCLUDED_pose_loops

//Rosetta headers
#include "pose.h"

// Forward declarations
namespace pose_ns { class Loops; }

void
pose_loops_main();

void
pose_loops_random_start(
	pose_ns::Pose & pose,
	const pose_ns::Loops & loops
);

void
pose_fold_loops_with_ccd(
	pose_ns::Pose & pose,
	const pose_ns::Loops & loops
);

void
pose_perturb_one_loop_with_ccd(
	pose_ns::Pose & pose,
	pose_ns::Score_weight_map & wt_map,
	const pose_ns::Loops & loops
);

void
pose_refine_loops_with_ccd(
	pose_ns::Pose & pose,
	pose_ns::Score_weight_map & wt_map,
	const pose_ns::Loops & loops
);

void
pose_refine_loops_with_ccd(
	pose_ns::Pose & pose,
	pose_ns::Score_weight_map & wt_map,
	const pose_ns::Loops & loops,
	int const out_cycles,
	int const inner_cycles,
	int const nmoves,
	bool const include_current,
	bool const include_neighbors
);

int
pose_small_moves(
	pose_ns::Pose & pose,
	int const num_in
);

int
pose_shear_moves(
	pose_ns::Pose & pose,
	int const num_in
);

void
pose_ccd_close_loops(
	pose_ns::Pose & pose,
	const pose_ns::Loops & loops
);


void
pose_loops_trim_template(
	const pose_ns::Pose & input_pose,
	const pose_ns::Loops & loops,
	const FArray1D_bool & trim_res,
	pose_ns::Pose & trim_pose,
	pose_ns::Loops & trim_loops
);


void
pose_loops_trim_template_reset(
	pose_ns::Pose & pose,
	const pose_ns::Loops & loops,
	const FArray1D_bool & trim_res,
	const pose_ns::Pose & trim_pose,
	const pose_ns::Loops & trim_loops
);

void
pose_loops_build_fold_tree(
	int const total_residue,
	const pose_ns::Loops & loops,
	pose_ns::Fold_tree & f
);


void
pose_loops_select_trim_residues(
	pose_ns::Pose const & pose,
	FArray1D_bool & trim_res
);

void
pose_loops_select_trim_residues(
	pose_ns::Pose const & pose,
	pose_ns::Loops const & loops,
	FArray1D_bool & trim_res
);

void
pose_loops_set_allow_bb_move(
	pose_ns::Pose & pose,
	const pose_ns::Loops & loops
);

void
pose_loops_set_allow_chi_move(
															pose_ns::Pose & pose,
															const pose_ns::Loops & loops,
															const bool include_neighbors,
															FArray1D_bool & allow_repack
															);

bool
pose_loops_get_disallow_bb_move(
	int const & ires
);


void
pose_loops_select_loop_residues(
	const pose_ns::Pose & pose,
	const pose_ns::Loops & loops,
	bool const include_neighbors,
	FArray1D_bool & map
);

void
pose_loops_select_loop_residues_symm(
  const pose_ns::Pose & pose,
  const pose_ns::Loops & loops,
  bool const include_neighbors,
  FArray1D_bool & map
);

bool
pose_loops_init_from_file(
	pose_ns::Loops & loops
);

bool
pose_loops_init_from_global_ns(
	pose_ns::Loops & loops
);


bool
pose_loops_init_from_pose_loops_input_ns(
	pose_ns::Loops & loops
);


bool
pose_loops_init_from_input(
	pose_ns::Loops & loops,
	std::vector<int> loop_begin,
	std::vector<int> loop_end,
	std::vector<int> cutpoints
);


void
pose_loops_init_to_global_ns(
	pose_ns::Loops loops
);


void
pose_loops_reset_global_ns(
);


void
set_loops_ns_fast(
	bool const & setting
);

void
set_loops_ns_fixnatsc(
	bool const & setting
);


void
pose_loops_insert_ideal_bonds_at_cutpoints(
	pose_ns::Pose & pose,
	const pose_ns::Loops & loops
);


bool
pose_loops_get_refine_only();

void
pose_loops_store_chainbreak_score(
	pose_ns::Pose & pose
	);

#endif
