// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8300 $
//  $Date: 2006-05-10 12:02:18 -0700 (Wed, 10 May 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "pose_loops_input_ns.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/DimensionExpressions.hh>

// Using


namespace pose_loops_input_ns {

	bool refine_only( true );
	bool start_from_extend( false );

	int const max_n_loops = { 10 };

	float chainbreak_score = { 1000. };

	namespace loop_definitions {

 		FArray1D_int loop_begin( max_n_loops, 0 );
		FArray1D_int loop_end( max_n_loops, 0 );
		FArray1D_int cut_point( max_n_loops, 0 );
		int n_loops ( 0 );

	}

	namespace bbmove_additional_control {
		int nres_disallow_bbmove ( 0 );
		FArray1D_int list_disallow_bbmove( 0 );//initially dimension 0
	}

  namespace trim_info {
    bool trim_in_use ( false );
		FArray1D_int trim_map( 0 );//initially dimension 0
  }


}
