// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18466 $
//  $Date: 2007-11-16 23:05:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $

#ifndef INCLUDED_pose_movie
#define INCLUDED_pose_movie

// Rosetta Headers
#include "pose.h"

// Utility Headers
#include <utility/io/ozstream.hh>
#include <utility/vector1.hh>

namespace pose_ns {

class Movie {

	private:

		bool movie_;
		bool trajectory_;
		bool gz_;
		bool one_file_;
		bool sparse_;
		int model_;
		int frame_;
   	int frame_skip_;
		std::string basename_;
		utility::io::ozstream movie_stream_;
		utility::io::ozstream trajectory_stream_;
		FArray3D_float full_coord_;
		utility::vector1<utility::vector1<bool> > updated_;
		int nupdates_;
		int nupdates_bb_;

		void
		update_full_coord(
			pose_ns::Pose const & pose
		);

		void
		dump_updated_full_coord(
			pose_ns::Pose const & pose,
			std::ostream & out
		);

	public:

		Movie();

		void
		write_frame(
			pose_ns::Pose const & pose
		);

		inline
		void
		increment_frame();

		void
		close();
};

inline
void
Movie::increment_frame()
{
	frame_++;
}

} // end pose_ns namespace

#endif
