// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 18467 $
//  $Date: 2007-11-16 23:20:47 +0200 (Fri, 16 Nov 2007) $
//  $Author: yab $

#ifndef INCLUDED_pose_rms
#define INCLUDED_pose_rms


#include "pose_fwd.h"

#include <ObjexxFCL/ObjexxFCL.hh>

#include <vector>


void
calc_homolog_rms(
	pose_ns::Pose & pose,
	pose_ns::Pose const & native_pose,
	FArray1D_int const & mapping
);


float
CA_rmsd_by_subset(
	const pose_ns::Pose & pose1,
	const pose_ns::Pose & pose2,
	const FArray1D_bool & subset
);


float
CA_rmsd_by_mapping(
	const pose_ns::Pose & pose1,
	const pose_ns::Pose & pose2,
	const FArray1D_int & mapping
);


int
CA_maxsub_by_mapping(
	const pose_ns::Pose & pose1,
	const pose_ns::Pose & pose2,
	const FArray1D_int & mapping
);

int CA_maxsub(
	const pose_ns::Pose & pose1,
	const pose_ns::Pose & pose2
);


float
CA_rmsd(
	pose_ns::Pose const & pose1,
	pose_ns::Pose const & pose2
);


float
allatom_rmsd(
	pose_ns::Pose const & pose1,
	pose_ns::Pose const & pose2
);


float
LG_rmsd( pose_ns::Pose const & pose );

float
LG_rmsd(
	pose_ns::Pose const & pose1,
	pose_ns::Pose const & pose2
);


float
allatom_rmsd_by_mapping(
	pose_ns::Pose const & pose1,
	pose_ns::Pose const & pose2,
	FArray1D_int const & mapping,
	bool fit_rms
);


float
calc_rms(
	pose_ns::Pose & pose
);


void
per_res_CA_rmsd(
	pose_ns::Pose const & pose1,
	pose_ns::Pose const & pose2,
	std::vector< float > & per_res_rmsd
);


void
maxsub_orient_pose(
	pose_ns::Pose & pose1,
	pose_ns::Pose const & pose2,
	bool const ideal_pos
);


float
simple_rms(
	int const npoints,
	FArray2Da_float p1,
	FArray2Da_float p2
);

// 		void CA_orient( Pose const & pose );
// 		void CA_orient_subset( Pose const & pose, FArray1D_bool const & subset );
// 		float calc_allatom_rms( FArray2DB_bool const & atom_set ) const;
// 		float calc_subset_rms( Pose const & pose, FArray1D_bool const & subset,
// 													 bool const all_bb_atoms = false ) const;
// 		float CA_rmsd( Pose const & pose ) const;
// 		void Pose::bb_orient_mapping(
// 			Pose const & fixed_pose,
// 			FArray1D_int const & mapping
// 		);

void
create_shuffle_map_recursive_rms(
        std::vector<int> sequence,
				const int N,
				std::vector< std::vector<int> > & map
);

#endif
