// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: rhiju $

#ifndef INCLUDED_pose_rna_base_doublet_classes
#define INCLUDED_pose_rna_base_doublet_classes


// C++ Headers
#include <iostream>
#include <list>

/////////////////////////////////////////////////////////////////////
// Useful type definitions.
/////////////////////////////////////////////////////////////////////

class Base_pair
{
 public:
  int res1;
  int res2;
  int edge1;
  int edge2;
  int orientation; // 1 = antiparallel; 2 = parallel

  friend
    bool operator < (Base_pair const & lhs, Base_pair const & rhs )
  {
    //There must be a more elegant way to do this...
    if( lhs.res1 < rhs.res1 )
      return true;
    else if ( lhs.res1 == rhs.res1 )
      if ( lhs.res2 < rhs.res2 )
	return true;
      else if ( lhs.res2 == rhs.res2 )
	if ( lhs.edge1 < rhs.edge1 )
	  return true;
	else if ( lhs.edge1 == rhs.edge1 )
	  if ( lhs.edge2 < rhs.edge2 )
	    return true;
	  else
	    if ( lhs.edge2 == rhs.edge2)
	      return ( lhs.orientation < rhs.orientation);
    return false;
  };

  friend
    bool operator == (Base_pair const & lhs, Base_pair const & rhs )
  {
		return (lhs.res1 == rhs.res1 &&
						lhs.res2 == rhs.res2 &&
						lhs.edge1 == rhs.edge1 &&
						lhs.edge2 == rhs.edge2 &&
						lhs.orientation == rhs.orientation );
  };


  friend
    std::ostream &
    operator <<( std::ostream & out, Base_pair const & s ){
    out << s.res1 << " " << s.res2 << " " << s.edge1 << " " << s.edge2 << " " << s.orientation;
    return out;
  }
};

typedef std::pair<float, Base_pair> Energy_base_pair;
typedef std::list<Energy_base_pair> Energy_base_pair_list;

class Base_stack{
 public:
  int res1;
  int res2;
  int orientation; // 1 = antiparallel; 2 = parallel
  int which_side;  // 1 = residue 2 is 3' to residue1;  2 = residue 2 is 5' to residue 1

  friend
    bool operator < (Base_stack const & lhs, Base_stack const & rhs ){
    //There must be a more elegant way to do this...
    if( lhs.res1 < rhs.res1 )
      return true;
    else if ( lhs.res1 == rhs.res1 )
      if ( lhs.res2 < rhs.res2 )
	return true;
      else if ( lhs.res2 == rhs.res2 )
	if ( lhs.orientation < rhs.orientation )
	  return true;
	else if ( lhs.orientation == rhs.orientation )
	  return ( lhs.which_side < rhs.which_side);
    return false;
  }


  friend
    std::ostream &
    operator <<( std::ostream & out, Base_stack const & s )
    {
      out << s.res1 << " " << s.res2 << " " <<  s.orientation << " " << s.which_side;
      return out;
    }


};

typedef std::pair<float, Base_stack> Energy_base_stack;
typedef std::list<Energy_base_stack> Energy_base_stack_list;


#endif
