// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

#ifndef INCLUDED_pose_rna_fragments
#define INCLUDED_pose_rna_fragments

// Rosetta Headers
#include "pose_fwd.h"

// C++ Headers
#include <string>

void
readin_rna_vall( pose_ns::Pose & pose );

bool
pur_pyr_comp(
  int const res1,
	int const res2
	);

void
insert_fragment_old( pose_ns::Pose & pose, int const position, int const fragment_number );

void
random_fragment_insertions( pose_ns::Pose & pose, int const num_fragment_insertions, bool const smooth = false, int const frag_size = 3 );

void
random_fragment_trial( pose_ns::Pose & pose, pose_ns::Monte_carlo & mc, bool const smooth, std::string trial_type, int const frag_size = 3 );

void
pick_random_fragments( pose_ns::Pose & pose, int const num_fragment_insertions );

void
pick_rna_fragments( pose_ns::Pose & pose );

void
pick_rna_fragments_main();

void
read_rna_fragments();

void
create_vall_torsions_file_test();

void
rna_fragments_classes_test();

bool check_RNA_torsion_insertable(
   pose_ns::Pose & pose,
	 int const position_offset,
	 int const which_torsion);

bool check_RNA_torsion_insertable_strict(
   pose_ns::Pose & pose,
	 int const position_offset,
	 int const which_torsion);

void
rna_closest_frag_test();

#endif
