// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12014 $
//  $Date: 2007-01-12 03:23:23 +0200 (Fri, 12 Jan 2007) $
//  $Author: chu $

#ifndef INCLUDED_pose_rotamer_trials
#define INCLUDED_pose_rotamer_trials


// Rosetta Headers
#include "pose_fwd.h"
#include "score_name.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <vector>


// rotamer_trials Function Declarations
void
pose_setup_repack_list(
	pose_ns::Pose const & pose,
	FArray1D_int & repack_list,
	int & npositions,
	int & num_cycles
);


void
reset_rt_pos_list();


void
set_rt_pos_list_by_allow(
	FArray1D_bool const & allow,
	int const nres,
	int const cycles_in
);


std::vector< int > const &
get_rt_pos_list(
	pose_ns::Pose const & pose,
	int & cycles_out
);


void
set_rotamer_trials_by_deltaE(
	const pose_ns::Score_name score_name_in,
	float const energycut_in,
	int const nres,
	FArray1D_float const & energy,
	int const cycles_in
);

bool
get_rotamer_trials_by_deltaE();


void
pose_rottrial_minimization(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map
);

#endif
