// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8698 $
//  $Date: 2006-06-05 22:50:03 -0700 (Mon, 05 Jun 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_pose_symmetry
#define INCLUDED_pose_symmetry


// Rosetta Headers
#include "loop_class.h"
#include "pose_fwd.h"
#include <numeric/all.fwd.hh>


#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <string>

void
create_monomer_pose(pose_ns::Pose & oligomer_pose,
  pose_ns::Pose & monomer_pose,
	int const nres_monomer
);

void
create_symmetric_pose(
  pose_ns::Pose & monomer_pose,
  bool const fullatom,
  int const N,
  int const anchor,
  numeric::xyzVector_float origin,
  numeric::xyzVector_float z_axis,
  std::string symmetry_type,
  pose_ns::Pose & pose // output pose
  );

void
create_output_pose(pose_ns::Pose & oligomer_pose,
	pose_ns::Pose & pose
);



void
 find_coordinates_virus(
 numeric::xyzVector_float & rot_axis_save,
 numeric::xyzVector_float & monomer_pos_save
 );


void
fold_fragments_docking(
											 /*	pose_ns::Pose & monomer_pose,*/
  pose_ns::Pose & pose,
  bool const score_chainbreaks // = true
);


void
pose_docking_symm_calc_interface(
  pose_ns::Pose & pose,
  FArray1DB_bool & int_res
);


void
pose_docking_symm_centroid_rigid_body_adaptive(
  pose_ns::Pose & pose,
  int const outer_cycles,
  int const inner_cycles,
  const pose_ns::Score_weight_map & wt_map,
  float trans_mag,
  float rot_mag
);


void
pose_docking_symm_coordsys_setup(
	pose_ns::Pose & monomer_pose,
	pose_ns::Pose & oligomer_pose,
	int  & anchor,
	numeric::xyzVector_float & z_axis,
	numeric::xyzVector_float & origin,
	int const radius
);


void
pose_docking_symm_fragments_protocol(
  pose_ns::Pose & oligomer_pose,
  int const nres_monomer
);


void
pose_docking_symm_loop_protocol(
  pose_ns::Pose & oligomer_pose,
  int const nres_monomer,
  pose_ns::Loops & loops
);


void
pose_docking_symm_mcm_protocol(
	 pose_ns::Pose & docking_pose
);


void
pose_docking_symm_minimize_rb_position(
  pose_ns::Pose & pose,
  const std::string & type,
  const pose_ns::Score_weight_map & wt_map,
  float func_tol
);


void
pose_docking_symm_minimize_trial(
	 pose_ns::Pose & docking_pose,
  const std::string & min_type,
  const pose_ns::Score_weight_map & wt_map,
  const float func_tol
);


void
pose_docking_symm_monomer_loop_tree(
  pose_ns::Pose & pose,
  int const anchor,
	pose_ns::Loops & loops
);


void
pose_docking_symm_monte_carlo_minimize(
  pose_ns::Pose & docking_pose,
  const int cycles,
  const std::string & min_type,
  const pose_ns::Score_weight_map & wt_map,
  const float trans_magnitude,
  const float rot_magnitude,
  const float minimization_threshold,
  const float func_tol
);



void
pose_docking_symm_perturb_rigid_body(
  pose_ns::Pose & monomer_pose,
	pose_ns::Pose & pose
);

void
pose_docking_symm_perturb_rigid_body(
	pose_ns::Pose & pose,
	float const monomer_vdw
);

void
pose_docking_symm_perturb_rigid_body(
	pose_ns::Pose & pose
);

void
slide_into_contact_cn(
    pose_ns::Pose & pose
);

void
slide_into_contact_helix(
    pose_ns::Pose & pose
);

void
slide_into_contact_dn(
    pose_ns::Pose & pose
);

void
slide_into_contact_virus(
    pose_ns::Pose & pose
);

void
pose_docking_symm_perturb_rigid_body_helix(
	pose_ns::Pose & pose
);

void
pose_docking_symm_perturb_rigid_body_fold(
  pose_ns::Pose & monomer_pose,
  pose_ns::Pose & pose
);


void
pose_docking_symm_protocol(pose_ns::Pose & monomer_pose,
	int const nres_monomer);


void
pose_docking_symm_repack(
  pose_ns::Pose & pose,
  const bool pack_interface,
  const bool include_current
);


float
pose_docking_symm_rigid_body_trial(
  pose_ns::Pose & pose,
  int const cycles,
  const pose_ns::Score_weight_map & wt_map,
  bool const repack,
  float const trans_mag,
  float const rot_mag
);



void
separate_oligomers(
  pose_ns::Pose & pose
);

void
set_allow_dg_free_cn(
 pose_ns::Pose & pose
);

void
set_allow_dg_free_dn(
 pose_ns::Pose & pose
);


void
set_allow_dg_free_helix(
 pose_ns::Pose & pose
);


void
set_allow_dg_free_virus(
 pose_ns::Pose & pose
);


void
set_allow_chi_move_symm(
  pose_ns::Pose & pose
);


void
symm_move(
	pose_ns::Pose & pose,
	double const rot_mag, // in degrees
	double const trans_mag // in radians
);


void
symm_pose(
	pose_ns::Pose const & src_pose,
	int const N, // n monomers
	numeric::xyzVector_double const & axis_abs_coord,
	numeric::xyzVector_double const & offset_abs_coord,
	int const anchor_rsd,
	pose_ns::Pose & pose
);


void
symm_pose_cn(
	pose_ns::Pose const & monomer_pose,
	bool const fullatom,
	int const N,
	int const anchor_rsd,
	numeric::xyzVector_float const & origin,
	numeric::xyzVector_float const & z_axis,
	pose_ns::Pose & pose // output pose
);

void
symm_pose_dn(
  pose_ns::Pose & monomer_pose,
  bool const fullatom,
  int const N,
  int const anchor,
  float const dist,
  float const radius,
	float const angle,
  pose_ns::Pose & pose // output pose
);


void
symm_pose_helix(
  pose_ns::Pose & monomer_pose,
  bool const fullatom,
  int const N,
  int const anchor_rsd,
  float const alfa,
  float const step,
  float const radius,
  pose_ns::Pose & pose // output pose
);


void
symm_pose_virus(
  pose_ns::Pose & monomer_pose,
  bool const fullatom,
  int const N,
  int const anchor,
  float const dist,
  float const radius,
  float const angle,
  pose_ns::Pose & pose // output pose
);

void
set_continue_fa(
  pose_ns::Pose & pose,
	bool & continue_fa
);

void
setup_pseudo_pose(
	int const N,
	float const z,
	pose_ns::Pose & pose
);


void
setup_pseudo_pose_dn(
  int const N,
  pose_ns::Pose & pose
);


void
setup_pseudo_pose_helix(
  int const N,
	float const step,
	float  const alfa,
	pose_ns::Pose & pose
);


void
setup_pseudo_pose_virus(
  int const N,
  pose_ns::Pose & pose
);


void
calc_param_virus();


void
return_xyz_vectors_virus(
  numeric::xyzVector_double & x_vec,
	numeric::xyzVector_double & z_vec,
	numeric::xyzVector_double & ori
);

int
number_jump_monomer(
  pose_ns::Pose & pose
);

void
prepare_native();

void
prepare_native_cn(
	pose_ns::Pose & pose, pose_ns::Pose & monomer_pose,
	pose_ns::Pose & oligomer_pose
);

void
prepare_native_d2(
  pose_ns::Pose & pose,
  pose_ns::Pose & monomer_pose,
  pose_ns::Pose & oligomer_pose
);

void
find_dist_radius_angle_d2(
  pose_ns::Pose & pose,
  int const anchor,
  int const nres_monomer,
  float & dist,
  float & radius,
	float & angle
);

void
create_full_symmetric_pose(
  pose_ns::Pose & pose,
	int const N
);

void
create_full_symmetric_pose(
  pose_ns::Pose & monomer_pose,
  pose_ns::Pose & pose,
  int const N
);

void
prepare_native_dimer();

void
prepare_native_dimer( pose_ns::Pose & dimer_pose, pose_ns::Pose & monomer_pose,
											pose_ns::Pose & oligomer_pose );

void
pose_docking_hinge_protocol_symm(
	pose_ns::Pose & oligomer_pose,
	int const nres_monomer
);

void
identify_inter_hinge_residues(
	pose_ns::Pose & pose,
  FArray1DB_bool & int_res,
  int hinge_start,
  int hinge_end,
  int nres_monomer
);

void
pose_docking_hinge_mcm_trial_symm(
  pose_ns::Pose & pose,
  const pose_ns::Score_weight_map & weight_map
);


float
pose_docking_hinge_move_trial_symm(
  pose_ns::Pose & pose,
  int const cycles,
  const pose_ns::Score_weight_map & wt_map,
  float trans_mag,
  float rot_mag
);

void
setup_c1_symm( pose_ns::Pose & start_pose,
							 pose_ns::Pose & pose,
							 int const anchor_point = 1);


void
setup_c1_symm( pose_ns::Pose & start_pose,
							 pose_ns::Pose & pose,
							 FArray1D_int & anchor,
							 int const num_anchor );

void
c1_symm_test();

void
initialize_looprlx_symm_pose(
														 pose_ns::Pose & monomer_pose,
														 bool const fullatom,
														 pose_ns::Loops & one_loop,
														 pose_ns::Pose & pose // output pose
														 );
void
pose_symm_loop_relax(
						 pose_ns::Pose & oligomer_pose,
						 int const nres_monomer );

void
copy_loops_file( std::vector < int > ori_loops_begin,
								 std::vector < int > ori_loops_end,
								 pose_ns::Loops & input_loops );


#endif
