// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 08:39:36 +0200 (Sun, 18 Mar 2007) $
//  $Author: stuartm $


// Rosetta Headers
#include "pose_vdw.h"
#include "after_opts.h"
#include "cenlist.h"
#include "count_pair_position.h"
#include "current_pose.h"
#include "ligand_ns.h"
#include "maps.h"
#include "maps_ns.h"
#include "minimize.h"
#include "misc.h"
#include "param.h"
#include "prof.h"
#include "pose.h"
#include "pose_dna.h"
#include "pose_rna.h"
#include "runlevel.h"
#include "score.h"
#include "score_ns.h"
#include "vdw.h"

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <cassert>
#include <cmath>
#include <iostream>
#include <vector>



//
// public functions
//
//Utility Headers
#include <utility/basic_sys_util.hh>

///////////////////////////////////////////////////////////////////////////////
/// @begin pose_vdw_compute
///
/// @brief
///
/// @detailed
///
/// @param  vdw_score - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
pose_vdw_compute( float & vdw_score )
{
	//using namespace cenlist_ns;
	using namespace ligand;
	using namespace misc;
	using namespace param;
	using namespace param_aa;
	//using namespace runlevel_ns;
	//using namespace vdw_bumps;
	using namespace pose_ns;
	using numeric::xyzVector_double;

	assert( score_check_current_pose() );
	PROF_START( prof::POSE_VDW_COMPUTE );


	/////////////////
	// POSE interface
	// get cendist, vdw_score, vdw_pair, domain_map
	Pose & pose ( score_get_current_pose() );
	Score_state vdw_score_state, vdw_pair_state;

	// returns if already updated:
	pose_update_cendist( pose );

	// recover old total vdw score (not multiplied by any factors ==> sum of VDW_PAIR)
	float pose_vdw_score( pose.get_0D_score( VDW_CACHE, vdw_score_state ) );
	FArray2D_float & vdw_pair( pose.set_2D_score( VDW_PAIR, vdw_pair_state ) );
	FArray2D_float const & cendist( pose.get_2D_score( CENDIST ) );
	FArray1D_int const & domain_map( pose.get_domain_map() );

	// check score is OK
	bool trust_domain_map
		( ( vdw_score_state == OK || vdw_score_state == GOOD) &&
			( vdw_pair_state == OK || vdw_pair_state == GOOD ) );

	if ( ! trust_domain_map ) {
		pose_vdw_score = 0.0;
		vdw_pair = 0.0; // array=
	}

	// which region of the protein changed?
	int first = 1;
	int last = total_residue;
	if ( trust_domain_map ) { // adjust first and last to bound the changed region
		int map_val;
		map_val = domain_map( first );
		if ( map_val != 0 ) {
			while ( first < total_residue && domain_map(first) == map_val ) ++first;
		}
		map_val = domain_map( last );
		if ( map_val != 0 ) {
			while ( last > 1 && domain_map( last ) == map_val ) --last;
		}
	}

	// not static ints anymore, may be changing
	int const cendist_size1 = cendist.size1();
	int const Eposition_size12 = Eposition.size1() * Eposition.size2();
	// this should be guaranteed by pose.score_data
	assert( int(vdw_pair.size1()) == cendist_size1 );

	int type0; // centroid i
	int type1; // atom j
	int type2; // atom i
	int type3; // centroid j
	float cendist_ij, dist2, alpha_alpha;
	float atomvdw; // lower distance bound, temp

//   compute the distance between all atom pairs, and score for bumps
//
//  1) if the centroids >  12 A apart, no atoms to residues can bump
//  2) if CA(i) CA(j) distance > 7A, no backbone atoms of pair bump
//  3) dont check any pairs of atoms who's distance is unchanged.
//    maintain internal arrays to determine what parts of molecule are unchanged
//------------------------------------------------------------------------------

// what range of protein changed?
	//FArray2DB_bool const & pair_moved( retrieve_pair_moved(true) );
	//maps_get_pair_moved_region( first, last );

// compute i-centroid to j-centroid distance.  store it for use elsewhere
	//update_cendist();

	//float vdw_score_local = 0.0;
	//n_bump = 0;

	for ( int i = 1, lci = 0; i <= last; ++i, lci += 3 ) { // residue 1
		int const imap( domain_map(i) );
		bool const imoved ( imap == 0 || !trust_domain_map );

		type0 = atom_type_cen(i);
		xyzVector_double const cen_i( &centroid[ lci ] ); // centroid(1-3,i)

		int const res_i = res(i);
		int const lEt_1i = Eatom_type.index(1,i);
		int const lEp_11i = Eposition.index(1,1,i);

		xyzVector_double const Epos_2i( &Eposition(1,2,i) ); // Eposition(1-3,2,i)

		for ( int j = std::max( i, first ), lcj = centroid.index(1,j),
		 lcd = cendist.index(i,j), lEp_12j = Eposition.index(1,2,j);
		 j <= total_residue;
		 ++j, lcj += 3, lcd += cendist_size1, lEp_12j += Eposition_size12 ) { // residue 2
			float vdw_score_j = 0.0;
			if ( imoved || domain_map(j) != imap ) {
				//if ( pair_moved[ lcd ] ) { //pair_moved(i,j)
				pose_vdw_score -= vdw_pair[ lcd ];
				cendist_ij = cendist[ lcd ]; // cendist(i,j); // look up prev calc dist
//--------
// as long as were at it, we now do a clash check
//  first do a coarse grain reality check on centroid seperations
//  and if it passes carefully check atom-atom distances
//--------

				if ( cendist_ij <= cenlist_ns::cen_dist_cutoff2 ) { // reality check
     //std::cout << "vdw" << SS( i ) << SS( j ) << SS( cendist_ij ) << std::endl;

					type3 = atom_type_cen(j);
					int const res_j = res(j);

					if ( is_protein(res_i) && is_protein(res_j) ) {

//     centroid-centroid clash check
					if ( count_pair_position( i, type0, res_i, j, type3, res_j ) ) {
						atomvdw = vdw::atom_vdw(type0,type3);
						dist2 = atomvdw - cendist_ij;
						if ( dist2 > 0.0 ) vdw_score_j += ( dist2 * dist2 ) / atomvdw; // clash score
					}

					xyzVector_double const cen_j( &centroid[ lcj ] ); // centroid(1-3,j)

// As a prefilter we first compute the calpha-calpha distance.
// . If this is greater than 49 (7 squared) none of the backbone/cbeta can clash and we skip the distance backbone checks.
// . Additionally if this is greater than 60 then we can skip the centriod backbone checks.
//
//car these cutoffs defined in param.h
					alpha_alpha = distance_squared( Epos_2i, // Eposition(1-3,2,i)
					 xyzVector_double( &Eposition[ lEp_12j ] ) ); // Eposition(1-3,2,j)

// minimum  centroid-pentamer radius
					int const lEt_1j = Eatom_type.index(1,j);
					int const lEp_11j = Eposition.index(1,1,j);

//---------
//  check i-centroid to j-atom  clash
//---------
					for ( int jatom = 1, lEtj = lEt_1j, lEpj = lEp_11j; jatom <= MAX_POS; ++jatom, ++lEtj, lEpj += 3 ) {
						type1 = Eatom_type[ lEtj ]; // Eatom_type(jatom,j)
						if ( count_pair_position( i, type0, res_i, j, type1, res_j ) ) {
							atomvdw = vdw::atom_vdw(type0,type1);
							dist2 = atomvdw - distance_squared( cen_i, // centroid(1-3,i)
							 xyzVector_double( &Eposition[ lEpj ] ) ); // Eposition(1-3,jatom,j)

							if ( dist2 > 0.0 ) vdw_score_j += ( dist2 * dist2 ) / atomvdw; // clash score
						}
					} // jatom

//---------
//  check j-centroid to i-atom  clash
//---------
					for ( int iatom = 1, lEti = lEt_1i, lEpi = lEp_11i; iatom <= MAX_POS; ++iatom, ++lEti, lEpi += 3 ) {
						type2 = Eatom_type[ lEti ]; // Eatom_type(iatom,i) // vdw calc
						if ( count_pair_position( j, type3, res_j, i, type2, res_i ) ) {
							atomvdw = vdw::atom_vdw(type3,type2);
							dist2 = atomvdw - distance_squared( cen_j, // centroid(1-3,j)
							 xyzVector_double( &Eposition[ lEpi ] ) ); // Eposition(1-3,iatom,i)

							if ( dist2 > 0.0 ) vdw_score_j += ( dist2 * dist2 ) / atomvdw; // clash score
						}
					} // iatom

//------
//   check i-pentamer to j-pentamer
//------

					if ( alpha_alpha < cenlist_ns::ca_dist_cutoff2 ) { // clash radius CA-CA

						for ( int jatom = 1, lEtj = lEt_1j, lEpj = lEp_11j;
						 jatom <= MAX_POS; ++jatom, ++lEtj, lEpj += 3 ) {
							type1 = Eatom_type[ lEtj ]; // Eatom_type(jatom,j)

							if ( type1 != 0 ) { // count_pair_position would catch but leave so we can avoid loop
								xyzVector_double const Epos_jatom( &Eposition[ lEpj ] ); // Eposition(1-3,jatom,j)

								for ( int iatom = 1, lEti = lEt_1i, lEpi = lEp_11i;
								 iatom <= MAX_POS; ++iatom, ++lEti, lEpi += 3 ) {
									// all backbone atoms in residue i
									type2 = Eatom_type[ lEti ]; // Eatom_type(iatom,i)
									if ( count_pair_position( i, type2, res_i, j, type1, res_j ) ) {
										atomvdw = vdw::atom_vdw(type1,type2);
										dist2 = atomvdw - distance_squared( Epos_jatom, // Eposition(1-3,jatom,j)
										 xyzVector_double( &Eposition[ lEpi ] ) ); // Eposition(1-3,iatom,i)

										if ( dist2 > 0.0 ) vdw_score_j += ( dist2 * dist2 ) / atomvdw; // clash score
									} // end count_pair check
								} // end iatom
							} // end type1 glycine check
						} // end jatom
					} // end alpha-alpha < cenlist_ns::ca_dist_cutoff2 check
				} else if ( is_protein( res_i ) && is_DNA( res_j ) ) {
					// NOTE -- inside cendist check !!!!!!!!!!!!!!!!!!!!!
					vdw_score_j = dna_vdw( pose, i, j );

				} else if ( is_protein( res_j ) && is_DNA( res_i ) ) {
					vdw_score_j = dna_vdw( pose, j, i );

				} else if ( is_RNA( res_j ) && is_RNA( res_i ) ) {
					vdw_score_j = rna_rna_vdw( pose, j, i, cendist_ij );

				} // aa check
				} // end cen_dist_cutoff2








				vdw_pair[lcd] = vdw_score_j;
				pose_vdw_score += vdw_score_j;
			} // pair has moved
		} // end j
	} // end i=1,end_res
	pose.set_0D_score( pose_ns::VDW_CACHE, pose_vdw_score );

	// now add hetero terms
	float vdw_score_local ( pose_vdw_score );
	vdw_hetero( Eposition, centroid, atom_type_cen, total_residue, ligand::ligand_one->atom_vector,
		 ligand::ligand_one->atom_vector.size(), vdw::atom_vdw, vdw_score_local );

	vdw_score = vdw_score_local * 0.8f;
//  	vdw_score_local += copy_best_bumps(first,last,pair_moved);

//  	vdw_hetero(Eposition,centroid,atom_type_cen,total_residue,hetero_atom_cent,
//  	 hetero_atom_coord,hetero_atom_count,atom_vdw,vdw_score_local);

//  	vdw_score = vdw_score_local * 0.8f;
	PROF_STOP( prof::POSE_VDW_COMPUTE );
}


////////////////////////////////////////////////////////////////////////////////
/// @begin update_cendist
///
/// @brief
///
/// @detailed
/// uses pair_moved to do fast updates
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
pose_update_cendist(
	pose_ns::Pose & pose
)
{

	//using namespace cenlist_ns;
 	using namespace param;
	using namespace pose_ns;
	using numeric::xyzVector_double;

	// pose interface: //////////////////////////////////////////////////////////
	Score_state cendist_state;
	FArray2D_float & cendist ( pose.set_2D_score( CENDIST, cendist_state ));
	if ( cendist_state == GOOD ) {
		return;
	}
	PROF_START( prof::POSE_UPDATE_CENDIST );
	bool const cendist_ok( cendist_state == OK );
	// cendist_ok == false means that the we should not believe any
	// data in cendist, even if pair_moved is false
	FArray2D_bool const & pair_moved( pose.get_pair_moved() );
	/////////////////////////////
	// NOTE: we no longer copy from best_cendist
	// rather, if ( cendist_ok && !pair_moved(i,j) ) we keep the current value
	// of cendist(i,j)

	int const cendist_size1 = cendist.size1();

	assert( cendist_size1 == int( pair_moved.size1() ) && cendist.index(1,1) == pair_moved.index(1,1) );

	for ( int i = 1, lci =pose.centroid().index(1,i); i <= pose.total_residue(); ++i, lci += 3 ) {
		xyzVector_double const cen_i( & pose.centroid()[ lci ] ); // centroid(1-3,i)
		if ( cen_i.is_zero() ) {
			for ( int j = i; j <= pose.total_residue(); ++j ) {
				cendist(i,j) = cendist(j,i) = cenlist_ns::cendist(i,j) = cenlist_ns::cendist(j,i) = 999.0;
			}
		} else {
			cendist(i,i) = 0.0;
			for ( int j = i+1, lji = cendist.index(j,i), lij = cendist.index(i,j), lcj = pose.centroid().index(1,j);
			 j <= pose.total_residue(); ++j, ++lji, lij += cendist_size1, lcj += 3 ) {
				if ( !cendist_ok || pair_moved[ lij ] ) {
					cendist[ lij ] = cendist[ lji ] =
						distance_squared( cen_i, // centroid(1-3,i)
						xyzVector_double( & pose.centroid()[ lcj ] ) ); // centroid(1-3,j)
				}
			}
		}
	}

	// hack: some routines still use the cenlist_ns version
	FArray2D_float & cd( cenlist_ns::cendist );
	for ( int i = 1; i <= pose.total_residue(); ++i ) {
		for ( int j = 1, l = cendist.index(1,i), m = cd.index(1,i); j <= pose.total_residue(); ++j, ++l, ++m ) {
			cd[m] = cendist[l];
		}
	}
	PROF_STOP( prof::POSE_UPDATE_CENDIST );
}

