// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7755 $
//  $Date: 2006-03-24 12:36:17 -0800 (Fri, 24 Mar 2006) $
//  $Author: pbradley $


// Rosetta Headers
#include "prof.h"
#include "after_opts.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/formatted.io.hh>

// #include <sys/times.h>
#include <map>
#include <ctime>

namespace prof {

	std::map< Prof_tag, clock_t > start_clock;
	std::map< Prof_tag, double > total_clock;
	std::map< Prof_tag, int > calls;
	std::map< Prof_tag, int > bad_calls;
	std::map< Prof_tag, std::string > tag2string;

	clock_t const SHRINK_FACTOR( 2 );

	double const clock_factor( ( (double) SHRINK_FACTOR * 100.0 ) /
														 CLOCKS_PER_SEC );

	bool profiling( true );


	/////////////////////////////////////////////////////////////////////////////
	void
	setup_tag2string()
	{
		tag2string[ FULLATOM_ENERGY ] = "FULLATOM_ENERGY";
		tag2string[ F_E_PAIR_ENERGY ] = "F_E_PAIR_ENERGY";
		tag2string[ F_E_GB ] = "F_E_GB";
		tag2string[ F_E_GB_RADII ] = "F_E_GB_RADII";
		tag2string[ F_E_GB_ENERGY ] = "F_E_GB_ENERGY";
		tag2string[ F_E_HBOND ] = "F_E_HBOND";
		tag2string[ F_E_FA_PAIR ] = "F_E_FA_PAIR";
		tag2string[ F_E_FA_CACHE ] = "F_E_FA_CACHE";
		tag2string[ F_E_NB_INFO ] = "F_E_NB_INFO";
		tag2string[ F_E_DUNBRACK ] = "F_E_DUNBRACK";
		tag2string[ F_E_ANGLES_FROM_PDB ] = "F_E_ANGLES_FROM_PDB";
		tag2string[ F_E_WATER ] = "F_E_WATER";
		tag2string[ ATOM_TREE_REFOLD ] = "ATOM_TREE_REFOLD";
		tag2string[ DOMAIN_MAP ] = "DOMAIN_MAP";
		tag2string[ DFPMIN ] = "DFPMIN";
		tag2string[ ATOM_TREE_FUNC_VDW ] = "ATOM_TREE_FUNC_VDW";
		tag2string[ ATOM_TREE_DFUNC_VDW ] = "ATOM_TREE_DFUNC_VDW";
		tag2string[ ATOMPAIR_DERIV ] = "ATOMPAIR_DERIV";
		tag2string[ DFUNC_NB ] = "DFUNC_NB";
		tag2string[ DFUNC_HB ] = "DFUNC_NB";
		tag2string[ MIN_MAP_UPDATE_NBLIST ] = "MIN_MAP_UPDATE_NBLIST";
		tag2string[ MMUN_NB_INFO ] = "MMUN_NB_INFO";
		tag2string[ POSE_COPY_SCORE_DATA ] = "POSE_COPY_SCORE_DATA";
		tag2string[ POSE_COPY_COORDS ] = "POSE_COPY_COORDS";
		tag2string[ ATOM_TREE_COPY_TORSIONS ] = "ATOM_TREE_COPY_TORSIONS";
		tag2string[ CCD_CLOSE ] = "CCD_CLOSE";
		tag2string[ CCD_MOVES ] = "CCD_MOVES";
		tag2string[ SCOREFXN ] = "SCOREFXN";
		tag2string[ ROTAMER_TRIALS ] = "ROTAMER_TRIALS";
		tag2string[ MAIN_REPACK ] = "MAIN_REPACK";
		tag2string[ DFUNC ] = "DFUNC";
		tag2string[ UPDATE_NBLIST ] = "UPDATE_NBLIST";
		tag2string[ RTCALC_ENERGIES ] = "RTCALC_ENERGIES";
		tag2string[ GET_ENERGIES ] = "GET_ENERGIES";
		tag2string[ PACKER_SIMANNEALING ] = "PACKER_SIMANNEALING";
		tag2string[ GET_ROTAMERS_BORN_RADII ] = "GET_ROTAMERS_BORN_RADII";
		tag2string[ POSE_VDW_COMPUTE ] = "POSE_VDW_COMPUTE";
		tag2string[ POSE_UPDATE_CENDIST ] = "POSE_UPDAT_CENDIST";
		tag2string[ DOMINS_PERTURB ] = "DOMINS_PERTURB";
		tag2string[ DOMINS_RB ] = "DOMINS_RB";
		tag2string[ DOMINS_LOOP ] = "DOMINS_LOOP";
		tag2string[ DOMINS_FLOP ] = "DOMINS_FLOP";
		tag2string[ DOMINS_RELAX ] = "DOMINS_RELAX";
		tag2string[ DOMINS_MCM ] = "DOMINS_MCM";
		tag2string[ DOMINS_SM ] = "DOMINS_SM";
		tag2string[ DOMINS_SHM ] = "DOMINS_SHM";
		tag2string[ INSERT_LOOP ] = "INSERT_LOOP";
		tag2string[ CST_ENERGY ] = "CST_ENERGY";
		tag2string[ DOCK_REPACK ] = "DOCK_REPACK";
		tag2string[ RTMIN ] = "RTMIN";
		tag2string[ F_E_H2O ] = "F_E_H2O";
		tag2string[ F_E_PAIR ] = "F_E_PAIR";
		tag2string[ DSSP ] = "DSSP";
		/*NEED TO SYNC WITH PROF.h*/
		tag2string[ TOTAL ] = "TOTAL";
	}


	/////////////////////////////////////////////////////////////////////////////
	void
	show()
	{
		// clocks are shown in the unit of 0.01 sec
		if ( !profiling ) return;
		static bool init( false );
		if( !init ) {
			init = true;
			setup_tag2string();
		}

		PROF_STOP( prof::TOTAL );

		std::cout << "========================================\n";
		std::cout << "========================================\n";
		std::cout << "============ PROFILE INFO ==============\n";
		std::cout << "========================================\n";
		std::cout << "========================================\n";
		std::cout << A(12,"clock") << ' ' << A(9,"ncalls") << ' ' << A(9,"bad_calls") << ' ' << A(12,"c/call") << ' ' << "tag\n";
		for ( std::map< Prof_tag, double >::const_iterator it=total_clock.begin();
					it!=total_clock.end(); ++it ) {
			Prof_tag const & tag( it->first );
			double const t( it->second );
			int const ncalls( calls[tag] );
			int const bcalls( bad_calls[tag] );
			std::cout << F(12,2,t) << ' ' << I(9,ncalls) << ' ' << I(9,bcalls)
								<< ' ' << F(12,3, t/ncalls);
			if ( tag2string.count( tag ) ) {
				std::cout << ' ' << tag2string[tag] << std::endl;
			} else {
				std::cout << ' ' << tag << std::endl;
			}
		}
		std::cout << "========================================\n";
		std::cout << "========================================\n";
		std::cout << "========================================\n";
		PROF_START( prof::TOTAL );
	}


	/////////////////////////////////////////////////////////////////////////////
	void
	reset( bool const force_profiling /* = false */ )
	{
		static bool init( false );
		if ( !init ) {
			init = true;
			profiling = truefalseoption("profile");
		}
		if ( force_profiling ) profiling = true;
		if ( !profiling ) return;
		start_clock.clear();
		total_clock.clear();
		calls.clear();
		bad_calls.clear();
		PROF_START( prof::TOTAL );
	}

}

